/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.magic;

import org.aoju.bus.oauth.Builder;

public class Message {
    String errcode;
    String errmsg;
    Object data;

    public boolean ok() {
        return this.errcode == Builder.Status.SUCCESS.getCode();
    }

    Message(String errcode, String errmsg, Object data) {
        this.errcode = errcode;
        this.errmsg = errmsg;
        this.data = data;
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public String getErrcode() {
        return this.errcode;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public Object getData() {
        return this.data;
    }

    public static class MessageBuilder {
        private String errcode;
        private String errmsg;
        private Object data;

        MessageBuilder() {
        }

        public MessageBuilder errcode(String errcode) {
            this.errcode = errcode;
            return this;
        }

        public MessageBuilder errmsg(String errmsg) {
            this.errmsg = errmsg;
            return this;
        }

        public MessageBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public Message build() {
            return new Message(this.errcode, this.errmsg, this.data);
        }

        public String toString() {
            return "Message.MessageBuilder(errcode=" + this.errcode + ", errmsg=" + this.errmsg + ", data=" + this.data + ")";
        }
    }
}

