/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.netty;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.socket.netty.SocketService;

public class SocketClient {
    private Channel channel;
    private List<String> topics = new ArrayList<String>();
    private Long lastUpdateTime = System.currentTimeMillis();
    private Long inactiveTime = 60000L;

    public SocketClient(Channel channel) {
        this.channel = channel;
    }

    public void send(String topic, String message) {
        if (this.topics.contains(topic)) {
            this.channel.writeAndFlush((Object)new TextWebSocketFrame(message));
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    public void send(String message) {
        this.channel.writeAndFlush((Object)new TextWebSocketFrame(message));
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void sendHeartbeat() {
        this.channel.writeAndFlush((Object)new TextWebSocketFrame("{\"e\":\"heartbeat\",\"d\":\"ping\"}"));
    }

    public void receiveHeartbeat() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void subscribe(String topic) {
        if (!this.topics.contains(topic)) {
            this.topics.add(topic);
        }
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void cancel(String data) {
        for (String topic : this.topics) {
            SocketService.onCancel(this, topic, data);
        }
        this.topics.clear();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void cancel(String topic, String data) {
        if (this.topics.contains(topic)) {
            this.topics.remove(topic);
            SocketService.onCancel(this, topic, data);
        }
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public boolean isActive() {
        return System.currentTimeMillis() - this.lastUpdateTime <= this.inactiveTime;
    }

    public boolean needClose() {
        return System.currentTimeMillis() - this.lastUpdateTime > this.inactiveTime * 3L;
    }

    public void close() {
        this.channel.close();
    }
}

