/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.factory;

import java.lang.reflect.Method;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.cron.factory.Task;

public class InvokeTask
implements Task {
    private Class<?> clazz;
    private Object obj;
    private Method method;

    public InvokeTask(String classNameWithMethodName) {
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new InstrumentException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        if (StringUtils.isBlank(className)) {
            throw new IllegalArgumentException("Class name is blank !");
        }
        this.clazz = ClassUtils.loadClass(className);
        if (null == this.clazz) {
            throw new IllegalArgumentException("Load class with name of [" + className + "] fail !");
        }
        this.obj = ReflectUtils.newInstanceIfPossible(this.clazz);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        if (StringUtils.isBlank(methodName)) {
            throw new IllegalArgumentException("Method name is blank !");
        }
        this.method = ClassUtils.getPublicMethod(this.clazz, methodName, new Class[0]);
        if (null == this.method) {
            throw new IllegalArgumentException("No method with name of [" + methodName + "] !");
        }
    }

    @Override
    public void execute() {
        try {
            ReflectUtils.invoke(this.obj, this.method, new Object[0]);
        }
        catch (InstrumentException e) {
            throw new InstrumentException(e.getCause());
        }
    }
}

