/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.RandomUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Holder;
import org.aoju.bus.crypto.Provider;
import org.aoju.bus.crypto.Registry;
import org.aoju.bus.crypto.algorithm.asymmetric.RSA;
import org.aoju.bus.crypto.algorithm.asymmetric.SM2;
import org.aoju.bus.crypto.algorithm.asymmetric.Sign;
import org.aoju.bus.crypto.algorithm.digest.BCrypt;
import org.aoju.bus.crypto.algorithm.digest.Digester;
import org.aoju.bus.crypto.algorithm.digest.HMac;
import org.aoju.bus.crypto.algorithm.digest.MD5;
import org.aoju.bus.crypto.algorithm.digest.mac.BCHMacEngine;
import org.aoju.bus.crypto.algorithm.digest.mac.MacEngine;
import org.aoju.bus.crypto.algorithm.symmetric.AES;
import org.aoju.bus.crypto.algorithm.symmetric.DES;
import org.aoju.bus.crypto.algorithm.symmetric.DESede;
import org.aoju.bus.crypto.algorithm.symmetric.RC4;
import org.aoju.bus.crypto.algorithm.symmetric.Symmetric;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class Builder {
    public static byte[] encrypt(String algorithm, String key, byte[] content) {
        Provider provider = Registry.require(algorithm);
        return provider.encrypt(key, content);
    }

    public static String encrypt(String algorithm, String key, String content, Charset charset) {
        return HexUtils.encodeHexStr(Builder.encrypt(algorithm, key, content.getBytes(charset)));
    }

    public static InputStream encrypt(String algorithm, String key, InputStream inputStream) {
        Provider provider = Registry.require(algorithm);
        return new ByteArrayInputStream(provider.encrypt(key, IoUtils.readBytes(inputStream)));
    }

    public static byte[] decrypt(String algorithm, String key, byte[] content) {
        Provider provider = Registry.require(algorithm);
        return provider.decrypt(key, content);
    }

    public static String decrypt(String algorithm, String key, String content, Charset charset) {
        return new String(Builder.decrypt(algorithm, key, HexUtils.decodeHex(content)), charset);
    }

    public static InputStream decrypt(String algorithm, String key, InputStream inputStream) {
        Provider provider = Registry.require(algorithm);
        return new ByteArrayInputStream(provider.decrypt(key, IoUtils.readBytes(inputStream)));
    }

    public static byte[] decode(String key) {
        return Validator.isHex(key) ? HexUtils.decodeHex(key) : Base64.decode(key);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return Builder.decodeECPoint(Builder.decode(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        ECNamedCurveParameterSpec namedSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        ECCurve curve = namedSpec.getCurve();
        EllipticCurve ecCurve = new EllipticCurve(new ECFieldFp(curve.getField().getCharacteristic()), curve.getA().toBigInteger(), curve.getB().toBigInteger());
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)ecCurve, (byte[])encodeByte);
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, namedSpec.getG(), namedSpec.getN());
        KeyFactory PubKeyGen = Builder.getKeyFactory("EC");
        try {
            return PubKeyGen.generatePublic(new ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
        }
        catch (GeneralSecurityException e) {
            throw new InstrumentException(e);
        }
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(true);
    }

    public static PrivateKey readPrivateKey(InputStream pemStream) {
        return Builder.generateRSAPrivateKey(Builder.readKeyBytes(pemStream));
    }

    public static PublicKey readPublicKey(InputStream pemStream) {
        Certificate certificate = Builder.readX509Certificate(pemStream);
        if (null == certificate) {
            return null;
        }
        return certificate.getPublicKey();
    }

    public static Key readKey(InputStream keyStream) {
        PemObject object = Builder.readPemObject(keyStream);
        String type = object.getType();
        if (StringUtils.isNotBlank(type) && type.endsWith("PRIVATE KEY")) {
            return Builder.generateRSAPrivateKey(object.getContent());
        }
        return Builder.readX509Certificate(keyStream).getPublicKey();
    }

    public static byte[] readKeyBytes(InputStream keyStream) {
        PemObject pemObject = Builder.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader((Reader)IoUtils.getReader(keyStream, org.aoju.bus.core.lang.Charset.UTF_8));
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(pemReader);
                throw throwable;
            }
        }
        IoUtils.close((Closeable)pemReader);
        return pemObject;
    }

    public static byte[] md5(byte[] data) {
        return new MD5().digest(data);
    }

    public static byte[] md5(String data, String charset) {
        return new MD5().digest(data, charset);
    }

    public static byte[] md5(String data) {
        return Builder.md5(data, "UTF-8");
    }

    public static byte[] md5(InputStream data) {
        return new MD5().digest(data);
    }

    public static byte[] md5(File file) {
        return new MD5().digest(file);
    }

    public static String md5Hex(byte[] data) {
        return new MD5().digestHex(data);
    }

    public static String md5Hex(String data, String charset) {
        return new MD5().digestHex(data, charset);
    }

    public static String md5Hex(String data, Charset charset) {
        return new MD5().digestHex(data, charset);
    }

    public static String md5Hex(String data) {
        return Builder.md5Hex(data, "UTF-8");
    }

    public static String md5Hex(InputStream data) {
        return new MD5().digestHex(data);
    }

    public static String md5Hex(File file) {
        return new MD5().digestHex(file);
    }

    public static String md5Hex16(byte[] data) {
        return new MD5().digestHex16(data);
    }

    public static String md5Hex16(String data, Charset charset) {
        return new MD5().digestHex16(data, charset);
    }

    public static String md5Hex16(String data) {
        return Builder.md5Hex16(data, org.aoju.bus.core.lang.Charset.UTF_8);
    }

    public static String md5Hex16(InputStream data) {
        return new MD5().digestHex16(data);
    }

    public static String md5Hex16(File file) {
        return new MD5().digestHex16(file);
    }

    public static String md5HexTo16(String md5Hex) {
        return md5Hex.substring(8, 24);
    }

    public static byte[] sha1(byte[] data) {
        return new Digester("SHA-1").digest(data);
    }

    public static byte[] sha1(String data, String charset) {
        return new Digester("SHA-1").digest(data, charset);
    }

    public static byte[] sha1(String data) {
        return Builder.sha1(data, "UTF-8");
    }

    public static byte[] sha1(InputStream data) {
        return new Digester("SHA-1").digest(data);
    }

    public static byte[] sha1(File file) {
        return new Digester("SHA-1").digest(file);
    }

    public static String sha1Hex(byte[] data) {
        return new Digester("SHA-1").digestHex(data);
    }

    public static String sha1Hex(String data, String charset) {
        return new Digester("SHA-1").digestHex(data, charset);
    }

    public static String sha1Hex(String data) {
        return Builder.sha1Hex(data, "UTF-8");
    }

    public static String sha1Hex(InputStream data) {
        return new Digester("SHA-1").digestHex(data);
    }

    public static String sha1Hex(File file) {
        return new Digester("SHA-1").digestHex(file);
    }

    public static byte[] sha256(byte[] data) {
        return new Digester("SHA-256").digest(data);
    }

    public static byte[] sha256(String data, String charset) {
        return new Digester("SHA-256").digest(data, charset);
    }

    public static byte[] sha256(String data) {
        return Builder.sha256(data, "UTF-8");
    }

    public static byte[] sha256(InputStream data) {
        return new Digester("SHA-256").digest(data);
    }

    public static byte[] sha256(File file) {
        return new Digester("SHA-256").digest(file);
    }

    public static String sha256Hex(byte[] data) {
        return new Digester("SHA-256").digestHex(data);
    }

    public static String sha256Hex(String data, String charset) {
        return new Digester("SHA-256").digestHex(data, charset);
    }

    public static String sha256Hex(String data) {
        return Builder.sha256Hex(data, "UTF-8");
    }

    public static String sha256Hex(InputStream data) {
        return new Digester("SHA-256").digestHex(data);
    }

    public static String sha256Hex(File file) {
        return new Digester("SHA-256").digestHex(file);
    }

    public static HMac hmac(String algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(String algorithm, SecretKey key) {
        return new HMac(algorithm, key);
    }

    public static Digester digester(String algorithm) {
        return new Digester(algorithm);
    }

    public static String hashpw(String password) {
        return new BCrypt().hashpw(password);
    }

    public static boolean checkpw(String password, String hashed) {
        return new BCrypt().checkpw(password, hashed);
    }

    public static SecretKey generateKey(String algorithm) {
        return Builder.generateKey(algorithm, -1);
    }

    public static SecretKey generateKey(String algorithm, int keySize) {
        algorithm = Builder.getMainAlgorithm(algorithm);
        KeyGenerator keyGenerator = Builder.getKeyGenerator(algorithm);
        if (keySize > 0) {
            keyGenerator.init(keySize);
        } else if ("AES".equals(algorithm)) {
            keyGenerator.init(128);
        }
        return keyGenerator.generateKey();
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        Assert.notBlank(algorithm, "Algorithm is blank!", new Object[0]);
        SecretKey secretKey = null;
        secretKey = algorithm.startsWith("PBE") ? Builder.generatePBEKey(algorithm, null == key ? null : StringUtils.str(key, org.aoju.bus.core.lang.Charset.UTF_8).toCharArray()) : (algorithm.startsWith("DES") ? Builder.generateDESKey(algorithm, key) : (null == key ? Builder.generateKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        SecretKey secretKey;
        if (StringUtils.isBlank(algorithm) || !algorithm.startsWith("DES")) {
            throw new InstrumentException("Algorithm [{}] is not a DES algorithm!");
        }
        if (null == key) {
            secretKey = Builder.generateKey(algorithm);
        } else {
            KeySpec keySpec;
            try {
                keySpec = algorithm.startsWith("DESede") ? new DESedeKeySpec(key) : new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new InstrumentException(e);
            }
            secretKey = Builder.generateKey(algorithm, keySpec);
        }
        return secretKey;
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        if (StringUtils.isBlank(algorithm) || !algorithm.startsWith("PBE")) {
            throw new InstrumentException("Algorithm [{}] is not a PBE algorithm!");
        }
        if (null == key) {
            key = RandomUtils.randomString(32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return Builder.generateKey(algorithm, keySpec);
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        SecretKeyFactory keyFactory = Builder.getSecretKeyFactory(algorithm);
        try {
            return keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new InstrumentException(e);
        }
    }

    public static PrivateKey generateRSAPrivateKey(byte[] key) {
        return Builder.generatePrivateKey("RSA", key);
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return Builder.generatePrivateKey(algorithm, new PKCS8EncodedKeySpec(key));
    }

    public static PrivateKey generatePrivateKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = Builder.getAlgorithmAfterWith(algorithm);
        try {
            return Builder.getKeyFactory(algorithm).generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static PublicKey generateRSAPublicKey(byte[] key) {
        return Builder.generatePublicKey("RSA", key);
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        if (null == key) {
            return null;
        }
        return Builder.generatePublicKey(algorithm, new X509EncodedKeySpec(key));
    }

    public static PublicKey generatePublicKey(String algorithm, KeySpec keySpec) {
        if (null == keySpec) {
            return null;
        }
        algorithm = Builder.getAlgorithmAfterWith(algorithm);
        try {
            return Builder.getKeyFactory(algorithm).generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) {
        return Builder.generateKeyPair(algorithm, 1024);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return Builder.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        if ("SM2".equalsIgnoreCase(algorithm)) {
            ECGenParameterSpec sm2p256v1 = new ECGenParameterSpec("sm2p256v1");
            return Builder.generateKeyPair(algorithm, keySize, seed, sm2p256v1);
        }
        return Builder.generateKeyPair(algorithm, keySize, seed, (AlgorithmParameterSpec[])null);
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) {
        return Builder.generateKeyPair(algorithm, null, params);
    }

    public static KeyPair generateKeyPair(String algorithm, byte[] seed, AlgorithmParameterSpec param) {
        return Builder.generateKeyPair(algorithm, 1024, seed, param);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed, AlgorithmParameterSpec ... params) {
        return Builder.generateKeyPair(algorithm, keySize, RandomUtils.getSecureRandom(seed), params);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, SecureRandom random, AlgorithmParameterSpec ... params) {
        algorithm = Builder.getAlgorithmAfterWith(algorithm);
        KeyPairGenerator keyPairGen = Builder.getKeyPairGenerator(algorithm);
        if (keySize > 0) {
            if ("EC".equalsIgnoreCase(algorithm) && keySize > 256) {
                keySize = 256;
            }
            if (null != random) {
                keyPairGen.initialize(keySize, random);
            } else {
                keyPairGen.initialize(keySize);
            }
        }
        if (ArrayUtils.isNotEmpty(params)) {
            for (AlgorithmParameterSpec param : params) {
                if (null == param) continue;
                try {
                    if (null != random) {
                        keyPairGen.initialize(param, random);
                        continue;
                    }
                    keyPairGen.initialize(param);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new InstrumentException(e);
                }
            }
        }
        return keyPairGen.generateKeyPair();
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) {
        KeyPairGenerator keyPairGen;
        java.security.Provider provider = Instances.singletion(Holder.class).getProvider();
        try {
            keyPairGen = null == provider ? KeyPairGenerator.getInstance(Builder.getMainAlgorithm(algorithm)) : KeyPairGenerator.getInstance(Builder.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
        return keyPairGen;
    }

    public static KeyFactory getKeyFactory(String algorithm) {
        KeyFactory keyFactory;
        java.security.Provider provider = Instances.singletion(Holder.class).getProvider();
        try {
            keyFactory = null == provider ? KeyFactory.getInstance(Builder.getMainAlgorithm(algorithm)) : KeyFactory.getInstance(Builder.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
        return keyFactory;
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) {
        SecretKeyFactory keyFactory;
        java.security.Provider provider = Instances.singletion(Holder.class).getProvider();
        try {
            keyFactory = null == provider ? SecretKeyFactory.getInstance(Builder.getMainAlgorithm(algorithm)) : SecretKeyFactory.getInstance(Builder.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
        return keyFactory;
    }

    public static KeyGenerator getKeyGenerator(String algorithm) {
        KeyGenerator generator;
        java.security.Provider provider = Instances.singletion(Holder.class).getProvider();
        try {
            generator = null == provider ? KeyGenerator.getInstance(Builder.getMainAlgorithm(algorithm)) : KeyGenerator.getInstance(Builder.getMainAlgorithm(algorithm), provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
        return generator;
    }

    public static String getMainAlgorithm(String algorithm) {
        int slashIndex = algorithm.indexOf("/");
        if (slashIndex > 0) {
            return algorithm.substring(0, slashIndex);
        }
        return algorithm;
    }

    public static String getAlgorithmAfterWith(String algorithm) {
        Assert.notNull(algorithm, "algorithm must be not null !", new Object[0]);
        int indexOfWith = StringUtils.lastIndexOfIgnoreCase(algorithm, "with");
        if (indexOfWith > 0) {
            algorithm = StringUtils.subSuf(algorithm, indexOfWith + "with".length());
        }
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        return Builder.readKeyStore("JKS", in, password);
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return keyStore;
    }

    public static KeyPair getKeyPair(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = Builder.readKeyStore(type, in, password);
        return Builder.getKeyPair(keyStore, password, alias);
    }

    public static KeyPair getKeyPair(KeyStore keyStore, char[] password, String alias) {
        PrivateKey privateKey;
        PublicKey publicKey;
        try {
            publicKey = keyStore.getCertificate(alias).getPublicKey();
            privateKey = (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return new KeyPair(publicKey, privateKey);
    }

    public static Certificate readX509Certificate(InputStream in, char[] password, String alias) {
        return Builder.readCertificate("X.509", in, password, alias);
    }

    public static PublicKey readPublicKeyFromCert(InputStream in) {
        Certificate certificate = Builder.readX509Certificate(in);
        if (null != certificate) {
            return certificate.getPublicKey();
        }
        return null;
    }

    public static Certificate readX509Certificate(InputStream in) {
        return Builder.readCertificate("X.509", in);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password, String alias) {
        KeyStore keyStore = Builder.readKeyStore(type, in, password);
        try {
            return keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new InstrumentException(e);
        }
    }

    public static Certificate readCertificate(String type, InputStream in) {
        try {
            return Builder.getCertificateFactory(type).generateCertificate(in);
        }
        catch (CertificateException e) {
            throw new InstrumentException(e);
        }
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static CertificateFactory getCertificateFactory(String type) {
        CertificateFactory factory;
        java.security.Provider provider = Instances.singletion(Holder.class).getProvider();
        try {
            factory = null == provider ? CertificateFactory.getInstance(type) : CertificateFactory.getInstance(type, provider);
        }
        catch (CertificateException e) {
            throw new InstrumentException(e);
        }
        return factory;
    }

    public static String generateAlgorithm(String asymmetricAlgorithm, String algorithm) {
        String digestPart = null == algorithm ? "NONE" : algorithm;
        return StringUtils.format("{}with{}", digestPart, asymmetricAlgorithm);
    }

    public static Signature generateSignature(String asymmetricAlgorithm, String algorithm) {
        try {
            return Signature.getInstance(Builder.generateAlgorithm(asymmetricAlgorithm, algorithm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
    }

    public static AES aes() {
        return new AES();
    }

    public static AES aes(byte[] key) {
        return new AES(key);
    }

    public static DES des() {
        return new DES();
    }

    public static DES des(byte[] key) {
        return new DES(key);
    }

    public static DESede desede() {
        return new DESede();
    }

    public static DESede desede(byte[] key) {
        return new DESede(key);
    }

    public static MD5 md5() {
        return new MD5();
    }

    public static Digester sha1() {
        return new Digester("SHA-1");
    }

    public static Digester sha256() {
        return new Digester("SHA-256");
    }

    public static HMac hmac(String algorithm, String key) {
        return new HMac(algorithm, StringUtils.bytes(key));
    }

    public static HMac hmacMd5(String key) {
        return Builder.hmacMd5(StringUtils.bytes(key));
    }

    public static HMac hmacMd5(byte[] key) {
        return new HMac("HmacMD5", key);
    }

    public static HMac hmacMd5() {
        return new HMac("HmacMD5");
    }

    public static HMac hmacSha1(String key) {
        return Builder.hmacSha1(StringUtils.bytes(key));
    }

    public static HMac hmacSha1(byte[] key) {
        return new HMac("HmacSHA1", key);
    }

    public static HMac hmacSha1() {
        return new HMac("HmacSHA1");
    }

    public static RSA rsa() {
        return new RSA();
    }

    public static RSA rsa(String privateKey, String publicKey) {
        return new RSA(privateKey, publicKey);
    }

    public static RSA rsa(byte[] privateKey, byte[] publicKey) {
        return new RSA(privateKey, publicKey);
    }

    public static Sign sign(String algorithm) {
        return new Sign(algorithm);
    }

    public static Sign sign(String algorithm, String privateKey, String publicKey) {
        return new Sign(algorithm, privateKey, publicKey);
    }

    public static Sign sign(String algorithm, byte[] privateKey, byte[] publicKey) {
        return new Sign(algorithm, privateKey, publicKey);
    }

    public static String signParams(Symmetric crypto, Map<?, ?> params) {
        return Builder.signParams(crypto, params, "", "", true);
    }

    public static String signParams(Symmetric crypto, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        String paramsStr = MapUtils.join(MapUtils.sort(params), separator, keyValueSeparator, isIgnoreNull);
        return crypto.encryptHex(paramsStr);
    }

    public static String signParamsMd5(Map<?, ?> params) {
        return Builder.signParams("MD5", params);
    }

    public static String signParamsSha1(Map<?, ?> params) {
        return Builder.signParams("SHA-1", params);
    }

    public static String signParamsSha256(Map<?, ?> params) {
        return Builder.signParams("SHA-256", params);
    }

    public static String signParams(String algorithm, Map<?, ?> params) {
        return Builder.signParams(algorithm, params, "", "", true);
    }

    public static String signParams(String algorithm, Map<?, ?> params, String separator, String keyValueSeparator, boolean isIgnoreNull) {
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        String paramsStr = MapUtils.join(MapUtils.sort(params), separator, keyValueSeparator, isIgnoreNull);
        return new Digester(algorithm).digestHex(paramsStr);
    }

    public static void addProvider(java.security.Provider provider) {
        Security.insertProviderAt(provider, 0);
    }

    public static Cipher createCipher(String algorithm) {
        Cipher cipher;
        java.security.Provider provider = Instances.singletion(Holder.class).getProvider();
        try {
            cipher = null == provider ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        return cipher;
    }

    public static MessageDigest createMessageDigest(String algorithm) {
        MessageDigest messageDigest;
        java.security.Provider provider = Instances.singletion(Holder.class).getProvider();
        try {
            messageDigest = null == provider ? MessageDigest.getInstance(algorithm) : MessageDigest.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
        return messageDigest;
    }

    public static Mac createMac(String algorithm) {
        Mac mac;
        java.security.Provider provider = Instances.singletion(Holder.class).getProvider();
        try {
            mac = null == provider ? Mac.getInstance(algorithm) : Mac.getInstance(algorithm, provider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InstrumentException(e);
        }
        return mac;
    }

    public static RC4 rc4(String key) {
        return new RC4(key);
    }

    public static void disableBouncyCastle() {
        Instances.singletion(Holder.class);
        Holder.setUseBouncyCastle(false);
    }

    public static SM2 sm2() {
        return new SM2();
    }

    public static SM2 sm2(String privateKey, String publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static SM2 sm2(byte[] privateKey, byte[] publicKey) {
        return new SM2(privateKey, publicKey);
    }

    public static Digester sm3() {
        return new Digester("SM3");
    }

    public static String sm3(String data) {
        return new Digester("SM3").digestHex(data);
    }

    public static String sm3(InputStream data) {
        return new Digester("SM3").digestHex(data);
    }

    public static String sm3(File dataFile) {
        return new Digester("SM3").digestHex(dataFile);
    }

    public static Symmetric sm4() {
        return new Symmetric("SM4");
    }

    public static Symmetric sm4(byte[] key) {
        return new Symmetric("SM4", key);
    }

    public static byte[] changeC1C2C3ToC1C3C2(byte[] c1c2c3, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, result, 0, c1Len);
        System.arraycopy(c1c2c3, c1c2c3.length - 32, result, c1Len, 32);
        System.arraycopy(c1c2c3, c1Len, result, c1Len + 32, c1c2c3.length - c1Len - 32);
        return result;
    }

    public static byte[] changeC1C3C2ToC1C2C3(byte[] c1c3c2, ECDomainParameters ecDomainParameters) {
        int c1Len = (ecDomainParameters.getCurve().getFieldSize() + 7) / 8 * 2 + 1;
        int c3Len = 32;
        byte[] result = new byte[c1c3c2.length];
        System.arraycopy(c1c3c2, 0, result, 0, c1Len);
        System.arraycopy(c1c3c2, c1Len + 32, result, c1Len, c1c3c2.length - c1Len - 32);
        System.arraycopy(c1c3c2, c1Len, result, c1c3c2.length - 32, 32);
        return result;
    }

    public static byte[] rsAsn1ToPlain(byte[] rsDer) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)rsDer);
        byte[] r = Builder.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue());
        byte[] s = Builder.bigIntToFixexLengthBytes(ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        byte[] result = new byte[64];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, 32, s.length);
        return result;
    }

    public static byte[] rsPlainToAsn1(byte[] sign) {
        if (sign.length != 64) {
            throw new InstrumentException("err rs. ");
        }
        BigInteger r = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)0, (int)32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange((byte[])sign, (int)32, (int)64));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            return new DERSequence(v).getEncoded("DER");
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static MacEngine createHmacSm3Engine(byte[] key) {
        return new BCHMacEngine((Digest)new SM3Digest(), key);
    }

    public static HMac hmacSm3(byte[] key) {
        return new HMac("HmacSM3", key);
    }

    private static byte[] bigIntToFixexLengthBytes(BigInteger rOrS) {
        byte[] rs = rOrS.toByteArray();
        if (rs.length == 32) {
            return rs;
        }
        if (rs.length == 33 && rs[0] == 0) {
            return Arrays.copyOfRange((byte[])rs, (int)1, (int)33);
        }
        if (rs.length < 32) {
            byte[] result = new byte[32];
            Arrays.fill((byte[])result, (byte)0);
            System.arraycopy(rs, 0, result, 32 - rs.length, rs.length);
            return result;
        }
        throw new InstrumentException("Error rs: {}", Hex.toHexString((byte[])rs));
    }
}

