/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.provider;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Provider;
import org.aoju.bus.crypto.algorithm.asymmetric.KeyType;
import org.aoju.bus.crypto.algorithm.asymmetric.SM2;

public class SM2Provider
implements Provider {
    @Override
    public byte[] encrypt(String key, byte[] content) {
        if (StringUtils.isEmpty(key)) {
            throw new InstrumentException("key is null!");
        }
        String[] array = StringUtils.split((CharSequence)key, ",");
        SM2 sm2 = Builder.sm2(array[0], array[1]);
        sm2.setMode(SM2.SM2Mode.C1C3C2);
        return sm2.encrypt(content, KeyType.valueOf(array[2]));
    }

    @Override
    public byte[] decrypt(String key, byte[] content) {
        if (StringUtils.isEmpty(key)) {
            throw new InstrumentException("key is null!");
        }
        String[] array = StringUtils.split((CharSequence)key, ",");
        SM2 sm2 = Builder.sm2(array[0], array[1]);
        sm2.setMode(SM2.SM2Mode.C1C3C2);
        return sm2.decrypt(content, KeyType.valueOf(array[2]));
    }
}

