/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware;

import java.util.function.Supplier;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.hardware.Baseboard;
import org.aoju.bus.health.hardware.ComputerSystem;
import org.aoju.bus.health.hardware.Firmware;

public abstract class AbstractComputerSystem
implements ComputerSystem {
    private final Supplier<Firmware> firmware = Memoizer.memoize(this::createFirmware);
    private final Supplier<Baseboard> baseboard = Memoizer.memoize(this::createBaseboard);

    @Override
    public Firmware getFirmware() {
        return this.firmware.get();
    }

    protected abstract Firmware createFirmware();

    @Override
    public Baseboard getBaseboard() {
        return this.baseboard.get();
    }

    protected abstract Baseboard createBaseboard();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("manufacturer=").append(this.getManufacturer()).append(", ");
        sb.append("model=").append(this.getModel()).append(", ");
        sb.append("serial number=").append(this.getSerialNumber());
        return sb.toString();
    }
}

