/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.mac;

import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.util.ArrayList;
import org.aoju.bus.health.hardware.AbstractDisplay;
import org.aoju.bus.health.hardware.Display;
import org.aoju.bus.logger.Logger;

public class MacDisplay
extends AbstractDisplay {
    public MacDisplay(byte[] edid) {
        super(edid);
        Logger.debug("Initialized MacDisplay", new Object[0]);
    }

    public static Display[] getDisplays() {
        ArrayList<MacDisplay> displays = new ArrayList<MacDisplay>();
        IOKit.IOIterator serviceIterator = IOKitUtil.getMatchingServices((String)"IODisplayConnect");
        if (serviceIterator != null) {
            CoreFoundation.CFStringRef cfEdid = CoreFoundation.CFStringRef.createCFString((String)"IODisplayEDID");
            IOKit.IORegistryEntry sdService = serviceIterator.next();
            while (sdService != null) {
                IOKit.IORegistryEntry properties = sdService.getChildEntry("IOService");
                if (properties != null) {
                    CoreFoundation.CFTypeRef edidRaw = properties.createCFProperty(cfEdid);
                    if (edidRaw != null) {
                        CoreFoundation.CFDataRef edid = new CoreFoundation.CFDataRef(edidRaw.getPointer());
                        int length = edid.getLength();
                        Pointer p = edid.getBytePtr();
                        displays.add(new MacDisplay(p.getByteArray(0L, length)));
                        edid.release();
                    }
                    properties.release();
                }
                sdService.release();
                sdService = serviceIterator.next();
            }
            serviceIterator.release();
            cfEdid.release();
        }
        return displays.toArray(new Display[0]);
    }
}

