/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.windows;

import com.sun.jna.platform.win32.IPHlpAPI;
import com.sun.jna.platform.win32.VersionHelpers;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.hardware.AbstractNetworks;
import org.aoju.bus.health.hardware.NetworkIF;
import org.aoju.bus.logger.Logger;

public class WindowsNetworks
extends AbstractNetworks {
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();

    public static void updateNetworkStats(NetworkIF netIF) {
        if (IS_VISTA_OR_GREATER) {
            IPHlpAPI.MIB_IF_ROW2 ifRow = new IPHlpAPI.MIB_IF_ROW2();
            ifRow.InterfaceIndex = netIF.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry2(ifRow)) {
                Logger.error("Failed to retrieve data for interface {}, {}", netIF.queryNetworkInterface().getIndex(), netIF.getName());
                return;
            }
            netIF.setBytesSent(ifRow.OutOctets);
            netIF.setBytesRecv(ifRow.InOctets);
            netIF.setPacketsSent(ifRow.OutUcastPkts);
            netIF.setPacketsRecv(ifRow.InUcastPkts);
            netIF.setOutErrors(ifRow.OutErrors);
            netIF.setInErrors(ifRow.InErrors);
            netIF.setSpeed(ifRow.ReceiveLinkSpeed);
        } else {
            IPHlpAPI.MIB_IFROW ifRow = new IPHlpAPI.MIB_IFROW();
            ifRow.dwIndex = netIF.queryNetworkInterface().getIndex();
            if (0 != IPHlpAPI.INSTANCE.GetIfEntry(ifRow)) {
                Logger.error("Failed to retrieve data for interface {}, {}", netIF.queryNetworkInterface().getIndex(), netIF.getName());
                return;
            }
            netIF.setBytesSent(Builder.unsignedIntToLong(ifRow.dwOutOctets));
            netIF.setBytesRecv(Builder.unsignedIntToLong(ifRow.dwInOctets));
            netIF.setPacketsSent(Builder.unsignedIntToLong(ifRow.dwOutUcastPkts));
            netIF.setPacketsRecv(Builder.unsignedIntToLong(ifRow.dwInUcastPkts));
            netIF.setOutErrors(Builder.unsignedIntToLong(ifRow.dwOutErrors));
            netIF.setInErrors(Builder.unsignedIntToLong(ifRow.dwInErrors));
            netIF.setSpeed(Builder.unsignedIntToLong(ifRow.dwSpeed));
        }
        netIF.setTimeStamp(System.currentTimeMillis());
    }
}

