/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SecureCacheResponse;
import java.net.URI;
import java.net.URLConnection;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import org.aoju.bus.core.io.BufferSource;
import org.aoju.bus.core.io.Sink;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.http.Builder;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.accord.platform.Platform;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.cache.CacheRequest;
import org.aoju.bus.http.metric.Handshake;
import org.aoju.bus.http.metric.http.DelegatingConnection;
import org.aoju.bus.http.metric.http.HttpHeaders;
import org.aoju.bus.http.metric.http.HttpMethod;
import org.aoju.bus.http.metric.http.StatusLine;
import org.aoju.bus.http.secure.CipherSuite;
import org.aoju.bus.http.secure.TlsVersion;

public final class NetApiConvert {
    private static final String SENT_MILLIS = Platform.get().getPrefix() + "-Sent-Millis";
    private static final String RECEIVED_MILLIS = Platform.get().getPrefix() + "-Received-Millis";

    private NetApiConvert() {
    }

    public static Response createResponseForCachePut(URI uri, URLConnection urlConnection) throws IOException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)urlConnection;
        Response.Builder responseBuilder = new Response.Builder();
        Headers responseHeaders = NetApiConvert.createHeaders(urlConnection.getHeaderFields());
        Headers varyHeaders = NetApiConvert.varyHeaders(urlConnection, responseHeaders);
        if (varyHeaders == null) {
            return null;
        }
        String requestMethod = httpUrlConnection.getRequestMethod();
        RequestBody placeholderBody = HttpMethod.requiresRequestBody(requestMethod) ? RequestBody.create(null, Normal.EMPTY_BYTE_ARRAY) : null;
        Request request = new Request.Builder().url(uri.toString()).method(requestMethod, placeholderBody).headers(varyHeaders).build();
        responseBuilder.request(request);
        StatusLine statusLine = StatusLine.parse(NetApiConvert.extractStatusLine(httpUrlConnection));
        responseBuilder.protocol(statusLine.protocol);
        responseBuilder.code(statusLine.code);
        responseBuilder.message(statusLine.message);
        Response networkResponse = responseBuilder.build();
        responseBuilder.networkResponse(networkResponse);
        Headers headers = NetApiConvert.extractResponseHeaders(httpUrlConnection, responseBuilder);
        responseBuilder.headers(headers);
        ResponseBody body = NetApiConvert.createBody(urlConnection);
        responseBuilder.body(body);
        if (httpUrlConnection instanceof HttpsURLConnection) {
            Certificate[] peerCertificates;
            HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)httpUrlConnection;
            try {
                peerCertificates = httpsUrlConnection.getServerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                peerCertificates = null;
            }
            Certificate[] localCertificates = httpsUrlConnection.getLocalCertificates();
            String cipherSuiteString = httpsUrlConnection.getCipherSuite();
            CipherSuite cipherSuite = CipherSuite.forJavaName(cipherSuiteString);
            Handshake handshake = Handshake.get(TlsVersion.SSL_3_0, cipherSuite, NetApiConvert.nullSafeImmutableList(peerCertificates), NetApiConvert.nullSafeImmutableList(localCertificates));
            responseBuilder.handshake(handshake);
        }
        return responseBuilder.build();
    }

    private static Headers createHeaders(Map<String, List<String>> headers) {
        Headers.Builder builder = new Headers.Builder();
        for (Map.Entry<String, List<String>> header : headers.entrySet()) {
            if (header.getKey() == null || header.getValue() == null) continue;
            String name = header.getKey().trim();
            for (String value : header.getValue()) {
                String trimmedValue = value.trim();
                Builder.instance.addLenient(builder, name, trimmedValue);
            }
        }
        return builder.build();
    }

    private static Headers varyHeaders(URLConnection urlConnection, Headers responseHeaders) {
        if (HttpHeaders.hasVaryAll(responseHeaders)) {
            return null;
        }
        Set<String> varyFields = HttpHeaders.varyFields(responseHeaders);
        if (varyFields.isEmpty()) {
            return new Headers.Builder().build();
        }
        if (!(urlConnection instanceof CacheHttpURLConnection) && !(urlConnection instanceof CacheHttpsURLConnection)) {
            return null;
        }
        Map<String, List<String>> requestProperties = urlConnection.getRequestProperties();
        Headers.Builder result = new Headers.Builder();
        for (String fieldName : varyFields) {
            List<String> fieldValues = requestProperties.get(fieldName);
            if (fieldValues == null) {
                if (!fieldName.equals("Accept-Encoding")) continue;
                result.add("Accept-Encoding", "gzip");
                continue;
            }
            for (String fieldValue : fieldValues) {
                Builder.instance.addLenient(result, fieldName, fieldValue);
            }
        }
        return result.build();
    }

    static Response createResponseForCacheGet(Request request, CacheResponse javaResponse) throws IOException {
        Headers responseHeaders = NetApiConvert.createHeaders(javaResponse.getHeaders());
        Headers varyHeaders = HttpHeaders.hasVaryAll(responseHeaders) ? new Headers.Builder().build() : HttpHeaders.varyHeaders(request.headers(), responseHeaders);
        Request cacheRequest = new Request.Builder().url(request.url()).method(request.method(), null).headers(varyHeaders).build();
        Response.Builder responseBuilder = new Response.Builder();
        responseBuilder.request(cacheRequest);
        StatusLine statusLine = StatusLine.parse(NetApiConvert.extractStatusLine(javaResponse));
        responseBuilder.protocol(statusLine.protocol);
        responseBuilder.code(statusLine.code);
        responseBuilder.message(statusLine.message);
        Headers headers = NetApiConvert.extractHeaders(javaResponse, responseBuilder);
        responseBuilder.headers(headers);
        ResponseBody body = NetApiConvert.createBody(headers, javaResponse);
        responseBuilder.body(body);
        if (javaResponse instanceof SecureCacheResponse) {
            List<Certificate> peerCertificates;
            SecureCacheResponse javaSecureCacheResponse = (SecureCacheResponse)javaResponse;
            try {
                peerCertificates = javaSecureCacheResponse.getServerCertificateChain();
            }
            catch (SSLPeerUnverifiedException e) {
                peerCertificates = Collections.emptyList();
            }
            List<Certificate> localCertificates = javaSecureCacheResponse.getLocalCertificateChain();
            if (localCertificates == null) {
                localCertificates = Collections.emptyList();
            }
            String cipherSuiteString = javaSecureCacheResponse.getCipherSuite();
            CipherSuite cipherSuite = CipherSuite.forJavaName(cipherSuiteString);
            Handshake handshake = Handshake.get(TlsVersion.SSL_3_0, cipherSuite, peerCertificates, localCertificates);
            responseBuilder.handshake(handshake);
        }
        return responseBuilder.build();
    }

    public static Request createRequest(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) {
        RequestBody placeholderBody = HttpMethod.requiresRequestBody(requestMethod) ? RequestBody.create(null, Normal.EMPTY_BYTE_ARRAY) : null;
        Request.Builder builder = new Request.Builder().url(uri.toString()).method(requestMethod, placeholderBody);
        if (requestHeaders != null) {
            Headers headers = NetApiConvert.extractHeaders(requestHeaders, null);
            builder.headers(headers);
        }
        return builder.build();
    }

    public static CacheResponse createJavaCacheResponse(final Response response) {
        final Headers headers = NetApiConvert.withSyntheticHeaders(response);
        final ResponseBody body = response.body();
        if (response.request().isHttps()) {
            final Handshake handshake = response.handshake();
            return new SecureCacheResponse(){

                @Override
                public String getCipherSuite() {
                    return handshake != null ? handshake.cipherSuite().javaName() : null;
                }

                @Override
                public List<Certificate> getLocalCertificateChain() {
                    if (handshake == null) {
                        return null;
                    }
                    List<Certificate> certificates = handshake.localCertificates();
                    return certificates.size() > 0 ? certificates : null;
                }

                @Override
                public List<Certificate> getServerCertificateChain() {
                    if (handshake == null) {
                        return null;
                    }
                    List<Certificate> certificates = handshake.peerCertificates();
                    return certificates.size() > 0 ? certificates : null;
                }

                @Override
                public Principal getPeerPrincipal() {
                    if (handshake == null) {
                        return null;
                    }
                    return handshake.peerPrincipal();
                }

                @Override
                public Principal getLocalPrincipal() {
                    if (handshake == null) {
                        return null;
                    }
                    return handshake.localPrincipal();
                }

                @Override
                public Map<String, List<String>> getHeaders() {
                    return org.aoju.bus.http.metric.http.HttpURLConnection.toMultimap(headers, StatusLine.get(response).toString());
                }

                @Override
                public InputStream getBody() {
                    if (body == null) {
                        return null;
                    }
                    return body.byteStream();
                }
            };
        }
        return new CacheResponse(){

            @Override
            public Map<String, List<String>> getHeaders() {
                return org.aoju.bus.http.metric.http.HttpURLConnection.toMultimap(headers, StatusLine.get(response).toString());
            }

            @Override
            public InputStream getBody() {
                if (body == null) {
                    return null;
                }
                return body.byteStream();
            }
        };
    }

    public static java.net.CacheRequest createJavaCacheRequest(final CacheRequest cacheRequest) {
        return new java.net.CacheRequest(){

            @Override
            public void abort() {
                cacheRequest.abort();
            }

            @Override
            public OutputStream getBody() throws IOException {
                Sink body = cacheRequest.body();
                if (body == null) {
                    return null;
                }
                return IoUtils.buffer(body).outputStream();
            }
        };
    }

    static HttpURLConnection createJavaUrlConnectionForCachePut(Response response) {
        Request request = (response = response.newBuilder().body(null).headers(NetApiConvert.withSyntheticHeaders(response)).build()).request();
        if (request.isHttps()) {
            return new CacheHttpsURLConnection(new CacheHttpURLConnection(response));
        }
        return new CacheHttpURLConnection(response);
    }

    private static Headers withSyntheticHeaders(Response response) {
        return response.headers().newBuilder().add(SENT_MILLIS, Long.toString(response.sentRequestAtMillis())).add(RECEIVED_MILLIS, Long.toString(response.receivedResponseAtMillis())).build();
    }

    static Map<String, List<String>> extractJavaHeaders(Request request) {
        return org.aoju.bus.http.metric.http.HttpURLConnection.toMultimap(request.headers(), null);
    }

    private static Headers extractHeaders(CacheResponse javaResponse, Response.Builder responseBuilder) throws IOException {
        Map<String, List<String>> javaResponseHeaders = javaResponse.getHeaders();
        return NetApiConvert.extractHeaders(javaResponseHeaders, responseBuilder);
    }

    private static Headers extractResponseHeaders(HttpURLConnection httpUrlConnection, Response.Builder responseBuilder) {
        Map<String, List<String>> javaResponseHeaders = httpUrlConnection.getHeaderFields();
        return NetApiConvert.extractHeaders(javaResponseHeaders, responseBuilder);
    }

    static Headers extractHeaders(Map<String, List<String>> javaHeaders, Response.Builder responseBuilder) {
        Headers.Builder headersBuilder = new Headers.Builder();
        for (Map.Entry<String, List<String>> javaHeader : javaHeaders.entrySet()) {
            String name = javaHeader.getKey();
            if (name == null) continue;
            if (responseBuilder != null && javaHeader.getValue().size() == 1) {
                if (name.equals(SENT_MILLIS)) {
                    responseBuilder.sentRequestAtMillis(Long.valueOf(javaHeader.getValue().get(0)));
                    continue;
                }
                if (name.equals(RECEIVED_MILLIS)) {
                    responseBuilder.receivedResponseAtMillis(Long.valueOf(javaHeader.getValue().get(0)));
                    continue;
                }
            }
            for (String value : javaHeader.getValue()) {
                Builder.instance.addLenient(headersBuilder, name, value);
            }
        }
        return headersBuilder.build();
    }

    private static String extractStatusLine(HttpURLConnection httpUrlConnection) {
        return httpUrlConnection.getHeaderField(null);
    }

    private static String extractStatusLine(CacheResponse javaResponse) throws IOException {
        Map<String, List<String>> javaResponseHeaders = javaResponse.getHeaders();
        return NetApiConvert.extractStatusLine(javaResponseHeaders);
    }

    static String extractStatusLine(Map<String, List<String>> javaResponseHeaders) throws ProtocolException {
        List<String> values = javaResponseHeaders.get(null);
        if (values == null || values.size() == 0) {
            throw new ProtocolException("CacheResponse is missing a 'null' header containing the status line. Headers=" + javaResponseHeaders);
        }
        return values.get(0);
    }

    private static ResponseBody createBody(final Headers headers, CacheResponse cacheResponse) throws IOException {
        final BufferSource body = IoUtils.buffer(IoUtils.source(cacheResponse.getBody()));
        return new ResponseBody(){

            @Override
            public MediaType contentType() {
                String contentTypeHeader = headers.get("Content-Type");
                return contentTypeHeader == null ? null : MediaType.valueOf(contentTypeHeader);
            }

            @Override
            public long contentLength() {
                return HttpHeaders.contentLength(headers);
            }

            @Override
            public BufferSource source() {
                return body;
            }
        };
    }

    private static ResponseBody createBody(final URLConnection urlConnection) throws IOException {
        if (!urlConnection.getDoInput()) {
            return null;
        }
        final BufferSource body = IoUtils.buffer(IoUtils.source(urlConnection.getInputStream()));
        return new ResponseBody(){

            @Override
            public MediaType contentType() {
                String contentTypeHeader = urlConnection.getContentType();
                return contentTypeHeader == null ? null : MediaType.valueOf(contentTypeHeader);
            }

            @Override
            public long contentLength() {
                String s = urlConnection.getHeaderField("Content-Length");
                return NetApiConvert.stringToLong(s);
            }

            @Override
            public BufferSource source() {
                return body;
            }
        };
    }

    private static RuntimeException throwRequestModificationException() {
        throw new UnsupportedOperationException("ResponseCache cannot modify the request.");
    }

    private static RuntimeException throwRequestSslAccessException() {
        throw new UnsupportedOperationException("ResponseCache cannot access SSL internals");
    }

    private static RuntimeException throwResponseBodyAccessException() {
        throw new UnsupportedOperationException("ResponseCache cannot access the response body.");
    }

    private static <T> List<T> nullSafeImmutableList(T[] elements) {
        return elements == null ? Collections.emptyList() : Builder.immutableList(elements);
    }

    private static long stringToLong(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static final class CacheHttpsURLConnection
    extends DelegatingConnection {
        private final CacheHttpURLConnection delegate;

        CacheHttpsURLConnection(CacheHttpURLConnection delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        protected Handshake handshake() {
            return this.delegate.response.handshake();
        }

        @Override
        public HostnameVerifier getHostnameVerifier() {
            throw NetApiConvert.throwRequestSslAccessException();
        }

        @Override
        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public SSLSocketFactory getSSLSocketFactory() {
            throw NetApiConvert.throwRequestSslAccessException();
        }

        @Override
        public void setSSLSocketFactory(SSLSocketFactory socketFactory) {
            throw NetApiConvert.throwRequestModificationException();
        }
    }

    private static final class CacheHttpURLConnection
    extends HttpURLConnection {
        private final Request request;
        private final Response response;

        CacheHttpURLConnection(Response response) {
            super(response.request().url().url());
            this.request = response.request();
            this.response = response;
            this.connected = true;
            this.doOutput = this.request.body() != null;
            this.doInput = true;
            this.useCaches = true;
            this.method = this.request.method();
        }

        @Override
        public void connect() {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public void disconnect() {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public void setRequestProperty(String key, String value) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public void addRequestProperty(String key, String value) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public String getRequestProperty(String key) {
            return this.request.header(key);
        }

        @Override
        public Map<String, List<String>> getRequestProperties() {
            return org.aoju.bus.http.metric.http.HttpURLConnection.toMultimap(this.request.headers(), null);
        }

        @Override
        public void setFixedLengthStreamingMode(int contentLength) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public void setFixedLengthStreamingMode(long contentLength) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public void setChunkedStreamingMode(int chunklen) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public boolean getInstanceFollowRedirects() {
            return super.getInstanceFollowRedirects();
        }

        @Override
        public void setInstanceFollowRedirects(boolean followRedirects) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public String getRequestMethod() {
            return this.request.method();
        }

        @Override
        public void setRequestMethod(String method) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public String getHeaderFieldKey(int position) {
            if (position < 0) {
                throw new IllegalArgumentException("Invalid header index: " + position);
            }
            if (position == 0 || position > this.response.headers().size()) {
                return null;
            }
            return this.response.headers().name(position - 1);
        }

        @Override
        public String getHeaderField(int position) {
            if (position < 0) {
                throw new IllegalArgumentException("Invalid header index: " + position);
            }
            if (position == 0) {
                return StatusLine.get(this.response).toString();
            }
            if (position > this.response.headers().size()) {
                return null;
            }
            return this.response.headers().value(position - 1);
        }

        @Override
        public String getHeaderField(String fieldName) {
            return fieldName == null ? StatusLine.get(this.response).toString() : this.response.headers().get(fieldName);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return org.aoju.bus.http.metric.http.HttpURLConnection.toMultimap(this.response.headers(), StatusLine.get(this.response).toString());
        }

        @Override
        public int getResponseCode() {
            return this.response.code();
        }

        @Override
        public String getResponseMessage() {
            return this.response.message();
        }

        @Override
        public InputStream getErrorStream() {
            return null;
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public int getConnectTimeout() {
            return 0;
        }

        @Override
        public void setConnectTimeout(int timeout) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public int getReadTimeout() {
            return 0;
        }

        @Override
        public void setReadTimeout(int timeout) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public Object getContent() {
            throw NetApiConvert.throwResponseBodyAccessException();
        }

        public Object getContent(Class[] classes) {
            throw NetApiConvert.throwResponseBodyAccessException();
        }

        @Override
        public InputStream getInputStream() {
            return new InputStream(){

                @Override
                public int read() {
                    throw NetApiConvert.throwResponseBodyAccessException();
                }
            };
        }

        @Override
        public OutputStream getOutputStream() {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public boolean getDoInput() {
            return this.doInput;
        }

        @Override
        public void setDoInput(boolean doInput) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public boolean getDoOutput() {
            return this.doOutput;
        }

        @Override
        public void setDoOutput(boolean doOutput) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public boolean getAllowUserInteraction() {
            return false;
        }

        @Override
        public void setAllowUserInteraction(boolean allowUserInteraction) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public boolean getUseCaches() {
            return super.getUseCaches();
        }

        @Override
        public void setUseCaches(boolean useCaches) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public long getIfModifiedSince() {
            return NetApiConvert.stringToLong(this.request.headers().get("If-Modified-Since"));
        }

        @Override
        public void setIfModifiedSince(long ifModifiedSince) {
            throw NetApiConvert.throwRequestModificationException();
        }

        @Override
        public boolean getDefaultUseCaches() {
            return super.getDefaultUseCaches();
        }

        @Override
        public void setDefaultUseCaches(boolean defaultUseCaches) {
            super.setDefaultUseCaches(defaultUseCaches);
        }
    }
}

