/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.cache;

import java.io.File;
import java.io.IOException;
import java.net.CacheResponse;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.cache.Cache;
import org.aoju.bus.http.cache.CacheRequest;
import org.aoju.bus.http.cache.NetApiConvert;

public class ResponseCache
extends java.net.ResponseCache {
    private final Cache delegate;

    private ResponseCache(Cache delegate) {
        this.delegate = delegate;
    }

    public static ResponseCache create(File directory, long maxSize) {
        Cache cache = new Cache(directory, maxSize);
        return new ResponseCache(cache);
    }

    public boolean isEquivalent(File directory, long maxSize) {
        Cache installedCache = this.getCache();
        return installedCache.directory().equals(directory) && installedCache.maxSize() == maxSize && !installedCache.isClosed();
    }

    public Cache getCache() {
        return this.delegate;
    }

    @Override
    public CacheResponse get(URI uri, String requestMethod, Map<String, List<String>> requestHeaders) throws IOException {
        Request request = NetApiConvert.createRequest(uri, requestMethod, requestHeaders);
        Response response = this.delegate.internalCache.get(request);
        if (response == null) {
            return null;
        }
        return NetApiConvert.createJavaCacheResponse(response);
    }

    @Override
    public java.net.CacheRequest put(URI uri, URLConnection urlConnection) throws IOException {
        Response response = NetApiConvert.createResponseForCachePut(uri, urlConnection);
        if (response == null) {
            return null;
        }
        CacheRequest cacheRequest = this.delegate.internalCache.put(response);
        if (cacheRequest == null) {
            return null;
        }
        return NetApiConvert.createJavaCacheRequest(cacheRequest);
    }

    public long size() throws IOException {
        return this.delegate.size();
    }

    public long maxSize() {
        return this.delegate.maxSize();
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public int getNetworkCount() {
        return this.delegate.networkCount();
    }

    public int getHitCount() {
        return this.delegate.hitCount();
    }

    public int getRequestCount() {
        return this.delegate.requestCount();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void delete() throws IOException {
        this.delegate.delete();
    }
}

