/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class RenrenProvider
extends DefaultProvider {
    public RenrenProvider(Context context) {
        super(context, Registry.RENREN);
    }

    public RenrenProvider(Context context, StateCache stateCache) {
        super(context, Registry.RENREN, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        return this.getToken(this.accessTokenUrl(Callback2.getCode()));
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(token)).getJSONObject("response");
        return Property.builder().uuid(object.getString("id")).avatar(this.getAvatarUrl(object)).nickname(object.getString("name")).company(this.getCompany(object)).gender(this.getGender(object)).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken token) {
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(token.getRefreshToken()))).build();
    }

    private AccToken getToken(String url) {
        JSONObject object = JSONObject.parseObject((String)Httpx.post(url));
        if (object.containsKey((Object)"error")) {
            throw new InstrumentException("Failed to get token from Renren: " + object);
        }
        return AccToken.builder().tokenType(object.getString("token_type")).expireIn(object.getIntValue("expires_in")).accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).openId(object.getJSONObject("user").getString("id")).build();
    }

    private String getAvatarUrl(JSONObject userObj) {
        JSONArray jsonArray = userObj.getJSONArray("avatar");
        if (Objects.isNull(jsonArray) || jsonArray.isEmpty()) {
            return null;
        }
        return jsonArray.getJSONObject(0).getString("url");
    }

    private Normal.Gender getGender(JSONObject userObj) {
        JSONObject object = userObj.getJSONObject("basicInformation");
        if (Objects.isNull(object)) {
            return Normal.Gender.UNKNOWN;
        }
        return Normal.Gender.getGender(object.getString("sex"));
    }

    private String getCompany(JSONObject userObj) {
        JSONArray array = userObj.getJSONArray("work");
        if (Objects.isNull(array) || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0).getString("name");
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("userId", token.getOpenId()).build();
    }
}

