/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class TeambitionProvider
extends DefaultProvider {
    public TeambitionProvider(Context context) {
        super(context, Registry.TEAMBITION);
    }

    public TeambitionProvider(Context context, StateCache stateCache) {
        super(context, Registry.TEAMBITION, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("client_id", this.context.getClientId());
        params.put("client_secret", this.context.getClientSecret());
        params.put("code", Callback2.getCode());
        params.put("grant_type", "code");
        String response = Httpx.post(this.source.accessToken(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "OAuth2 " + token.getAccessToken());
        String response = Httpx.post(this.source.userInfo(), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        token.setUid(object.getString("_id"));
        return Property.builder().uuid(object.getString("_id")).username(object.getString("name")).nickname(object.getString("name")).avatar(object.getString("avatarUrl")).blog(object.getString("website")).location(object.getString("location")).email(object.getString("email")).gender(Normal.Gender.UNKNOWN).token(token).source(this.source.toString()).build();
    }

    @Override
    public Message refresh(AccToken oldToken) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("_userId", oldToken.getUid());
        params.put("refresh_token", oldToken.getRefreshToken());
        String response = Httpx.post(this.source.refresh(), params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Message.builder().errcode(Builder.Status.SUCCESS.getCode()).data(AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).build()).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"message") && object.containsKey((Object)"name")) {
            throw new InstrumentException(object.getString("name") + ", " + object.getString("message"));
        }
    }
}

