/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.builtin.MadeInOffice;
import org.aoju.bus.office.metric.AbstractOfficeManager;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.metric.OfficeManagerPoolBuilder;

public abstract class AbstractOfficePoolManager
extends AbstractOfficeManager {
    private static final int POOL_STOPPED = 0;
    private static final int POOL_STARTED = 1;
    private static final int POOL_SHUTDOWN = 2;
    protected final OfficeManagerPoolBuilder config;
    private final AtomicInteger poolState = new AtomicInteger(0);
    private final BlockingQueue<OfficeManager> pool;
    private OfficeManager[] entries;

    protected AbstractOfficePoolManager(int poolSize, OfficeManagerPoolBuilder config) {
        super(config);
        this.config = config;
        this.pool = new ArrayBlockingQueue<OfficeManager>(poolSize);
    }

    protected abstract OfficeManager[] createPoolEntries();

    @Override
    public void execute(MadeInOffice task) throws InstrumentException {
        if (!this.isRunning()) {
            throw new IllegalStateException("This office manager is not running.");
        }
        OfficeManager entry = null;
        try {
            entry = this.acquireManager();
            entry.execute(task);
        }
        finally {
            if (entry != null) {
                this.releaseManager(entry);
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.poolState.get() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws InstrumentException {
        AbstractOfficePoolManager abstractOfficePoolManager = this;
        synchronized (abstractOfficePoolManager) {
            if (this.poolState.get() == 2) {
                throw new IllegalStateException("This office manager has been shutdown.");
            }
            if (this.poolState.get() == 1) {
                throw new IllegalStateException("This office manager is already running.");
            }
            this.entries = this.createPoolEntries();
            this.doStart();
            this.makeTempDir();
            this.poolState.set(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws InstrumentException {
        AbstractOfficePoolManager abstractOfficePoolManager = this;
        synchronized (abstractOfficePoolManager) {
            if (this.poolState.get() == 2) {
                return;
            }
            this.poolState.set(2);
            try {
                this.doStop();
            }
            finally {
                this.deleteTempDir();
            }
        }
    }

    private OfficeManager acquireManager() throws InstrumentException {
        try {
            OfficeManager manager = this.pool.poll(this.config.getTaskQueueTimeout(), TimeUnit.MILLISECONDS);
            if (manager == null) {
                throw new InstrumentException("No office manager available after " + this.config.getTaskQueueTimeout() + " millisec.");
            }
            return manager;
        }
        catch (InterruptedException interruptedEx) {
            throw new InstrumentException("Thread has been interrupted while waiting for a manager to become available.", interruptedEx);
        }
    }

    private void releaseManager(OfficeManager manager) throws InstrumentException {
        try {
            this.pool.put(manager);
        }
        catch (InterruptedException interruptedEx) {
            throw new InstrumentException("interrupted", interruptedEx);
        }
    }

    protected void doStart() throws InstrumentException {
        for (OfficeManager manager : this.entries) {
            manager.start();
            this.releaseManager(manager);
        }
    }

    private void doStop() throws InstrumentException {
        Logger.info("Stopping the office manager pool...", new Object[0]);
        this.pool.clear();
        InstrumentException firstException = null;
        for (OfficeManager manager : this.entries) {
            try {
                manager.stop();
            }
            catch (InstrumentException ex) {
                if (firstException != null) continue;
                firstException = ex;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
        Logger.info("Office manager stopped", new Object[0]);
    }

    public static abstract class AbstractOfficeManagerPoolBuilder<B extends AbstractOfficeManagerPoolBuilder<B>>
    extends AbstractOfficeManager.AbstractOfficeManagerBuilder<B> {
        protected long taskExecutionTimeout = 120000L;
        protected long taskQueueTimeout = 30000L;

        protected AbstractOfficeManagerPoolBuilder() {
        }

        public B taskExecutionTimeout(long taskExecutionTimeout) {
            Assert.notNull(taskExecutionTimeout, String.format("The taskExecutionTimeout %s must greater than or equal to 0", taskExecutionTimeout), new Object[0]);
            this.taskExecutionTimeout = taskExecutionTimeout;
            return (B)this;
        }

        public B taskQueueTimeout(long taskQueueTimeout) {
            this.taskQueueTimeout = taskQueueTimeout;
            return (B)this;
        }

        @Override
        protected abstract AbstractOfficePoolManager build();
    }
}

