/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class EnumUtils {
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";

    public static boolean isEnum(Class<?> clazz) {
        Assert.notNull(clazz);
        return clazz.isEnum();
    }

    public static boolean isEnum(Object obj) {
        Assert.notNull(obj);
        return obj.getClass().isEnum();
    }

    public static String toString(Enum<?> e) {
        return null != e ? e.name() : null;
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value) {
        return Enum.valueOf(enumClass, value);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value, E defaultValue) {
        return (E)((Enum)ObjectUtils.defaultIfNull(EnumUtils.fromStringQuietly(enumClass, value), defaultValue));
    }

    public static <E extends Enum<E>> E fromStringQuietly(Class<E> enumClass, String value) {
        if (null == enumClass || StringUtils.isBlank(value)) {
            return null;
        }
        try {
            return EnumUtils.fromString(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static <E extends Enum<E>> E likeValueOf(Class<E> enumClass, Object value) {
        if (value instanceof CharSequence) {
            value = value.toString().trim();
        }
        Field[] fields = ReflectUtils.getFields(enumClass);
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (field.getType().isEnum() || "ENUM$VALUES".equals(fieldName) || "ordinal".equals(fieldName)) continue;
            for (Enum enumObj : enums) {
                if (!ObjectUtils.equal(value, ReflectUtils.getFieldValue((Object)enumObj, field))) continue;
                return (E)enumObj;
            }
        }
        return null;
    }

    public static List<String> getNames(Class<? extends Enum<?>> clazz) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(enums.length);
        for (Enum<?> e : enums) {
            list.add(e.name());
        }
        return list;
    }

    public static List<Object> getFieldValues(Class<? extends Enum<?>> clazz, String fieldName) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(enums.length);
        for (Enum<?> e : enums) {
            list.add(ReflectUtils.getFieldValue(e, fieldName));
        }
        return list;
    }

    public static List<String> getFieldNames(Class<? extends Enum<?>> clazz) {
        Field[] fields;
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : fields = ReflectUtils.getFields(clazz)) {
            String name = field.getName();
            if (field.getType().isEnum() || name.contains("$VALUES") || "ordinal".equals(name) || names.contains(name)) continue;
            names.add(name);
        }
        return names;
    }

    public static <E extends Enum<E>> LinkedHashMap<String, E> getEnumMap(Class<E> enumClass) {
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return map;
    }

    public static Map<String, Object> getNameFieldMap(Class<? extends Enum<?>> clazz, String fieldName) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        HashMap<String, Object> map = MapUtils.newHashMap(enums.length);
        for (Enum<?> e : enums) {
            map.put(e.name(), ReflectUtils.getFieldValue(e, fieldName));
        }
        return map;
    }

    public static <E extends Enum<E>> boolean contains(Class<E> enumClass, String val) {
        return EnumUtils.getEnumMap(enumClass).containsKey(val);
    }

    public static <E extends Enum<E>> boolean notContains(Class<E> enumClass, String val) {
        return false == EnumUtils.contains(enumClass, val);
    }

    public static boolean equalsIgnoreCase(Enum<?> e, String val) {
        return StringUtils.equalsIgnoreCase(EnumUtils.toString(e), val);
    }

    public static boolean equals(Enum<?> e, String val) {
        return StringUtils.equals(EnumUtils.toString(e), val);
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> enumClass) {
        return new ArrayList<E>(Arrays.asList(enumClass.getEnumConstants()));
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> enumClass, String enumName) {
        return EnumUtils.getEnum(enumClass, enumName) != null;
    }

    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> enumClass, String enumName) {
        return EnumUtils.getEnumIgnoreCase(enumClass, enumName) != null;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String enumName) {
        if (enumName == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, enumName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> enumClass, String enumName) {
        if (enumName == null || !enumClass.isEnum()) {
            return null;
        }
        for (Enum each : (Enum[])enumClass.getEnumConstants()) {
            if (!each.name().equalsIgnoreCase(enumName)) continue;
            return (E)each;
        }
        return null;
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass, Iterable<? extends E> values) {
        EnumUtils.checkBitVectorable(enumClass);
        Assert.notNull(values);
        long total = 0L;
        for (Enum constant : values) {
            Assert.isTrue(constant != null, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            total |= 1L << constant.ordinal();
        }
        return total;
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass, Iterable<? extends E> values) {
        EnumUtils.asEnum(enumClass);
        Assert.notNull(values);
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass);
        for (Enum constant : values) {
            Assert.isTrue(constant != null, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            condensed.add(constant);
        }
        long[] result = new long[(((Enum[])enumClass.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value : condensed) {
            int n = value.ordinal() / 64;
            result[n] = result[n] | 1L << value.ordinal() % 64;
        }
        ArrayUtils.reverse(result);
        return result;
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass, E ... values) {
        Assert.noNullElements(values);
        return EnumUtils.generateBitVector(enumClass, Arrays.asList(values));
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass, E ... values) {
        EnumUtils.asEnum(enumClass);
        Assert.noNullElements(values);
        EnumSet<Enum> condensed = EnumSet.noneOf(enumClass);
        Collections.addAll(condensed, values);
        long[] result = new long[(((Enum[])enumClass.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum value : condensed) {
            int n = value.ordinal() / 64;
            result[n] = result[n] | 1L << value.ordinal() % 64;
        }
        ArrayUtils.reverse(result);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> enumClass, long value) {
        EnumUtils.checkBitVectorable(enumClass).getEnumConstants();
        return EnumUtils.processBitVectors(enumClass, value);
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> enumClass, long ... values) {
        EnumSet<Enum> results = EnumSet.noneOf(EnumUtils.asEnum(enumClass));
        long[] lvalues = ArrayUtils.clone(Assert.notNull(values));
        ArrayUtils.reverse(lvalues);
        for (Enum constant : (Enum[])enumClass.getEnumConstants()) {
            int block = constant.ordinal() / 64;
            if (block >= lvalues.length || (lvalues[block] & 1L << constant.ordinal() % 64) == 0L) continue;
            results.add(constant);
        }
        return results;
    }

    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> enumClass) {
        Enum[] constants = (Enum[])EnumUtils.asEnum(enumClass).getEnumConstants();
        Assert.isTrue(constants.length <= 64, CANNOT_STORE_S_S_VALUES_IN_S_BITS, constants.length, enumClass.getSimpleName(), 64);
        return enumClass;
    }

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> enumClass) {
        Assert.notNull(enumClass, ENUM_CLASS_MUST_BE_DEFINED, new Object[0]);
        Assert.isTrue(enumClass.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, enumClass);
        return enumClass;
    }
}

