/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.forest.boot.jar;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.aoju.bus.forest.algorithm.Key;
import org.aoju.bus.forest.boot.jar.JarURLConnection;
import org.aoju.bus.forest.provider.DecryptorProvider;
import org.aoju.bus.forest.provider.EncryptorProvider;

public class JarURLHandler
extends URLStreamHandler {
    private final DecryptorProvider decryptorProvider;
    private final EncryptorProvider encryptorProvider;
    private final Key key;
    private final Set<String> indexes;

    public JarURLHandler(DecryptorProvider decryptorProvider, EncryptorProvider encryptorProvider, Key key, ClassLoader classLoader) throws Exception {
        this.decryptorProvider = decryptorProvider;
        this.encryptorProvider = encryptorProvider;
        this.key = key;
        this.indexes = new LinkedHashSet<String>();
        Enumeration<URL> resources = classLoader.getResources("META-INF/FOREST.MF");
        while (resources.hasMoreElements()) {
            String name;
            URL resource = resources.nextElement();
            String url = resource.toString();
            String classpath = url.substring(0, url.lastIndexOf("!/") + 2);
            InputStream in = resource.openStream();
            InputStreamReader isr = new InputStreamReader(in);
            LineNumberReader lnr = new LineNumberReader(isr);
            while ((name = lnr.readLine()) != null) {
                this.indexes.add(classpath + name);
            }
        }
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection urlConnection = new URL(url.toString()).openConnection();
        return this.indexes.contains(url.toString()) && urlConnection instanceof java.net.JarURLConnection ? new JarURLConnection((java.net.JarURLConnection)urlConnection, this.decryptorProvider, this.encryptorProvider, this.key) : urlConnection;
    }
}

