/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.family;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.extra.json.JsonUtils;
import org.aoju.bus.office.magic.family.DocumentFormat;
import org.aoju.bus.office.magic.family.FamilyType;
import org.aoju.bus.office.magic.family.FormatProperties;
import org.aoju.bus.office.magic.family.SimpleFormatRegistry;

public class JsonFormatRegistry
extends SimpleFormatRegistry {
    protected JsonFormatRegistry() {
    }

    public static JsonFormatRegistry create(String source) {
        return JsonFormatRegistry.create(source, null);
    }

    public static JsonFormatRegistry create(InputStream source) throws IOException {
        return JsonFormatRegistry.create(source, null);
    }

    public static JsonFormatRegistry create(InputStream source, Map<String, FormatProperties> customProperties) throws IOException {
        return JsonFormatRegistry.create(IoUtils.toString(source, "UTF-8"), customProperties);
    }

    public static JsonFormatRegistry create(String source, Map<String, FormatProperties> customProperties) {
        JsonFormatRegistry registry = new JsonFormatRegistry();
        registry.readJsonArray(source, customProperties);
        return registry;
    }

    protected void readJsonArray(String source, Map<String, FormatProperties> customProperties) {
        List<DocumentFormat> list = JsonUtils.toList(source, DocumentFormat.class);
        if (CollUtils.isNotEmpty(list)) {
            list.stream().map(fmt -> {
                if (ObjectUtils.isEmpty(customProperties) || !customProperties.containsKey(fmt.getExtension())) {
                    return DocumentFormat.unmodifiableCopy(fmt);
                }
                FormatProperties props = (FormatProperties)customProperties.get(fmt.getExtension());
                DocumentFormat.Builder builder = DocumentFormat.builder().from((DocumentFormat)fmt).unmodifiable(true);
                props.getLoad().forEach(builder::loadProperty);
                props.getStore().forEach((family, storeProps) -> storeProps.forEach((name, value) -> builder.storeProperty((FamilyType)((Object)((Object)family)), (String)name, value)));
                return builder.build();
            }).forEach(this::addFormat);
        }
    }
}

