/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.office.metric.TemporaryFileMaker;
import org.aoju.bus.office.provider.AbstractSourceProvider;
import org.aoju.bus.office.provider.SourceDocumentProvider;

public class SourceFromInputStreamProvider
extends AbstractSourceProvider
implements SourceDocumentProvider {
    private final InputStream inputStream;
    private final boolean closeStream;
    private final TemporaryFileMaker fileMaker;

    SourceFromInputStreamProvider(InputStream inputStream, TemporaryFileMaker fileMaker, boolean closeStream) {
        super(fileMaker.makeTemporaryFile());
        this.inputStream = inputStream;
        this.closeStream = closeStream;
        this.fileMaker = fileMaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getFile() {
        File file;
        File tempFile = Optional.ofNullable(this.getFormat()).map(format -> this.fileMaker.makeTemporaryFile(format.getExtension())).orElse(super.getFile());
        FileOutputStream outputStream = new FileOutputStream(tempFile);
        outputStream.getChannel().lock();
        try {
            IoUtils.copy(this.inputStream, (OutputStream)outputStream);
            file = tempFile;
        }
        catch (Throwable throwable) {
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new InstrumentException("Could not write stream to file " + tempFile, ex);
            }
        }
        outputStream.close();
        return file;
    }

    @Override
    public void onConsumed(File tempFile) {
        FileUtils.delete(tempFile);
        if (this.closeStream) {
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
                throw new InstrumentException("Could not close input stream", ex);
            }
        }
    }
}

