/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.StateMachine;
import org.aoju.bus.socket.origin.plugins.AbstractPlugin;

public abstract class HeartPlugin<T>
extends AbstractPlugin<T> {
    private static Timer timer = new Timer("HeartMonitor Timer", true);
    private Map<AioSession<T>, Long> sessionMap = new HashMap<AioSession<T>, Long>();
    private int timeout;

    public HeartPlugin(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public final boolean preProcess(AioSession<T> session, T t) {
        this.sessionMap.put(session, System.currentTimeMillis());
        return !this.isHeartMessage(session, t);
    }

    @Override
    public final void stateEvent(StateMachine stateMachineEnum, AioSession<T> session, Throwable throwable) {
        switch (stateMachineEnum) {
            case NEW_SESSION: {
                this.sessionMap.put(session, System.currentTimeMillis());
                this.registerHeart(session, this.timeout);
                break;
            }
            case SESSION_CLOSED: {
                this.sessionMap.remove(session);
            }
        }
    }

    public abstract void sendHeartRequest(AioSession<T> var1) throws IOException;

    public abstract boolean isHeartMessage(AioSession<T> var1, T var2);

    private void registerHeart(final AioSession<T> session, final int timeout) {
        if (timeout <= 0) {
            Logger.info("sesssion:{} \u56e0\u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4\u4e3a:{},\u7ec8\u6b62\u542f\u52a8\u5fc3\u8df3\u76d1\u6d4b\u4efb\u52a1", session, timeout);
            return;
        }
        Logger.info("session:{}\u6ce8\u518c\u5fc3\u8df3\u4efb\u52a1,\u8d85\u65f6\u65f6\u95f4:{}", session, timeout);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (session.isInvalid()) {
                    HeartPlugin.this.sessionMap.remove(session);
                    Logger.info("session:{} \u5df2\u5931\u6548,\u79fb\u9664\u5fc3\u8df3\u4efb\u52a1", session);
                    return;
                }
                Long lastTime = (Long)HeartPlugin.this.sessionMap.get(session);
                if (lastTime == null) {
                    Logger.warn("session:{} timeout is null", session);
                    lastTime = System.currentTimeMillis();
                    HeartPlugin.this.sessionMap.put(session, lastTime);
                }
                if (System.currentTimeMillis() - lastTime > (long)timeout) {
                    try {
                        HeartPlugin.this.sendHeartRequest(session);
                    }
                    catch (IOException e) {
                        Logger.error("heart exception", e);
                    }
                }
                HeartPlugin.this.registerHeart(session, timeout);
            }
        }, timeout);
    }
}

