/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ssh;

import com.jcraft.jsch.Session;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.extra.ssh.SSHUtils;

public enum JschSessionPool {
    INSTANCE;

    private static final Object lock;
    private Map<String, Session> sessionPool = new ConcurrentHashMap<String, Session>();

    public Session get(String key) {
        return this.sessionPool.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        String key = StringUtils.format("{}@{}:{}", sshUser, sshHost, sshPort);
        Session session = this.get(key);
        if (null == session || !session.isConnected()) {
            Object object = lock;
            synchronized (object) {
                session = this.get(key);
                if (null == session || !session.isConnected()) {
                    session = SSHUtils.openSession(sshHost, sshPort, sshUser, sshPass);
                    this.put(key, session);
                }
            }
        }
        return session;
    }

    public void put(String key, Session session) {
        this.sessionPool.put(key, session);
    }

    public void close(String key) {
        Session session = this.sessionPool.get(key);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        this.sessionPool.remove(key);
    }

    public void remove(Session session) {
        if (null != session) {
            Iterator<Map.Entry<String, Session>> iterator = this.sessionPool.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Session> entry = iterator.next();
                if (!session.equals(entry.getValue())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void closeAll() {
        Collection<Session> sessions = this.sessionPool.values();
        for (Session session : sessions) {
            if (!session.isConnected()) continue;
            session.disconnect();
        }
        this.sessionPool.clear();
    }

    static {
        lock = new Object();
    }
}

