/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.io.PrintWriter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Singleton;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.Platform;
import org.aoju.bus.health.hardware.HardwareLayer;
import org.aoju.bus.health.hardware.linux.LinuxHardwareLayer;
import org.aoju.bus.health.hardware.mac.MacHardwareLayer;
import org.aoju.bus.health.hardware.unix.freebsd.FreeBsdHardwareLayer;
import org.aoju.bus.health.hardware.unix.solaris.SolarisHardwareLayer;
import org.aoju.bus.health.hardware.windows.WindowsHardwareLayer;
import org.aoju.bus.health.software.JavaInfo;
import org.aoju.bus.health.software.JavaRuntime;
import org.aoju.bus.health.software.JavaSpecInfo;
import org.aoju.bus.health.software.JvmInfo;
import org.aoju.bus.health.software.JvmSpecInfo;
import org.aoju.bus.health.software.NetworkParams;
import org.aoju.bus.health.software.OSUser;
import org.aoju.bus.health.software.OperatingSystem;
import org.aoju.bus.health.software.linux.LinuxOS;
import org.aoju.bus.health.software.mac.MacOS;
import org.aoju.bus.health.software.unix.freebsd.FreeBsdOS;
import org.aoju.bus.health.software.unix.solaris.SolarisOS;
import org.aoju.bus.health.software.windows.WindowsOS;

public class Systemd {
    private static final Platform.OS _PLATFORM = com.sun.jna.Platform.isWindows() ? Platform.OS.WINDOWS : (Platform.isLinux() ? Platform.OS.LINUX : (Platform.isMac() ? Platform.OS.MACOSX : (Platform.isSolaris() ? Platform.OS.SOLARIS : (Platform.isFreeBSD() ? Platform.OS.FREEBSD : Platform.OS.UNKNOWN))));
    private final Supplier<OperatingSystem> os = Memoizer.memoize(this::createOperatingSystem);
    private final Supplier<HardwareLayer> hardware = Memoizer.memoize(this::createHardware);

    public static Platform.OS getCurrentPlatform() {
        return _PLATFORM;
    }

    public static String get(String name, String defaultValue) {
        return StringUtils.nullToDefault(Systemd.get(name, false), defaultValue);
    }

    public static String get(String name, boolean quiet) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            throw new InstrumentException(e);
        }
    }

    public static String get(String key) {
        return Systemd.get(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = Systemd.get(key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        if ("true".equals(value) || "yes".equals(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "0".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    public static long getInt(String key, int defaultValue) {
        return Convert.toInt(Systemd.get(key), defaultValue).intValue();
    }

    public static long getLong(String key, long defaultValue) {
        return Convert.toLong(Systemd.get(key), defaultValue);
    }

    public static Properties props() {
        return System.getProperties();
    }

    public static long getCurrentPID() {
        return Long.parseLong(Systemd.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactory.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementFactory.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactory.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementFactory.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementFactory.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactory.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementFactory.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactory.getGarbageCollectorMXBeans();
    }

    public static JvmSpecInfo getJvmSpecInfo() {
        return Singleton.get(JvmSpecInfo.class, new Object[0]);
    }

    public static JvmInfo getJvmInfo() {
        return Singleton.get(JvmInfo.class, new Object[0]);
    }

    public static JavaSpecInfo getJavaSpecInfo() {
        return Singleton.get(JavaSpecInfo.class, new Object[0]);
    }

    public static JavaInfo getJavaInfo() {
        return Singleton.get(JavaInfo.class, new Object[0]);
    }

    public static JavaRuntime getJavaRuntimeInfo() {
        return Singleton.get(JavaRuntime.class, new Object[0]);
    }

    public static OperatingSystem getOsInfo() {
        return Singleton.get(OperatingSystem.class, new Object[0]);
    }

    public static OSUser getUserInfo() {
        return Singleton.get(OSUser.class, new Object[0]);
    }

    public static NetworkParams getHostInfo() {
        return Singleton.get(NetworkParams.class, new Object[0]);
    }

    public static void dumpSystemInfo() {
        Systemd.dumpSystemInfo(new PrintWriter(System.out));
    }

    public static void dumpSystemInfo(PrintWriter out) {
        out.println("--------------");
        out.println(Systemd.getJvmSpecInfo());
        out.println("--------------");
        out.println(Systemd.getJvmInfo());
        out.println("--------------");
        out.println(Systemd.getJavaSpecInfo());
        out.println("--------------");
        out.println(Systemd.getJavaInfo());
        out.println("--------------");
        out.println(Systemd.getJavaRuntimeInfo());
        out.println("--------------");
        out.println(Systemd.getOsInfo());
        out.println("--------------");
        out.println(Systemd.getUserInfo());
        out.println("--------------");
        out.println(Systemd.getHostInfo());
        out.flush();
    }

    public static void append(StringBuilder builder, String caption, Object value) {
        builder.append(caption).append(StringUtils.nullToDefault(Convert.toString(value), "[n/a]")).append("\n");
    }

    public static InetAddress getLocalAddress() {
        try {
            InetAddress inetAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (inetAddress != null) continue;
                    inetAddress = inetAddr;
                }
            }
            if (inetAddress != null) {
                return inetAddress;
            }
            inetAddress = InetAddress.getLocalHost();
            if (inetAddress == null) {
                throw new InstrumentException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return inetAddress;
        }
        catch (Exception e) {
            throw new InstrumentException("Failed to determine LAN address: " + e);
        }
    }

    public OperatingSystem getOperatingSystem() {
        return this.os.get();
    }

    private OperatingSystem createOperatingSystem() {
        switch (_PLATFORM) {
            case WINDOWS: {
                return new WindowsOS();
            }
            case LINUX: {
                return new LinuxOS();
            }
            case MACOSX: {
                return new MacOS();
            }
            case SOLARIS: {
                return new SolarisOS();
            }
            case FREEBSD: {
                return new FreeBsdOS();
            }
        }
        throw new UnsupportedOperationException("Operating system not supported: " + com.sun.jna.Platform.getOSType());
    }

    public HardwareLayer getHardware() {
        return this.hardware.get();
    }

    private HardwareLayer createHardware() {
        switch (_PLATFORM) {
            case WINDOWS: {
                return new WindowsHardwareLayer();
            }
            case LINUX: {
                return new LinuxHardwareLayer();
            }
            case MACOSX: {
                return new MacHardwareLayer();
            }
            case SOLARIS: {
                return new SolarisHardwareLayer();
            }
            case FREEBSD: {
                return new FreeBsdHardwareLayer();
            }
        }
        throw new UnsupportedOperationException("Operating system not supported: " + com.sun.jna.Platform.getOSType());
    }
}

