/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software;

import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Systemd;

public class JavaRuntime {
    private final String JAVA_RUNTIME_NAME = Systemd.get(" java.runtime.name", false);
    private final String JAVA_RUNTIME_VERSION = Systemd.get("java.runtime.version", false);
    private final String JAVA_HOME = Systemd.get("java.home", false);
    private final String JAVA_EXT_DIRS = Systemd.get("java.ext.dirs", false);
    private final String JAVA_ENDORSED_DIRS = Systemd.get("java.endorsed.dirs", false);
    private final String JAVA_CLASS_PATH = Systemd.get("java.class.path", false);
    private final String JAVA_CLASS_VERSION = Systemd.get("java.class.version", false);
    private final String JAVA_LIBRARY_PATH = Systemd.get("java.library.path", false);
    private final String SUN_BOOT_CLASS_PATH = Systemd.get("sun.boot.class.path", false);
    private final String SUN_ARCH_DATA_MODEL = Systemd.get("sun.arch.data.model", false);

    public final String getSunBoothClassPath() {
        return this.SUN_BOOT_CLASS_PATH;
    }

    public final String getSunArchDataModel() {
        return this.SUN_ARCH_DATA_MODEL;
    }

    public final String getName() {
        return this.JAVA_RUNTIME_NAME;
    }

    public final String getVersion() {
        return this.JAVA_RUNTIME_VERSION;
    }

    public final String getHomeDir() {
        return this.JAVA_HOME;
    }

    public final String getExtDirs() {
        return this.JAVA_EXT_DIRS;
    }

    public final String getEndorsedDirs() {
        return this.JAVA_ENDORSED_DIRS;
    }

    public final String getClassPath() {
        return this.JAVA_CLASS_PATH;
    }

    public final String[] getClassPathArray() {
        return StringUtils.split((CharSequence)this.getClassPath(), Systemd.get("path.separator", false));
    }

    public final String getClassVersion() {
        return this.JAVA_CLASS_VERSION;
    }

    public final String getLibraryPath() {
        return this.JAVA_LIBRARY_PATH;
    }

    public final String[] getLibraryPathArray() {
        return StringUtils.split((CharSequence)this.getLibraryPath(), Systemd.get("path.separator", false));
    }

    public final String getProtocolPackages() {
        return Systemd.get("java.protocol.handler.pkgs", true);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        Systemd.append(builder, "Java Runtime Name:      ", this.getName());
        Systemd.append(builder, "Java Runtime Version:   ", this.getVersion());
        Systemd.append(builder, "Java Home Dir:          ", this.getHomeDir());
        Systemd.append(builder, "Java Extension Dirs:    ", this.getExtDirs());
        Systemd.append(builder, "Java Endorsed Dirs:     ", this.getEndorsedDirs());
        Systemd.append(builder, "Java Class Path:        ", this.getClassPath());
        Systemd.append(builder, "Java Class Version:     ", this.getClassVersion());
        Systemd.append(builder, "Java Library Path:      ", this.getLibraryPath());
        Systemd.append(builder, "Java Protocol Packages: ", this.getProtocolPackages());
        return builder.toString();
    }
}

