/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.io.EventFactory;
import org.aoju.bus.core.io.PageBuffer;
import org.aoju.bus.core.io.RingBuffer;
import org.aoju.bus.core.io.VirtualBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.Function;
import org.aoju.bus.socket.origin.UdpAioSession;
import org.aoju.bus.socket.origin.UdpWriteEvent;
import org.aoju.bus.socket.origin.WriteBuffer;

public final class UdpChannel<Request> {
    private PageBuffer pageBuffer;
    private int writeQueueCapacity;
    private DatagramChannel channel;
    private SelectionKey selectionKey;
    private ConcurrentHashMap<String, UdpAioSession<Request>> udpAioSessionConcurrentHashMap = new ConcurrentHashMap();
    private RingBuffer<UdpWriteEvent> writeRingBuffer;
    private Object lock = new Object();
    private int writeBacklog = 2048;

    UdpChannel(DatagramChannel channel, SelectionKey selectionKey, int writeQueueCapacity, PageBuffer pageBuffer) {
        this.channel = channel;
        this.writeRingBuffer = new RingBuffer<UdpWriteEvent>(this.writeBacklog, new EventFactory<UdpWriteEvent>(){

            @Override
            public UdpWriteEvent newInstance() {
                return new UdpWriteEvent();
            }

            @Override
            public void restEntity(UdpWriteEvent entity) {
                entity.setResponse(null);
                entity.setRemote(null);
            }
        });
        this.selectionKey = selectionKey;
        this.writeQueueCapacity = writeQueueCapacity;
        this.pageBuffer = pageBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(VirtualBuffer virtualBuffer, SocketAddress remote) throws IOException, InterruptedException {
        int index;
        int n = index = this.writeRingBuffer == null ? -1 : this.writeRingBuffer.tryNextWriteIndex();
        if (index < 0) {
            try {
                this.channel.send(virtualBuffer.buffer(), remote);
            }
            finally {
                virtualBuffer.clean();
            }
            return;
        }
        UdpWriteEvent event = this.writeRingBuffer.get(index);
        event.setResponse(virtualBuffer);
        event.setRemote(remote);
        this.writeRingBuffer.publishWriteIndex(index);
        if ((this.selectionKey.interestOps() & 4) == 0) {
            Object object = this.lock;
            synchronized (object) {
                this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
                this.selectionKey.selector().wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWrite() throws IOException {
        int writeSize = -1;
        do {
            int index;
            if ((index = this.writeRingBuffer.tryNextReadIndex()) < 0) {
                Object object = this.lock;
                synchronized (object) {
                    this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
                    this.selectionKey.selector().wakeup();
                }
                index = this.writeRingBuffer.tryNextReadIndex();
                if (index < 0) {
                    return;
                }
                this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
            }
            UdpWriteEvent event = this.writeRingBuffer.get(index);
            VirtualBuffer response = event.getResponse();
            SocketAddress remote = event.getRemote();
            this.writeRingBuffer.publishReadIndex(index);
            ByteBuffer buffer = response.buffer();
            writeSize = this.channel.send(buffer, remote);
            response.clean();
            if (!buffer.hasRemaining()) continue;
            Logger.error("buffer has remaining!", new Object[0]);
        } while (writeSize > 0);
    }

    public AioSession<Request> connect(SocketAddress remote) {
        return this.createAndCacheSession(remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UdpAioSession<Request> createAndCacheSession(SocketAddress remote) {
        if (!(remote instanceof InetSocketAddress)) {
            throw new UnsupportedOperationException();
        }
        InetSocketAddress address = (InetSocketAddress)remote;
        String key = address.getHostName() + ":" + address.getPort();
        UdpAioSession<Object> session = this.udpAioSessionConcurrentHashMap.get(key);
        if (session != null) {
            return session;
        }
        UdpChannel udpChannel = this;
        synchronized (udpChannel) {
            if (session != null) {
                return session;
            }
            Function<WriteBuffer, Void> function = writeBuffer -> {
                VirtualBuffer virtualBuffer = writeBuffer.poll();
                if (virtualBuffer == null) {
                    return null;
                }
                try {
                    this.write(virtualBuffer, remote);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            };
            WriteBuffer writeBuffer2 = new WriteBuffer(this.pageBuffer, function, this.writeQueueCapacity);
            session = new UdpAioSession(this, remote, writeBuffer2);
            this.udpAioSessionConcurrentHashMap.put(key, session);
        }
        return session;
    }

    public void close() {
        if (this.selectionKey != null) {
            Selector selector = this.selectionKey.selector();
            this.selectionKey.cancel();
            selector.wakeup();
            this.selectionKey = null;
        }
        for (Map.Entry entry : this.udpAioSessionConcurrentHashMap.entrySet()) {
            ((UdpAioSession)entry.getValue()).close();
        }
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (IOException e) {
            Logger.error("", e);
        }
    }

    DatagramChannel getChannel() {
        return this.channel;
    }
}

