/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.lang.reflect.Type;
import java.util.Collection;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.TypeUtils;

public class CollectionConverter
implements Converter<Collection<?>> {
    private final Type collectionType;
    private final Type elementType;

    public CollectionConverter() {
        this(Collection.class);
    }

    public CollectionConverter(Type collectionType) {
        this(collectionType, TypeUtils.getTypeArgument(collectionType));
    }

    public CollectionConverter(Class<?> collectionType) {
        this(collectionType, TypeUtils.getTypeArgument(collectionType));
    }

    public CollectionConverter(Type collectionType, Type elementType) {
        this.collectionType = collectionType;
        this.elementType = elementType;
    }

    @Override
    public Collection<?> convert(Object value, Collection<?> defaultValue) throws IllegalArgumentException {
        Collection<?> result;
        try {
            result = this.convertInternal(value);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
        return null == result ? defaultValue : result;
    }

    protected Collection<?> convertInternal(Object value) {
        return CollUtils.addAll(CollUtils.create(TypeUtils.getClass(this.collectionType)), value, this.elementType);
    }
}

