/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.CharUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class NumberUtils {
    private static final int DEFAUT_DIV_SCALE = 10;

    public static double add(float v1, float v2) {
        return NumberUtils.add(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(float v1, double v2) {
        return NumberUtils.add(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(double v1, float v2) {
        return NumberUtils.add(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(double v1, double v2) {
        return NumberUtils.add(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static BigDecimal add(Number v1, Number v2) {
        return NumberUtils.add(new Number[]{v1, v2});
    }

    public static BigDecimal add(Number ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal add(String ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal add(BigDecimal ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.add(value);
        }
        return result;
    }

    public static double sub(float v1, float v2) {
        return NumberUtils.sub(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(float v1, double v2) {
        return NumberUtils.sub(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(double v1, float v2) {
        return NumberUtils.sub(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(double v1, double v2) {
        return NumberUtils.sub(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static BigDecimal sub(Number v1, Number v2) {
        return NumberUtils.sub(new Number[]{v1, v2});
    }

    public static BigDecimal sub(Number ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(new BigDecimal(value.toString()));
        }
        return result;
    }

    public static BigDecimal sub(String ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal sub(BigDecimal ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.subtract(value);
        }
        return result;
    }

    public static double mul(float v1, float v2) {
        return NumberUtils.mul(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(float v1, double v2) {
        return NumberUtils.mul(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(double v1, float v2) {
        return NumberUtils.mul(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(double v1, double v2) {
        return NumberUtils.mul(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static BigDecimal mul(Number v1, Number v2) {
        return NumberUtils.mul(new Number[]{v1, v2});
    }

    public static BigDecimal mul(Number ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        Number value = values[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value.toString());
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            result = result.multiply(new BigDecimal(null == value ? "0" : value.toString()));
        }
        return result;
    }

    public static BigDecimal mul(String v1, String v2) {
        return NumberUtils.mul((Number)new BigDecimal(v1), (Number)new BigDecimal(v2));
    }

    public static BigDecimal mul(String ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        String value = values[0];
        BigDecimal result = new BigDecimal(null == value ? "0" : value);
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.multiply(new BigDecimal(value));
        }
        return result;
    }

    public static BigDecimal mul(BigDecimal ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values[0];
        BigDecimal result = null == value ? BigDecimal.ZERO : value;
        for (int i = 1; i < values.length; ++i) {
            value = values[i];
            if (null == value) continue;
            result = result.multiply(value);
        }
        return result;
    }

    public static double div(float v1, float v2) {
        return NumberUtils.div(v1, v2, 10);
    }

    public static double div(float v1, double v2) {
        return NumberUtils.div(v1, v2, 10);
    }

    public static double div(double v1, float v2) {
        return NumberUtils.div(v1, v2, 10);
    }

    public static double div(double v1, double v2) {
        return NumberUtils.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2) {
        return NumberUtils.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return NumberUtils.div(v1, v2, 10);
    }

    public static double div(float v1, float v2, int scale) {
        return NumberUtils.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, double v2, int scale) {
        return NumberUtils.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, float v2, int scale) {
        return NumberUtils.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(double v1, double v2, int scale) {
        return NumberUtils.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(Number v1, Number v2, int scale) {
        return NumberUtils.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale) {
        return NumberUtils.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public static double div(float v1, float v2, int scale, RoundingMode roundingMode) {
        return NumberUtils.div(Float.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(float v1, double v2, int scale, RoundingMode roundingMode) {
        return NumberUtils.div(Float.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, float v2, int scale, RoundingMode roundingMode) {
        return NumberUtils.div(Double.toString(v1), Float.toString(v2), scale, roundingMode).doubleValue();
    }

    public static double div(double v1, double v2, int scale, RoundingMode roundingMode) {
        return NumberUtils.div(Double.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        return NumberUtils.div(v1.toString(), v2.toString(), scale, roundingMode);
    }

    public static BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return NumberUtils.div(new BigDecimal(v1), new BigDecimal(v2), scale, roundingMode);
    }

    public static BigDecimal round(double v, int scale) {
        return NumberUtils.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(double v, int scale) {
        return NumberUtils.round(v, scale).toString();
    }

    public static BigDecimal round(String numberStr, int scale) {
        return NumberUtils.round(numberStr, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return NumberUtils.round(number, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(String numberStr, int scale) {
        return NumberUtils.round(numberStr, scale).toString();
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(Double.toString(v), scale, roundingMode);
    }

    public static String roundStr(double v, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(v, scale, roundingMode).toString();
    }

    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        Assert.notBlank(numberStr);
        if (scale < 0) {
            scale = 0;
        }
        return NumberUtils.round(NumberUtils.toBigDecimal(numberStr), scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }

    public static String roundStr(String numberStr, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(numberStr, scale, roundingMode).toString();
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        return NumberUtils.roundHalfEven(NumberUtils.toBigDecimal(number), scale);
    }

    public static BigDecimal roundHalfEven(BigDecimal value, int scale) {
        return NumberUtils.round(value, scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        return NumberUtils.roundDown(NumberUtils.toBigDecimal(number), scale);
    }

    public static BigDecimal roundDown(BigDecimal value, int scale) {
        return NumberUtils.round(value, scale, RoundingMode.DOWN);
    }

    public static String decimalFormat(String pattern, double value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, long value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormatMoney(double value) {
        return NumberUtils.decimalFormat(",##0.00", value);
    }

    public static String formatPercent(double number, int scale) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(scale);
        return format.format(number);
    }

    public static boolean isNumber(CharSequence str) {
        int i;
        int start;
        if (StringUtils.isBlank(str)) {
            return false;
        }
        char[] chars = str.toString().toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && (chars[start + 1] == 'x' || chars[start + 1] == 'X')) {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return false == allowSigns && foundDigit;
    }

    public static boolean isInteger(String s) {
        if (StringUtils.isNotBlank(s)) {
            return s.matches("^-?\\d+$");
        }
        return false;
    }

    public static boolean isLong(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return s.contains(".");
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isPrimes(int n) {
        int i = 2;
        while ((double)i <= Math.sqrt(n)) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int[] generateRandomNumber(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new InstrumentException("Size is larger than range between begin and end!");
        }
        int[] seed = new int[end - begin];
        for (int i = begin; i < end; ++i) {
            seed[i - begin] = i;
        }
        int[] ranArr = new int[size];
        Random ran = new Random();
        for (int i = 0; i < size; ++i) {
            int j = ran.nextInt(seed.length - i);
            ranArr[i] = seed[j];
            seed[j] = seed[seed.length - 1 - i];
        }
        return ranArr;
    }

    public static Integer[] generateBySet(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new InstrumentException("Size is larger than range between begin and end!");
        }
        Random ran = new Random();
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < size) {
            set.add(begin + ran.nextInt(end - begin));
        }
        return set.toArray(new Integer[size]);
    }

    public static int[] range(int stop) {
        return NumberUtils.range(0, stop);
    }

    public static int[] range(int start, int stop) {
        return NumberUtils.range(start, stop, 1);
    }

    public static int[] range(int start, int stop, int step) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            return new int[]{start};
        }
        int size = Math.abs((stop - start) / step) + 1;
        int[] values = new int[size];
        int index = 0;
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values[index] = i;
            ++index;
            i += step;
        }
        return values;
    }

    public static Collection<Integer> appendRange(int start, int stop, Collection<Integer> values) {
        return NumberUtils.appendRange(start, stop, 1, values);
    }

    public static Collection<Integer> appendRange(int start, int stop, int step, Collection<Integer> values) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            values.add(start);
            return values;
        }
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values.add(i);
            i += step;
        }
        return values;
    }

    public static long factorial(long start, long end) {
        if (start < end) {
            return 0L;
        }
        if (start == end) {
            return 1L;
        }
        return start * NumberUtils.factorial(start - 1L, end);
    }

    public static long factorial(long n) {
        return NumberUtils.factorial(n, 1L);
    }

    public static long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int processMultiple(int selectNum, int minNum) {
        int result = NumberUtils.mathSubnode(selectNum, minNum) / NumberUtils.mathNode(selectNum - minNum);
        return result;
    }

    public static int divisor(int m, int n) {
        while (m % n != 0) {
            int temp = m % n;
            m = n;
            n = temp;
        }
        return n;
    }

    public static int multiple(int m, int n) {
        return m * n / NumberUtils.divisor(m, n);
    }

    public static String getBinaryStr(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public static int binaryToInt(String binaryStr) {
        return Integer.parseInt(binaryStr, 2);
    }

    public static long binaryToLong(String binaryStr) {
        return Long.parseLong(binaryStr, 2);
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static int compare(double x, double y) {
        return Double.compare(x, y);
    }

    public static int compare(int x, int y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public static int compare(long x, long y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public static int compare(short x, short y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public static int compare(byte x, byte y) {
        return x - y;
    }

    public static boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return 0 == bigNum1.compareTo(bigNum2);
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        return CharUtils.equals(c1, c2, ignoreCase);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayUtils.min(numberArray);
    }

    public static long min(long ... numberArray) {
        return ArrayUtils.min(numberArray);
    }

    public static int min(int ... numberArray) {
        return ArrayUtils.min(numberArray);
    }

    public static short min(short ... numberArray) {
        return ArrayUtils.min(numberArray);
    }

    public static double min(double ... numberArray) {
        return ArrayUtils.min(numberArray);
    }

    public static float min(float ... numberArray) {
        return ArrayUtils.min(numberArray);
    }

    public static BigDecimal min(BigDecimal ... numberArray) {
        return (BigDecimal)ArrayUtils.min((Comparable[])numberArray);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayUtils.max(numberArray);
    }

    public static long max(long ... numberArray) {
        return ArrayUtils.max(numberArray);
    }

    public static int max(int ... numberArray) {
        return ArrayUtils.max(numberArray);
    }

    public static short max(short ... numberArray) {
        return ArrayUtils.max(numberArray);
    }

    public static double max(double ... numberArray) {
        return ArrayUtils.max(numberArray);
    }

    public static float max(float ... numberArray) {
        return ArrayUtils.max(numberArray);
    }

    public static BigDecimal max(BigDecimal ... numberArray) {
        return (BigDecimal)ArrayUtils.max((Comparable[])numberArray);
    }

    public static String toStr(Number number, String defaultValue) {
        return null == number ? defaultValue : NumberUtils.toStr(number);
    }

    public static String toStr(Number number) {
        if (null == number) {
            throw new NullPointerException("Number is null !");
        }
        if (!ObjectUtils.isValidIfNumber(number)) {
            throw new IllegalArgumentException("Number is non-finite!");
        }
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String number) {
        return null == number ? BigDecimal.ZERO : new BigDecimal(number);
    }

    public static int count(int total, int part) {
        return total % part == 0 ? total / part : total / part + 1;
    }

    public static BigDecimal null2Zero(BigDecimal decimal) {
        return decimal == null ? BigDecimal.ZERO : decimal;
    }

    public static int zero2One(int value) {
        return 0 == value ? 1 : value;
    }

    public static BigInteger newBigInteger(String str) {
        if (null == str) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        if (pos > 0) {
            str = str.substring(pos);
        }
        BigInteger value = new BigInteger(str, radix);
        return negate ? value.negate() : value;
    }

    public static boolean isBeside(long number1, long number2) {
        return Math.abs(number1 - number2) == 1L;
    }

    public static boolean isBeside(int number1, int number2) {
        return Math.abs(number1 - number2) == 1;
    }

    public static int partValue(int total, int partCount) {
        return NumberUtils.partValue(total, partCount, true);
    }

    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        int partValue = total / partCount;
        if (isPlusOneWhenHasRem && total % partCount == 0) {
            ++partValue;
        }
        return partValue;
    }

    public static BigDecimal pow(Number number, int n) {
        return NumberUtils.pow(NumberUtils.toBigDecimal(number), n);
    }

    public static BigDecimal pow(BigDecimal number, int n) {
        return number.pow(n);
    }

    public static int parseInt(String number) {
        if (StringUtils.isBlank(number)) {
            return 0;
        }
        if (StringUtils.isEmpty(number = StringUtils.subBefore((CharSequence)number, '.', false))) {
            return 0;
        }
        if (StringUtils.startWithIgnoreCase(number, "0x")) {
            return Integer.parseInt(number.substring(2), 16);
        }
        return Integer.parseInt(NumberUtils.removeNumberFlag(number));
    }

    public static long parseLong(String number) {
        if (StringUtils.isBlank(number)) {
            return 0L;
        }
        if (StringUtils.isEmpty(number = StringUtils.subBefore((CharSequence)number, '.', false))) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        return Long.parseLong(NumberUtils.removeNumberFlag(number));
    }

    public static Number parseNumber(String numberStr) {
        numberStr = NumberUtils.removeNumberFlag(numberStr);
        try {
            return NumberFormat.getInstance().parse(numberStr);
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    private static int mathSubnode(int selectNum, int minNum) {
        if (selectNum == minNum) {
            return 1;
        }
        return selectNum * NumberUtils.mathSubnode(selectNum - 1, minNum);
    }

    private static int mathNode(int selectNum) {
        if (selectNum == 0) {
            return 1;
        }
        return selectNum * NumberUtils.mathNode(selectNum - 1);
    }

    private static String removeNumberFlag(String number) {
        int lastPos = number.length() - 1;
        char lastCharUpper = Character.toUpperCase(number.charAt(lastPos));
        if ('D' == lastCharUpper || 'L' == lastCharUpper || 'F' == lastCharUpper) {
            number = StringUtils.subPre(number, lastPos);
        }
        return number;
    }

    public static String addZero(Number numObj, int length) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(length);
        nf.setMinimumIntegerDigits(length);
        return nf.format(numObj);
    }

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double toDouble(BigDecimal value) {
        return NumberUtils.toDouble(value, 0.0);
    }

    public static double toDouble(BigDecimal value, double defaultValue) {
        return value == null ? defaultValue : value.doubleValue();
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value) {
        return NumberUtils.toScaledBigDecimal(value, (int)Normal.INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(BigDecimal value, int scale, RoundingMode roundingMode) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value.setScale(scale, roundingMode == null ? RoundingMode.HALF_EVEN : roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Float value) {
        return NumberUtils.toScaledBigDecimal(value, (int)Normal.INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Float value, int scale, RoundingMode roundingMode) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(value.floatValue()), scale, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(Double value) {
        return NumberUtils.toScaledBigDecimal(value, (int)Normal.INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(Double value, int scale, RoundingMode roundingMode) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(BigDecimal.valueOf(value), scale, roundingMode);
    }

    public static BigDecimal toScaledBigDecimal(String value) {
        return NumberUtils.toScaledBigDecimal(value, (int)Normal.INTEGER_TWO, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal toScaledBigDecimal(String value, int scale, RoundingMode roundingMode) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return NumberUtils.toScaledBigDecimal(NumberUtils.createBigDecimal(value), scale, roundingMode);
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (str.trim().startsWith("--")) {
            throw new NumberFormatException(str + " is not a valid number.");
        }
        return new BigDecimal(str);
    }
}

