/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.unix.freebsd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.common.unix.freebsd.BsdSysctlUtils;
import org.aoju.bus.health.hardware.Disks;
import org.aoju.bus.health.hardware.HWDiskStore;
import org.aoju.bus.health.hardware.HWPartition;

public class FreeBsdDisks
implements Disks {
    private static final Pattern MOUNT_PATTERN = Pattern.compile("/dev/(\\S+p\\d+) on (\\S+) .*");
    private static final Map<String, HWDiskStore> diskMap = new HashMap<String, HWDiskStore>();
    private static final Map<String, String> mountMap = new HashMap<String, String>();

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        List<String> output = Command.runNative("iostat -Ix " + diskStore.getName());
        long timeStamp = System.currentTimeMillis();
        boolean diskFound = false;
        for (String line : output) {
            String[] split = Builder.whitespaces.split(line);
            if (split.length < 7 || !split[0].equals(diskStore.getName())) continue;
            diskFound = true;
            diskStore.setReads((long)Builder.parseDoubleOrDefault(split[1], 0.0));
            diskStore.setWrites((long)Builder.parseDoubleOrDefault(split[2], 0.0));
            diskStore.setReadBytes((long)(Builder.parseDoubleOrDefault(split[3], 0.0) * 1024.0));
            diskStore.setWriteBytes((long)(Builder.parseDoubleOrDefault(split[4], 0.0) * 1024.0));
            diskStore.setCurrentQueueLength(Builder.parseLongOrDefault(split[5], 0L));
            diskStore.setTransferTime((long)(Builder.parseDoubleOrDefault(split[6], 0.0) * 1000.0));
            diskStore.setTimeStamp(timeStamp);
        }
        return diskFound;
    }

    @Override
    public HWDiskStore[] getDisks() {
        mountMap.clear();
        for (String mnt : Command.runNative("mount")) {
            Matcher m = MOUNT_PATTERN.matcher(mnt);
            if (!m.matches()) continue;
            mountMap.put(m.group(1), m.group(2));
        }
        diskMap.clear();
        List<String> devices = Arrays.asList(Builder.whitespaces.split(BsdSysctlUtils.sysctl("kern.disks", "")));
        ArrayList<HWPartition> partList = new ArrayList<HWPartition>();
        List<String> disks = Command.runNative("iostat -Ix");
        long timeStamp = System.currentTimeMillis();
        for (String line : disks) {
            String[] split = Builder.whitespaces.split(line);
            if (split.length < 7 || !devices.contains(split[0])) continue;
            HWDiskStore hWDiskStore = new HWDiskStore();
            hWDiskStore.setName((String)split[0]);
            hWDiskStore.setReads((long)Builder.parseDoubleOrDefault((String)split[1], 0.0));
            hWDiskStore.setWrites((long)Builder.parseDoubleOrDefault((String)split[2], 0.0));
            hWDiskStore.setReadBytes((long)(Builder.parseDoubleOrDefault((String)split[3], 0.0) * 1024.0));
            hWDiskStore.setWriteBytes((long)(Builder.parseDoubleOrDefault((String)split[4], 0.0) * 1024.0));
            hWDiskStore.setCurrentQueueLength(Builder.parseLongOrDefault((String)split[5], 0L));
            hWDiskStore.setTransferTime((long)(Builder.parseDoubleOrDefault((String)split[6], 0.0) * 1000.0));
            hWDiskStore.setTimeStamp(timeStamp);
            diskMap.put((String)split[0], hWDiskStore);
        }
        List<String> geom = Command.runNative("geom disk list");
        HWDiskStore store = null;
        for (String string : geom) {
            String[] split;
            if (string.startsWith("Geom name:")) {
                String device;
                if (store != null) {
                    this.setPartitions(store, partList);
                }
                if (devices.contains(device = string.substring(string.lastIndexOf(32) + 1)) && (store = diskMap.get(device)) == null) {
                    store = new HWDiskStore();
                    store.setName(device);
                }
            }
            if (store == null) continue;
            String string2 = string.trim();
            if (string2.startsWith("Mediasize:") && (split = Builder.whitespaces.split(string2)).length > 1) {
                store.setSize(Builder.parseLongOrDefault(split[1], 0L));
            }
            if (string2.startsWith("descr:")) {
                store.setModel(string2.replace("descr:", "").trim());
            }
            if (!string2.startsWith("ident:")) continue;
            store.setSerial(string2.replace("ident:", "").replace("(null)", "").trim());
        }
        geom = Command.runNative("geom part list");
        store = null;
        HWPartition partition = null;
        for (String line : geom) {
            String[] split;
            String device;
            if ((line = line.trim()).startsWith("Geom name:") && devices.contains(device = line.substring(line.lastIndexOf(32) + 1)) && (store = diskMap.get(device)) == null) {
                store = new HWDiskStore();
                store.setName(device);
            }
            if (store == null) continue;
            if (line.contains("Name:")) {
                String part;
                if (partition != null) {
                    partList.add(partition);
                    partition = null;
                }
                if ((part = line.substring(line.lastIndexOf(32) + 1)).startsWith(store.getName())) {
                    partition = new HWPartition();
                    partition.setIdentification(part);
                    partition.setName(part);
                    partition.setMountPoint(mountMap.getOrDefault(part, ""));
                }
            }
            if (partition == null || (split = Builder.whitespaces.split(line)).length < 2) continue;
            if (line.startsWith("Mediasize:")) {
                partition.setSize(Builder.parseLongOrDefault(split[1], 0L));
                continue;
            }
            if (line.startsWith("rawuuid:")) {
                partition.setUuid(split[1]);
                continue;
            }
            if (!line.startsWith("type:")) continue;
            partition.setType(split[1]);
        }
        if (store != null) {
            this.setPartitions(store, partList);
        }
        ArrayList<HWDiskStore> arrayList = new ArrayList<HWDiskStore>(diskMap.keySet().size());
        arrayList.addAll(diskMap.values());
        Collections.sort(arrayList);
        return arrayList.toArray(new HWDiskStore[0]);
    }

    private void setPartitions(HWDiskStore store, List<HWPartition> partList) {
        HWPartition[] partitions = new HWPartition[partList.size()];
        int index = 0;
        Collections.sort(partList);
        for (HWPartition partition : partList) {
            partition.setMinor(Builder.parseIntOrDefault(Command.getFirstAnswer("stat -f %i /dev/" + partition.getName()), 0));
            partitions[index++] = partition;
        }
        partList.clear();
        store.setPartitions(partitions);
    }
}

