/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.DefaultProvider;

public class WeChatEEProvider
extends DefaultProvider {
    public WeChatEEProvider(Context context) {
        super(context, Registry.WECHAT_EE);
    }

    public WeChatEEProvider(Context context, StateCache stateCache) {
        super(context, Registry.WECHAT_EE, stateCache);
    }

    @Override
    protected AccToken getAccessToken(Callback Callback2) {
        String response = this.doGetAuthorizationCode(this.accessTokenUrl(Callback2.getCode()));
        JSONObject object = this.checkResponse(response);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).code(Callback2.getCode()).build();
    }

    @Override
    protected Property getUserInfo(AccToken token) {
        String response = this.doGetUserInfo(token);
        JSONObject object = this.checkResponse(response);
        if (!object.containsKey((Object)"UserId")) {
            throw new InstrumentException(Builder.Status.UNIDENTIFIED_PLATFORM.getCode());
        }
        String userId = object.getString("UserId");
        String userDetailResponse = this.getUserDetail(token.getAccessToken(), userId);
        JSONObject userDetail = this.checkResponse(userDetailResponse);
        return Property.builder().username(userDetail.getString("name")).nickname(userDetail.getString("alias")).avatar(userDetail.getString("avatar")).location(userDetail.getString("address")).email(userDetail.getString("email")).uuid(userId).gender(Normal.Gender.getGender(object.getString("gender"))).token(token).source(this.source.toString()).build();
    }

    private JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"errcode") && object.getIntValue("errcode") != 0) {
            throw new InstrumentException(StringUtils.toString(object.getIntValue("errcode")), object.getString("errmsg"));
        }
        return object;
    }

    @Override
    public String authorize(String state) {
        return Builder.fromBaseUrl(this.source.authorize()).queryParam("appid", this.context.getClientId()).queryParam("agentid", this.context.getAgentId()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromBaseUrl(this.source.accessToken()).queryParam("corpid", this.context.getClientId()).queryParam("corpsecret", this.context.getClientSecret()).build();
    }

    @Override
    protected String userInfoUrl(AccToken token) {
        return Builder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", token.getAccessToken()).queryParam("code", token.getCode()).build();
    }

    private String getUserDetail(String accessToken, String userId) {
        String userDetailUrl = Builder.fromBaseUrl("https://qyapi.weixin.qq.com/cgi-bin/user/get").queryParam("access_token", accessToken).queryParam("userid", userId).build();
        return Httpx.get(userDetailUrl);
    }
}

