/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.proxy;

import java.util.Properties;
import org.aoju.bus.pager.IPage;
import org.aoju.bus.pager.Page;
import org.aoju.bus.pager.PageContext;
import org.aoju.bus.pager.PageRowBounds;
import org.aoju.bus.pager.plugin.PageFromObject;
import org.apache.ibatis.session.RowBounds;

public class PageParams {
    protected boolean offsetAsPageNum = false;
    protected boolean rowBoundsWithCount = false;
    protected boolean pageSizeZero = false;
    protected boolean reasonable = false;
    protected boolean supportMethodsArguments = false;
    protected String countColumn = "0";

    public Page getPage(Object parameterObject, RowBounds rowBounds) {
        Page<Object> page = PageContext.getLocalPage();
        if (page == null) {
            if (rowBounds != RowBounds.DEFAULT) {
                if (this.offsetAsPageNum) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(new int[]{rowBounds.getOffset(), rowBounds.getLimit()}, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
                if (rowBounds instanceof PageRowBounds) {
                    PageRowBounds pageRowBounds = (PageRowBounds)rowBounds;
                    page.setCount(pageRowBounds.getCount() == null || pageRowBounds.getCount() != false);
                }
            } else if (parameterObject instanceof IPage || this.supportMethodsArguments) {
                try {
                    page = PageFromObject.getPageFromObject(parameterObject, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (page == null) {
                return null;
            }
            PageContext.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    public void setProperties(Properties properties) {
        String offsetAsPageNum = properties.getProperty("offsetAsPageNum");
        this.offsetAsPageNum = Boolean.parseBoolean(offsetAsPageNum);
        String rowBoundsWithCount = properties.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = properties.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = properties.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        String supportMethodsArguments = properties.getProperty("supportMethodsArguments");
        this.supportMethodsArguments = Boolean.parseBoolean(supportMethodsArguments);
        String countColumn = properties.getProperty("countColumn");
        if (PageFromObject.isNotEmpty(countColumn)) {
            this.countColumn = countColumn;
        }
        PageFromObject.setParams(properties.getProperty("params"));
    }

    public boolean isOffsetAsPageNum() {
        return this.offsetAsPageNum;
    }

    public boolean isRowBoundsWithCount() {
        return this.rowBoundsWithCount;
    }

    public boolean isPageSizeZero() {
        return this.pageSizeZero;
    }

    public boolean isReasonable() {
        return this.reasonable;
    }

    public boolean isSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    public String getCountColumn() {
        return this.countColumn;
    }
}

