/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.oauth;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Provider;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.metric.StateCache;
import org.aoju.bus.oauth.provider.AlipayProvider;
import org.aoju.bus.oauth.provider.BaiduProvider;
import org.aoju.bus.oauth.provider.CodingProvider;
import org.aoju.bus.oauth.provider.CsdnProvider;
import org.aoju.bus.oauth.provider.DingTalkProvider;
import org.aoju.bus.oauth.provider.DouyinProvider;
import org.aoju.bus.oauth.provider.FacebookProvider;
import org.aoju.bus.oauth.provider.GiteeProvider;
import org.aoju.bus.oauth.provider.GithubProvider;
import org.aoju.bus.oauth.provider.GitlabProvider;
import org.aoju.bus.oauth.provider.GoogleProvider;
import org.aoju.bus.oauth.provider.HuaweiProvider;
import org.aoju.bus.oauth.provider.KujialeProvider;
import org.aoju.bus.oauth.provider.LinkedinProvider;
import org.aoju.bus.oauth.provider.MiProvider;
import org.aoju.bus.oauth.provider.MicrosoftProvider;
import org.aoju.bus.oauth.provider.OschinaProvider;
import org.aoju.bus.oauth.provider.PinterestProvider;
import org.aoju.bus.oauth.provider.QqProvider;
import org.aoju.bus.oauth.provider.RenrenProvider;
import org.aoju.bus.oauth.provider.StackOverflowProvider;
import org.aoju.bus.oauth.provider.TaobaoProvider;
import org.aoju.bus.oauth.provider.TeambitionProvider;
import org.aoju.bus.oauth.provider.TencentCloudProvider;
import org.aoju.bus.oauth.provider.ToutiaoProvider;
import org.aoju.bus.oauth.provider.WeChatEEProvider;
import org.aoju.bus.oauth.provider.WeChatOPProvider;
import org.aoju.bus.oauth.provider.WeiboProvider;
import org.aoju.bus.starter.oauth.AuthProperties;

public class AuthProviderService {
    public final AuthProperties properties;
    public final StateCache stateCache;

    public Provider get(Registry type) {
        Context context = this.properties.getType().get(type);
        if (Registry.GITHUB.equals(type)) {
            return new GithubProvider(context, this.stateCache);
        }
        if (Registry.WEIBO.equals(type)) {
            return new WeiboProvider(context, this.stateCache);
        }
        if (Registry.GITEE.equals(type)) {
            return new GiteeProvider(context, this.stateCache);
        }
        if (Registry.DINGTALK.equals(type)) {
            return new DingTalkProvider(context, this.stateCache);
        }
        if (Registry.BAIDU.equals(type)) {
            return new BaiduProvider(context, this.stateCache);
        }
        if (Registry.CSDN.equals(type)) {
            return new CsdnProvider(context, this.stateCache);
        }
        if (Registry.CODING.equals(type)) {
            return new CodingProvider(context, this.stateCache);
        }
        if (Registry.TENCENT_CLOUD.equals(type)) {
            return new TencentCloudProvider(context, this.stateCache);
        }
        if (Registry.OSCHINA.equals(type)) {
            return new OschinaProvider(context, this.stateCache);
        }
        if (Registry.ALIPAY.equals(type)) {
            return new AlipayProvider(context, this.stateCache);
        }
        if (Registry.QQ.equals(type)) {
            return new QqProvider(context, this.stateCache);
        }
        if (Registry.WECHAT_OPEN.equals(type)) {
            return new WeChatOPProvider(context, this.stateCache);
        }
        if (Registry.TAOBAO.equals(type)) {
            return new TaobaoProvider(context, this.stateCache);
        }
        if (Registry.GOOGLE.equals(type)) {
            return new GoogleProvider(context, this.stateCache);
        }
        if (Registry.FACEBOOK.equals(type)) {
            return new FacebookProvider(context, this.stateCache);
        }
        if (Registry.DOUYIN.equals(type)) {
            return new DouyinProvider(context, this.stateCache);
        }
        if (Registry.LINKEDIN.equals(type)) {
            return new LinkedinProvider(context, this.stateCache);
        }
        if (Registry.MICROSOFT.equals(type)) {
            return new MicrosoftProvider(context, this.stateCache);
        }
        if (Registry.MI.equals(type)) {
            return new MiProvider(context, this.stateCache);
        }
        if (Registry.TOUTIAO.equals(type)) {
            return new ToutiaoProvider(context, this.stateCache);
        }
        if (Registry.TEAMBITION.equals(type)) {
            return new TeambitionProvider(context, this.stateCache);
        }
        if (Registry.RENREN.equals(type)) {
            return new RenrenProvider(context, this.stateCache);
        }
        if (Registry.PINTEREST.equals(type)) {
            return new PinterestProvider(context, this.stateCache);
        }
        if (Registry.STACK.equals(type)) {
            return new StackOverflowProvider(context, this.stateCache);
        }
        if (Registry.HUAWEI.equals(type)) {
            return new HuaweiProvider(context, this.stateCache);
        }
        if (Registry.WECHAT_EE.equals(type)) {
            return new WeChatEEProvider(context, this.stateCache);
        }
        if (Registry.GITLAB.equals(type)) {
            return new GitlabProvider(context, this.stateCache);
        }
        if (Registry.KUJIALE.equals(type)) {
            return new KujialeProvider(context, this.stateCache);
        }
        throw new InstrumentException(Builder.Status.UNSUPPORTED.getCode());
    }

    public AuthProviderService(AuthProperties properties, StateCache stateCache) {
        this.properties = properties;
        this.stateCache = stateCache;
    }
}

