/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Holder;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class PatternUtils {
    private static final Map<RegexWithFlag, Pattern> cache = new WeakHashMap<RegexWithFlag, Pattern>();
    private static final ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock readLock = cacheLock.readLock();
    private static final ReentrantReadWriteLock.WriteLock writeLock = cacheLock.writeLock();

    public static Pattern get(String regex) {
        return PatternUtils.get(regex, 0);
    }

    public static Pattern get(String regex, int flags) {
        RegexWithFlag regexWithFlag = new RegexWithFlag(regex, flags);
        Pattern pattern = PatternUtils.isGet(regexWithFlag);
        if (null == pattern) {
            pattern = Pattern.compile(regex, flags);
            PatternUtils.isPut(regexWithFlag, pattern);
        }
        return pattern;
    }

    public static String get(String regex, String content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.get(pattern, content, groupIndex);
    }

    public static String get(Pattern pattern, String content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String getGroup0(String regex, String content) {
        return PatternUtils.get(regex, content, 0);
    }

    public static String getGroup1(String regex, String content) {
        return PatternUtils.get(regex, content, 1);
    }

    public static String getGroup0(Pattern pattern, String content) {
        return PatternUtils.get(pattern, content, 0);
    }

    public static String getGroup1(Pattern pattern, String content) {
        return PatternUtils.get(pattern, content, 1);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content) {
        return PatternUtils.getAllGroups(pattern, content, true);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0) {
        if (null == content || null == pattern) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int startGroup = withGroup0 ? 0 : 1;
            int groupCount = matcher.groupCount();
            for (int i = startGroup; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public static String extractMulti(Pattern pattern, CharSequence content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        TreeSet<Integer> varNums = new TreeSet<Integer>((o1, o2) -> ObjectUtils.compare(o2, o1));
        Matcher matcherForTemplate = RegEx.GROUP_VAR.matcher(template);
        while (matcherForTemplate.find()) {
            varNums.add(Integer.parseInt(matcherForTemplate.group(1)));
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (Integer group : varNums) {
                template = template.replace("$" + group, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, CharSequence content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.extractMulti(pattern, content, template);
    }

    public static String extractMultiAndDelPre(Pattern pattern, Holder<CharSequence> contentHolder, String template) {
        if (null == contentHolder || null == pattern || null == template) {
            return null;
        }
        HashSet<String> varNums = PatternUtils.findAll(RegEx.GROUP_VAR, template, 1, new HashSet());
        CharSequence content = (CharSequence)contentHolder.get();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            contentHolder.set(StringUtils.sub(content, matcher.end(), content.length()));
            return template;
        }
        return null;
    }

    public static String extractMultiAndDelPre(String regex, Holder<CharSequence> contentHolder, String template) {
        if (null == contentHolder || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.extractMultiAndDelPre(pattern, contentHolder, template);
    }

    public static String delFirst(Pattern pattern, String content) {
        if (null == pattern || StringUtils.isBlank(content)) {
            return content;
        }
        return pattern.matcher(content).replaceFirst("");
    }

    public static String delAll(Pattern pattern, String content) {
        if (null == pattern || StringUtils.isBlank(content)) {
            return content;
        }
        return pattern.matcher(content).replaceAll("");
    }

    public static String delAll(String regex, String content) {
        if (StringUtils.hasBlank(regex, content)) {
            return content;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.delAll(pattern, content);
    }

    public static String delPre(String regex, String content) {
        if (null == content || null == regex) {
            return content;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return StringUtils.sub(content, matcher.end(), content.length());
        }
        return content;
    }

    public static List<String> findAllGroup0(String regex, String content) {
        return PatternUtils.findAll(regex, content, 0);
    }

    public static List<String> findAllGroup1(String regex, String content) {
        return PatternUtils.findAll(regex, content, 1);
    }

    public static List<String> findAll(String regex, String content, int group) {
        return PatternUtils.findAll(regex, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(String regex, String content, int group, T collection) {
        if (null == regex) {
            return null;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.findAll(pattern, content, group, collection);
    }

    public static List<String> findAll(Pattern pattern, String content, int group) {
        return PatternUtils.findAll(pattern, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, String content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        if (null == collection) {
            throw new NullPointerException("Null collection param provided!");
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static int count(String regex, String content) {
        if (null == regex || null == content) {
            return 0;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.count(pattern, content);
    }

    public static int count(Pattern pattern, String content) {
        if (null == pattern || null == content) {
            return 0;
        }
        int count = 0;
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean contains(String regex, String content) {
        if (null == regex || null == content) {
            return false;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.contains(pattern, content);
    }

    public static boolean contains(Pattern pattern, String content) {
        if (null == pattern || null == content) {
            return false;
        }
        return pattern.matcher(content).find();
    }

    public static boolean isMatch(String regex, CharSequence content) {
        if (content == null) {
            return false;
        }
        if (StringUtils.isEmpty(regex)) {
            return true;
        }
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String replaceAll(String content, String regex, String replacementTemplate) {
        Pattern pattern = PatternUtils.get(regex, 32);
        return PatternUtils.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(String content, Pattern pattern, String replacementTemplate) {
        if (StringUtils.isEmpty(content)) {
            return content;
        }
        Matcher matcher = pattern.matcher(content);
        return matcher.replaceAll(replacementTemplate);
    }

    public static String replaceAll(CharSequence content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return PatternUtils.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(CharSequence content, Pattern pattern, String replacementTemplate) {
        if (StringUtils.isEmpty(content)) {
            return StringUtils.str(content);
        }
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (result) {
            Set varNums = PatternUtils.findAll(RegEx.GROUP_VAR, replacementTemplate, 1, new HashSet());
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, PatternUtils.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return StringUtils.str(content);
    }

    public static String escape(char c) {
        StringBuilder builder = new StringBuilder();
        if (RegEx.RE_KEYS.contains(Character.valueOf(c))) {
            builder.append('\\');
        }
        builder.append(c);
        return builder.toString();
    }

    public static String escape(String content) {
        if (StringUtils.isBlank(content)) {
            return content;
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RegEx.RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }

    private static Pattern isGet(RegexWithFlag key) {
        Pattern value;
        readLock.lock();
        try {
            value = cache.get(key);
        }
        finally {
            readLock.unlock();
        }
        return value;
    }

    private static Object isPut(RegexWithFlag key, Pattern value) {
        writeLock.lock();
        try {
            cache.put(key, value);
        }
        finally {
            writeLock.unlock();
        }
        return value;
    }

    private static Object isRemove(Object key) {
        writeLock.lock();
        try {
            Pattern pattern = cache.remove(key);
            return pattern;
        }
        finally {
            writeLock.unlock();
        }
    }

    public static Integer getFirstNumber(CharSequence StringWithNumber) {
        return Convert.toInt(PatternUtils.get(RegEx.NUMBERS, StringWithNumber, 0), null);
    }

    public void clear() {
        writeLock.lock();
        try {
            cache.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    private static class RegexWithFlag {
        private String regex;
        private int flag;

        public RegexWithFlag(String regex, int flag) {
            this.regex = regex;
            this.flag = flag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.flag;
            result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexWithFlag other = (RegexWithFlag)obj;
            if (this.flag != other.flag) {
                return false;
            }
            if (this.regex == null) {
                return other.regex == null;
            }
            return this.regex.equals(other.regex);
        }
    }
}

