/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.common.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import org.aoju.bus.health.common.unix.freebsd.FreeBsdLibc;
import org.aoju.bus.logger.Logger;

public class BsdSysctlUtils {
    private static final String SYSCTL_FAIL = "Failed syctl call: {}, Error code: {}";

    private BsdSysctlUtils() {
    }

    public static int sysctl(String name, int def) {
        IntByReference size = new IntByReference(FreeBsdLibc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            Logger.error("Failed sysctl call: {}, Error code: {}", name, Native.getLastError());
            return def;
        }
        return p.getInt(0L);
    }

    public static long sysctl(String name, long def) {
        IntByReference size = new IntByReference(FreeBsdLibc.UINT64_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
            return def;
        }
        return p.getLong(0L);
    }

    public static String sysctl(String name, String def) {
        IntByReference size = new IntByReference();
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, null, size, null, 0)) {
            Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
            return def;
        }
        Memory p = new Memory((long)(size.getValue() + 1));
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            Logger.warn(SYSCTL_FAIL, name, Native.getLastError());
            return def;
        }
        return p.getString(0L);
    }

    public static boolean sysctl(String name, Structure struct) {
        if (0 != FreeBsdLibc.INSTANCE.sysctlbyname(name, struct.getPointer(), new IntByReference(struct.size()), null, 0)) {
            Logger.error(SYSCTL_FAIL, name, Native.getLastError());
            return false;
        }
        struct.read();
        return true;
    }
}

