/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software.linux;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.linux.LibC;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Command;
import org.aoju.bus.health.common.linux.LinuxLibc;
import org.aoju.bus.health.common.linux.ProcUtils;
import org.aoju.bus.health.software.AbstractOS;
import org.aoju.bus.health.software.FileSystem;
import org.aoju.bus.health.software.NetworkParams;
import org.aoju.bus.health.software.OSProcess;
import org.aoju.bus.health.software.OSService;
import org.aoju.bus.health.software.OSUser;
import org.aoju.bus.health.software.OperatingSystem;
import org.aoju.bus.health.software.linux.LinuxFileSystem;
import org.aoju.bus.health.software.linux.LinuxNetwork;
import org.aoju.bus.health.software.linux.LinuxUserGroupInfo;
import org.aoju.bus.logger.Logger;

public class LinuxOS
extends AbstractOS {
    private static final long BOOTTIME;
    private static final int[] PROC_PID_STAT_ORDERS;
    private static final int PROC_PID_STAT_LENGTH;
    private static final long USER_HZ;
    private static final long BOOT_TIME;
    private final int memoryPageSize = Builder.parseIntOrDefault(Command.getFirstAnswer("getconf PAGESIZE"), 4096);
    private String versionId;
    private String codeName;

    private static int getParentPidFromProcFile(int pid) {
        String stat = Builder.getStringFromFile(String.format("/proc/%d/stat", pid));
        long[] statArray = Builder.parseStringToLongArray(stat, PROC_PID_STAT_ORDERS, PROC_PID_STAT_LENGTH, ' ');
        return (int)statArray[ProcPidStat.PPID.ordinal()];
    }

    protected static String getReleaseFilename() {
        File etc = new File("/etc");
        File[] matchingFiles = etc.listFiles(f -> (f.getName().endsWith("-release") || f.getName().endsWith("-version") || f.getName().endsWith("_release") || f.getName().endsWith("_version")) && !f.getName().endsWith("os-release") && !f.getName().endsWith("lsb-release") && !f.getName().endsWith("system-release"));
        if (matchingFiles != null && matchingFiles.length > 0) {
            return matchingFiles[0].getPath();
        }
        if (new File("/etc/release").exists()) {
            return "/etc/release";
        }
        return "/etc/issue";
    }

    private static String filenameToFamily(String name) {
        switch (name.toLowerCase()) {
            case "": {
                return "Solaris";
            }
            case "blackcat": {
                return "Black Cat";
            }
            case "bluewhite64": {
                return "BlueWhite64";
            }
            case "e-smith": {
                return "SME Server";
            }
            case "eos": {
                return "FreeEOS";
            }
            case "hlfs": {
                return "HLFS";
            }
            case "lfs": {
                return "Linux-From-Scratch";
            }
            case "linuxppc": {
                return "Linux-PPC";
            }
            case "meego": {
                return "MeeGo";
            }
            case "mandakelinux": {
                return "Mandrake";
            }
            case "mklinux": {
                return "MkLinux";
            }
            case "nld": {
                return "Novell Linux Desktop";
            }
            case "novell": 
            case "SuSE": {
                return "SUSE Linux";
            }
            case "pld": {
                return "PLD";
            }
            case "redhat": {
                return "Red Hat Linux";
            }
            case "sles": {
                return "SUSE Linux ES9";
            }
            case "sun": {
                return "Sun JDS";
            }
            case "synoinfo": {
                return "Synology";
            }
            case "tinysofa": {
                return "Tiny Sofa";
            }
            case "turbolinux": {
                return "TurboLinux";
            }
            case "ultrapenguin": {
                return "UltraPenguin";
            }
            case "va": {
                return "VA-Linux";
            }
            case "vmware": {
                return "VMWareESX";
            }
            case "yellowdog": {
                return "Yellow Dog";
            }
            case "issue": {
                return "Unknown";
            }
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static long getHz() {
        return USER_HZ;
    }

    @Override
    public String queryManufacturer() {
        return "GNU/Linux";
    }

    @Override
    public AbstractOS.FamilyVersionInfo queryFamilyVersionInfo() {
        String family = this.queryFamilyFromReleaseFiles();
        OperatingSystem.OSVersionInfo versionInfo = new OperatingSystem.OSVersionInfo(this.versionId, this.codeName, null);
        return new AbstractOS.FamilyVersionInfo(family, versionInfo);
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness < 64 && Command.getFirstAnswer("uname -m").indexOf("64") == -1) {
            return jvmBitness;
        }
        return 64;
    }

    @Override
    protected boolean queryElevated() {
        return System.getenv("SUDO_COMMAND") != null;
    }

    @Override
    public FileSystem getFileSystem() {
        return new LinuxFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort, boolean slowFields) {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        File[] pids = ProcUtils.getPidFiles();
        LinuxUserGroupInfo userGroupInfo = new LinuxUserGroupInfo();
        for (File pidFile : pids) {
            int pid = Builder.parseIntOrDefault(pidFile.getName(), 0);
            OSProcess proc = this.getProcess(pid, userGroupInfo, slowFields);
            if (proc == null) continue;
            procs.add(proc);
        }
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    @Override
    public OSProcess getProcess(int pid, boolean slowFields) {
        return this.getProcess(pid, new LinuxUserGroupInfo(), slowFields);
    }

    private OSProcess getProcess(int pid, LinuxUserGroupInfo userGroupInfo, boolean slowFields) {
        String path = "";
        Memory buf = new Memory(1024L);
        int size = LinuxLibc.INSTANCE.readlink(String.format("/proc/%d/exe", pid), (Pointer)buf, 1023);
        if (size > 0) {
            String tmp;
            path = tmp.substring(0, (tmp = buf.getString(0L)).length() < size ? tmp.length() : size);
        }
        Map<String, String> io = Builder.getKeyValueMapFromFile(String.format("/proc/%d/io", pid), ":");
        long now = System.currentTimeMillis();
        String stat = Builder.getStringFromFile(String.format("/proc/%d/stat", pid));
        if (stat.isEmpty()) {
            return null;
        }
        long[] statArray = Builder.parseStringToLongArray(stat, PROC_PID_STAT_ORDERS, PROC_PID_STAT_LENGTH, ' ');
        OSProcess proc = new OSProcess(this);
        proc.setProcessID(pid);
        proc.setCommandLine(Builder.getStringFromFile(String.format("/proc/%d/cmdline", pid)));
        long startTime = BOOT_TIME + statArray[ProcPidStat.START_TIME.ordinal()] * 1000L / USER_HZ;
        if (startTime >= now) {
            startTime = now - 1L;
        }
        proc.setStartTime(startTime);
        proc.setParentProcessID((int)statArray[ProcPidStat.PPID.ordinal()]);
        proc.setThreadCount((int)statArray[ProcPidStat.THREAD_COUNT.ordinal()]);
        proc.setPriority((int)statArray[ProcPidStat.PRIORITY.ordinal()]);
        proc.setVirtualSize(statArray[ProcPidStat.VSZ.ordinal()]);
        proc.setResidentSetSize(statArray[ProcPidStat.RSS.ordinal()] * (long)this.memoryPageSize);
        proc.setKernelTime(statArray[ProcPidStat.KERNEL_TIME.ordinal()] * 1000L / USER_HZ);
        proc.setUserTime(statArray[ProcPidStat.USER_TIME.ordinal()] * 1000L / USER_HZ);
        proc.setUpTime(now - proc.getStartTime());
        proc.setBytesRead(Builder.parseLongOrDefault(io.getOrDefault("read_bytes", ""), 0L));
        proc.setBytesWritten(Builder.parseLongOrDefault(io.getOrDefault("write_bytes", ""), 0L));
        if (slowFields) {
            List<String> openFilesList = Command.runNative(String.format("ls -f /proc/%d/fd", pid));
            proc.setOpenFiles((long)openFilesList.size() - 1L);
            byte[] buffer = new byte[5];
            if (!path.isEmpty()) {
                try (FileInputStream is = new FileInputStream(path);){
                    if (((InputStream)is).read(buffer) == buffer.length) {
                        proc.setBitness(buffer[4] == 1 ? 32 : 64);
                    }
                }
                catch (IOException e) {
                    Logger.warn("Failed to read process file: {}", path);
                }
            }
        }
        Map<String, String> status = Builder.getKeyValueMapFromFile(String.format("/proc/%d/status", pid), ":");
        proc.setName(status.getOrDefault("Name", ""));
        proc.setPath(path);
        switch (status.getOrDefault("State", "U").charAt(0)) {
            case 'R': {
                proc.setState(OSProcess.State.RUNNING);
                break;
            }
            case 'S': {
                proc.setState(OSProcess.State.SLEEPING);
                break;
            }
            case 'D': {
                proc.setState(OSProcess.State.WAITING);
                break;
            }
            case 'Z': {
                proc.setState(OSProcess.State.ZOMBIE);
                break;
            }
            case 'T': {
                proc.setState(OSProcess.State.STOPPED);
                break;
            }
            default: {
                proc.setState(OSProcess.State.OTHER);
            }
        }
        proc.setUserID(Builder.whitespaces.split(status.getOrDefault("Uid", ""))[0]);
        proc.setGroupID(Builder.whitespaces.split(status.getOrDefault("Gid", ""))[0]);
        OSUser user = userGroupInfo.getUser(proc.getUserID());
        if (user != null) {
            proc.setUser(user.getUserName());
        }
        proc.setGroup(userGroupInfo.getGroupName(proc.getGroupID()));
        try {
            String cwdLink = String.format("/proc/%d/cwd", pid);
            String cwd = new File(cwdLink).getCanonicalPath();
            if (!cwd.equals(cwdLink)) {
                proc.setCurrentWorkingDirectory(cwd);
            }
        }
        catch (IOException e) {
            Logger.trace("Couldn't find cwd for pid {}: {}", pid, e);
        }
        return proc;
    }

    @Override
    public OSProcess[] getChildProcesses(int parentPid, int limit, OperatingSystem.ProcessSort sort) {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        File[] procFiles = ProcUtils.getPidFiles();
        LinuxUserGroupInfo userGroupInfo = new LinuxUserGroupInfo();
        for (File procFile : procFiles) {
            OSProcess proc;
            int pid = Builder.parseIntOrDefault(procFile.getName(), 0);
            if (parentPid != LinuxOS.getParentPidFromProcFile(pid) || (proc = this.getProcess(pid, userGroupInfo, true)) == null) continue;
            procs.add(proc);
        }
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    @Override
    public long getProcessAffinityMask(int processId) {
        String mask = Command.getFirstAnswer("taskset -p " + processId);
        String[] split = Builder.whitespaces.split(mask);
        try {
            return new BigInteger(split[split.length - 1], 16).longValue();
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public int getProcessId() {
        return LinuxLibc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcUtils.getPidFiles().length;
    }

    @Override
    public int getThreadCount() {
        try {
            LibC.Sysinfo info = new LibC.Sysinfo();
            if (0 != LibC.INSTANCE.sysinfo(info)) {
                Logger.error("Failed to get process thread count. Error code: {}", Native.getLastError());
                return 0;
            }
            return info.procs;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            Logger.error("Failed to get procs from sysinfo. {}", e);
            return 0;
        }
    }

    @Override
    public long getSystemUptime() {
        return (long)ProcUtils.getSystemUptimeSeconds();
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new LinuxNetwork();
    }

    private String queryFamilyFromReleaseFiles() {
        String family = this.readDistribRelease("/etc/system-release");
        if (family != null) {
            return family;
        }
        family = this.readOsRelease();
        if (family != null) {
            return family;
        }
        family = this.execLsbRelease();
        if (family != null) {
            return family;
        }
        family = this.readLsbRelease();
        if (family != null) {
            return family;
        }
        String etcDistribRelease = LinuxOS.getReleaseFilename();
        family = this.readDistribRelease(etcDistribRelease);
        if (family != null) {
            return family;
        }
        return LinuxOS.filenameToFamily(etcDistribRelease.replace("/etc/", "").replace("release", "").replace("version", "").replace("-", "").replace("_", ""));
    }

    private String readOsRelease() {
        String family = null;
        if (new File("/etc/os-release").exists()) {
            List<String> osRelease = Builder.readFile("/etc/os-release");
            for (String line : osRelease) {
                if (line.startsWith("VERSION=")) {
                    Logger.debug("os-release: {}", line);
                    line = line.replace("VERSION=", "").replaceAll("^\"|\"$", "").trim();
                    String[] split = line.split("[()]");
                    if (split.length <= 1) {
                        split = line.split(", ");
                    }
                    if (split.length > 0) {
                        this.versionId = split[0].trim();
                    }
                    if (split.length <= 1) continue;
                    this.codeName = split[1].trim();
                    continue;
                }
                if (line.startsWith("NAME=") && family == null) {
                    Logger.debug("os-release: {}", line);
                    family = line.replace("NAME=", "").replaceAll("^\"|\"$", "").trim();
                    continue;
                }
                if (!line.startsWith("VERSION_ID=") || this.versionId != null) continue;
                Logger.debug("os-release: {}", line);
                this.versionId = line.replace("VERSION_ID=", "").replaceAll("^\"|\"$", "").trim();
            }
        }
        return family;
    }

    private String execLsbRelease() {
        String family = null;
        for (String line : Command.runNative("lsb_release -a")) {
            if (line.startsWith("Description:")) {
                Logger.debug("lsb_release -a: {}", line);
                if (!(line = line.replace("Description:", "").trim()).contains(" release ")) continue;
                family = this.parseRelease(line, " release ");
                continue;
            }
            if (line.startsWith("Distributor ID:") && family == null) {
                Logger.debug("lsb_release -a: {}", line);
                family = line.replace("Distributor ID:", "").trim();
                continue;
            }
            if (line.startsWith("Release:") && this.versionId == null) {
                Logger.debug("lsb_release -a: {}", line);
                this.versionId = line.replace("Release:", "").trim();
                continue;
            }
            if (!line.startsWith("Codename:") || this.codeName != null) continue;
            Logger.debug("lsb_release -a: {}", line);
            this.codeName = line.replace("Codename:", "").trim();
        }
        return family;
    }

    private String readLsbRelease() {
        String family = null;
        if (new File("/etc/lsb-release").exists()) {
            List<String> osRelease = Builder.readFile("/etc/lsb-release");
            for (String line : osRelease) {
                if (line.startsWith("DISTRIB_DESCRIPTION=")) {
                    Logger.debug("lsb-release: {}", line);
                    if (!(line = line.replace("DISTRIB_DESCRIPTION=", "").replaceAll("^\"|\"$", "").trim()).contains(" release ")) continue;
                    family = this.parseRelease(line, " release ");
                    continue;
                }
                if (line.startsWith("DISTRIB_ID=") && family == null) {
                    Logger.debug("lsb-release: {}", line);
                    family = line.replace("DISTRIB_ID=", "").replaceAll("^\"|\"$", "").trim();
                    continue;
                }
                if (line.startsWith("DISTRIB_RELEASE=") && this.versionId == null) {
                    Logger.debug("lsb-release: {}", line);
                    this.versionId = line.replace("DISTRIB_RELEASE=", "").replaceAll("^\"|\"$", "").trim();
                    continue;
                }
                if (!line.startsWith("DISTRIB_CODENAME=") || this.codeName != null) continue;
                Logger.debug("lsb-release: {}", line);
                this.codeName = line.replace("DISTRIB_CODENAME=", "").replaceAll("^\"|\"$", "").trim();
            }
        }
        return family;
    }

    private String readDistribRelease(String filename) {
        String family = null;
        if (new File(filename).exists()) {
            List<String> osRelease = Builder.readFile(filename);
            for (String line : osRelease) {
                Logger.debug("{}: {}", filename, line);
                if (line.contains(" release ")) {
                    family = this.parseRelease(line, " release ");
                    break;
                }
                if (!line.contains(" VERSION ")) continue;
                family = this.parseRelease(line, " VERSION ");
                break;
            }
        }
        return family;
    }

    private String parseRelease(String line, String splitLine) {
        String[] split = line.split(splitLine);
        String family = split[0].trim();
        if (split.length > 1) {
            if ((split = split[1].split("[()]")).length > 0) {
                this.versionId = split[0].trim();
            }
            if (split.length > 1) {
                this.codeName = split[1].trim();
            }
        }
        return family;
    }

    @Override
    public OSService[] getServices() {
        ArrayList<OSService> services = new ArrayList<OSService>();
        HashSet<String> running = new HashSet<String>();
        for (OSProcess p : this.getChildProcesses(1, 0, OperatingSystem.ProcessSort.PID)) {
            OSService s = new OSService(p.getName(), p.getProcessID(), OSService.State.RUNNING);
            services.add(s);
            running.add(p.getName());
        }
        File dir = new File("/etc/init");
        if (dir.exists() && dir.isDirectory()) {
            for (File f2 : dir.listFiles((f, name) -> name.toLowerCase().endsWith(".conf"))) {
                String shortName;
                String name2 = f2.getName().substring(0, f2.getName().length() - 5);
                int index = name2.lastIndexOf(46);
                String string = shortName = index < 0 || index > name2.length() - 2 ? name2 : name2.substring(index + 1);
                if (running.contains(name2) || running.contains(shortName)) continue;
                OSService s = new OSService(name2, 0, OSService.State.STOPPED);
                services.add(s);
            }
        } else {
            Logger.error("Directory: /etc/init does not exist", new Object[0]);
        }
        return services.toArray(new OSService[0]);
    }

    static {
        PROC_PID_STAT_ORDERS = new int[ProcPidStat.values().length];
        USER_HZ = Builder.parseLongOrDefault(Command.getFirstAnswer("getconf CLK_TCK"), 100L);
        ProcPidStat[] procStat = Builder.readFile("/proc/stat");
        long tempBT = 0L;
        for (String string : procStat) {
            if (!string.startsWith("btime")) continue;
            String[] bTime = Builder.whitespaces.split(string);
            tempBT = Builder.parseLongOrDefault(bTime[1], 0L);
            break;
        }
        if (tempBT == 0L) {
            tempBT = System.currentTimeMillis() / 1000L - (long)ProcUtils.getSystemUptimeSeconds();
        }
        BOOTTIME = tempBT;
        for (ProcPidStat stat : ProcPidStat.values()) {
            LinuxOS.PROC_PID_STAT_ORDERS[stat.ordinal()] = stat.getOrder() - 1;
        }
        String stat = Builder.getStringFromFile(ProcUtils.getProcPath() + "/self/stat");
        PROC_PID_STAT_LENGTH = !stat.isEmpty() && stat.contains(")") ? Builder.countStringToLongArray(stat, ' ') + 3 : 52;
        double uptime = ProcUtils.getSystemUptimeSeconds();
        long now = System.currentTimeMillis();
        BOOT_TIME = now - (long)(500.0 * (uptime += ProcUtils.getSystemUptimeSeconds()) + 0.5);
    }

    static enum ProcPidStat {
        PPID(4),
        USER_TIME(14),
        KERNEL_TIME(15),
        PRIORITY(18),
        THREAD_COUNT(20),
        START_TIME(22),
        VSZ(23),
        RSS(24);

        private int order;

        private ProcPidStat(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

