/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.profile;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.setting.Setting;

public class Profile
implements Serializable {
    public static final String DEFAULT_PROFILE = "default";
    private static final long serialVersionUID = 1L;
    private String profile;
    private Charset charset;
    private boolean useVar;
    private Map<String, Setting> settingMap = new ConcurrentHashMap<String, Setting>();

    public Profile() {
        this(DEFAULT_PROFILE);
    }

    public Profile(String profile) {
        this(profile, org.aoju.bus.core.lang.Charset.UTF_8, false);
    }

    public Profile(String profile, Charset charset, boolean useVar) {
        this.profile = profile;
        this.charset = charset;
        this.useVar = useVar;
    }

    public Setting getSetting(String name) {
        String nameForProfile = this.fixNameForProfile(name);
        Setting setting = this.settingMap.get(nameForProfile);
        if (null == setting) {
            setting = new Setting(nameForProfile, this.charset, this.useVar);
            this.settingMap.put(nameForProfile, setting);
        }
        return setting;
    }

    public Profile setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public Profile setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Profile setUseVar(boolean useVar) {
        this.useVar = useVar;
        return this;
    }

    public Profile clear() {
        this.settingMap.clear();
        return this;
    }

    private String fixNameForProfile(String name) {
        String actralProfile;
        String string = actralProfile = null == this.profile ? "" : this.profile;
        if (StringUtils.isNotBlank(name) && !name.contains(".")) {
            return StringUtils.format("{}/{}.setting", actralProfile, name);
        }
        return StringUtils.format("{}/{}", actralProfile);
    }
}

