/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.aoju.bus.core.convert.ArrayConverter;
import org.aoju.bus.core.convert.AtomicBooleanConverter;
import org.aoju.bus.core.convert.AtomicReferenceConverter;
import org.aoju.bus.core.convert.BeanConverter;
import org.aoju.bus.core.convert.BooleanConverter;
import org.aoju.bus.core.convert.CalendarConverter;
import org.aoju.bus.core.convert.CharacterConverter;
import org.aoju.bus.core.convert.CharsetConverter;
import org.aoju.bus.core.convert.ClassConverter;
import org.aoju.bus.core.convert.CollectionConverter;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.convert.CurrencyConverter;
import org.aoju.bus.core.convert.DateConverter;
import org.aoju.bus.core.convert.DurationConverter;
import org.aoju.bus.core.convert.EnumConverter;
import org.aoju.bus.core.convert.LocaleConverter;
import org.aoju.bus.core.convert.MapConverter;
import org.aoju.bus.core.convert.NumberConverter;
import org.aoju.bus.core.convert.OptionalConverter;
import org.aoju.bus.core.convert.PathConverter;
import org.aoju.bus.core.convert.PeriodConverter;
import org.aoju.bus.core.convert.PrimitiveConverter;
import org.aoju.bus.core.convert.ReferenceConverter;
import org.aoju.bus.core.convert.StackTraceConverter;
import org.aoju.bus.core.convert.StringConverter;
import org.aoju.bus.core.convert.TemporalConverter;
import org.aoju.bus.core.convert.TimeZoneConverter;
import org.aoju.bus.core.convert.URIConverter;
import org.aoju.bus.core.convert.URLConverter;
import org.aoju.bus.core.convert.UUIDConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.lang.Types;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.TypeUtils;

public class ConverterRegistry {
    private Map<Type, Converter<?>> defaultConverterMap;
    private volatile Map<Type, Converter<?>> customConverterMap;

    public ConverterRegistry() {
        this.defaultConverter();
    }

    public static ConverterRegistry getInstance() {
        return SingletonHolder.instance;
    }

    public ConverterRegistry putCustom(Type type, Class<? extends Converter<?>> converterClass) {
        return this.putCustom(type, ReflectUtils.newInstance(converterClass, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConverterRegistry putCustom(Type type, Converter<?> converter) {
        if (null == this.customConverterMap) {
            ConverterRegistry converterRegistry = this;
            synchronized (converterRegistry) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new ConcurrentHashMap();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    public <T> Converter<T> getConverter(Type type, boolean isCustomFirst) {
        Converter<T> converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public <T> Converter<T> getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(type);
    }

    public <T> Converter<T> getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    public <T> T convert(Type type, Object value, T defaultValue, boolean isCustomFirst) throws InstrumentException {
        Object result;
        Converter<T> converter;
        if (TypeUtils.isUnknow(type) && null == defaultValue) {
            return (T)value;
        }
        if (ObjectUtils.isNull(value)) {
            return defaultValue;
        }
        if (TypeUtils.isUnknow(type)) {
            type = defaultValue.getClass();
        }
        if (type instanceof Types) {
            type = ((Types)type).getType();
        }
        if (null != (converter = this.getConverter(type, isCustomFirst))) {
            return converter.convert(value, defaultValue);
        }
        Class<?> rowType = TypeUtils.getClass(type);
        if (null == rowType) {
            if (null != defaultValue) {
                rowType = defaultValue.getClass();
            } else {
                return (T)value;
            }
        }
        if (null != (result = this.convertSpecial(type, rowType, value, defaultValue))) {
            return (T)result;
        }
        if (BeanUtils.isBean(rowType)) {
            return new BeanConverter<T>(type).convert(value, defaultValue);
        }
        throw new InstrumentException("No Converter for type [{}]", rowType.getName());
    }

    public <T> T convert(Type type, Object value, T defaultValue) throws InstrumentException {
        return this.convert(type, value, defaultValue, true);
    }

    public <T> T convert(Type type, Object value) throws InstrumentException {
        return this.convert(type, value, null);
    }

    private <T> T convertSpecial(Type type, Class<T> rowType, Object value, T defaultValue) {
        if (null == rowType) {
            return null;
        }
        if (Collection.class.isAssignableFrom(rowType)) {
            CollectionConverter collectionConverter = new CollectionConverter(type);
            return (T)collectionConverter.convert(value, (Collection)defaultValue);
        }
        if (Map.class.isAssignableFrom(rowType)) {
            MapConverter mapConverter = new MapConverter(type);
            return (T)mapConverter.convert(value, (Map)defaultValue);
        }
        if (rowType.isInstance(value)) {
            return (T)value;
        }
        if (rowType.isEnum()) {
            return new EnumConverter(rowType).convert(value, defaultValue);
        }
        if (rowType.isArray()) {
            ArrayConverter arrayConverter = new ArrayConverter(rowType);
            try {
                return arrayConverter.convert(value, defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private ConverterRegistry defaultConverter() {
        this.defaultConverterMap = new ConcurrentHashMap();
        this.defaultConverterMap.put(Integer.TYPE, new PrimitiveConverter(Integer.TYPE));
        this.defaultConverterMap.put(Long.TYPE, new PrimitiveConverter(Long.TYPE));
        this.defaultConverterMap.put(Byte.TYPE, new PrimitiveConverter(Byte.TYPE));
        this.defaultConverterMap.put(Short.TYPE, new PrimitiveConverter(Short.TYPE));
        this.defaultConverterMap.put(Float.TYPE, new PrimitiveConverter(Float.TYPE));
        this.defaultConverterMap.put(Double.TYPE, new PrimitiveConverter(Double.TYPE));
        this.defaultConverterMap.put(Character.TYPE, new PrimitiveConverter(Character.TYPE));
        this.defaultConverterMap.put(Boolean.TYPE, new PrimitiveConverter(Boolean.TYPE));
        this.defaultConverterMap.put((Type)((Object)Number.class), new NumberConverter());
        this.defaultConverterMap.put((Type)((Object)Integer.class), new NumberConverter(Integer.class));
        this.defaultConverterMap.put((Type)((Object)AtomicInteger.class), new NumberConverter(AtomicInteger.class));
        this.defaultConverterMap.put((Type)((Object)Long.class), new NumberConverter(Long.class));
        this.defaultConverterMap.put((Type)((Object)AtomicLong.class), new NumberConverter(AtomicLong.class));
        this.defaultConverterMap.put((Type)((Object)Byte.class), new NumberConverter(Byte.class));
        this.defaultConverterMap.put((Type)((Object)Short.class), new NumberConverter(Short.class));
        this.defaultConverterMap.put((Type)((Object)Float.class), new NumberConverter(Float.class));
        this.defaultConverterMap.put((Type)((Object)Double.class), new NumberConverter(Double.class));
        this.defaultConverterMap.put((Type)((Object)Character.class), new CharacterConverter());
        this.defaultConverterMap.put((Type)((Object)Boolean.class), new BooleanConverter());
        this.defaultConverterMap.put((Type)((Object)AtomicBoolean.class), new AtomicBooleanConverter());
        this.defaultConverterMap.put((Type)((Object)BigDecimal.class), new NumberConverter(BigDecimal.class));
        this.defaultConverterMap.put((Type)((Object)BigInteger.class), new NumberConverter(BigInteger.class));
        this.defaultConverterMap.put((Type)((Object)CharSequence.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)String.class), new StringConverter());
        this.defaultConverterMap.put((Type)((Object)URI.class), new URIConverter());
        this.defaultConverterMap.put((Type)((Object)URL.class), new URLConverter());
        this.defaultConverterMap.put((Type)((Object)Calendar.class), new CalendarConverter());
        this.defaultConverterMap.put((Type)((Object)java.util.Date.class), new DateConverter(java.util.Date.class));
        this.defaultConverterMap.put((Type)((Object)DateTime.class), new DateConverter(DateTime.class));
        this.defaultConverterMap.put((Type)((Object)Date.class), new DateConverter(Date.class));
        this.defaultConverterMap.put((Type)((Object)Time.class), new DateConverter(Time.class));
        this.defaultConverterMap.put((Type)((Object)Timestamp.class), new DateConverter(Timestamp.class));
        this.defaultConverterMap.put((Type)((Object)TemporalAccessor.class), new TemporalConverter(Instant.class));
        this.defaultConverterMap.put((Type)((Object)Instant.class), new TemporalConverter(Instant.class));
        this.defaultConverterMap.put((Type)((Object)LocalDateTime.class), new TemporalConverter(LocalDateTime.class));
        this.defaultConverterMap.put((Type)((Object)LocalDate.class), new TemporalConverter(LocalDate.class));
        this.defaultConverterMap.put((Type)((Object)LocalTime.class), new TemporalConverter(LocalTime.class));
        this.defaultConverterMap.put((Type)((Object)ZonedDateTime.class), new TemporalConverter(ZonedDateTime.class));
        this.defaultConverterMap.put((Type)((Object)OffsetDateTime.class), new TemporalConverter(OffsetDateTime.class));
        this.defaultConverterMap.put((Type)((Object)OffsetTime.class), new TemporalConverter(OffsetTime.class));
        this.defaultConverterMap.put((Type)((Object)Period.class), new PeriodConverter());
        this.defaultConverterMap.put((Type)((Object)Duration.class), new DurationConverter());
        this.defaultConverterMap.put((Type)((Object)WeakReference.class), new ReferenceConverter(WeakReference.class));
        this.defaultConverterMap.put((Type)((Object)SoftReference.class), new ReferenceConverter(SoftReference.class));
        this.defaultConverterMap.put((Type)((Object)AtomicReference.class), new AtomicReferenceConverter());
        this.defaultConverterMap.put((Type)((Object)Class.class), new ClassConverter());
        this.defaultConverterMap.put((Type)((Object)TimeZone.class), new TimeZoneConverter());
        this.defaultConverterMap.put((Type)((Object)Locale.class), new LocaleConverter());
        this.defaultConverterMap.put((Type)((Object)Charset.class), new CharsetConverter());
        this.defaultConverterMap.put((Type)((Object)Path.class), new PathConverter());
        this.defaultConverterMap.put((Type)((Object)Currency.class), new CurrencyConverter());
        this.defaultConverterMap.put((Type)((Object)UUID.class), new UUIDConverter());
        this.defaultConverterMap.put((Type)((Object)StackTraceElement.class), new StackTraceConverter());
        this.defaultConverterMap.put((Type)((Object)Optional.class), new OptionalConverter());
        return this;
    }

    private static class SingletonHolder {
        private static ConverterRegistry instance = new ConverterRegistry();

        private SingletonHolder() {
        }
    }
}

