/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.asymmetric.KeyType;
import org.aoju.bus.crypto.asymmetric.SM2Engine;
import org.aoju.bus.crypto.asymmetric.Safety;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;

public class SM2
extends Safety<SM2> {
    protected SM2Engine engine;
    protected SM2Signer signer;
    private SM2Engine.SM2Mode mode = SM2Engine.SM2Mode.C1C3C2;
    private ECPublicKeyParameters publicKeyParams;
    private ECPrivateKeyParameters privateKeyParams;

    public SM2() {
        this((byte[])null, null);
    }

    public SM2(String privateKeyStr, String publicKeyStr) {
        this(Builder.decode(privateKeyStr), Builder.decode(publicKeyStr));
    }

    public SM2(byte[] privateKey, byte[] publicKey) {
        this(Builder.generatePrivateKey("SM2", privateKey), Builder.generatePublicKey("SM2", publicKey));
    }

    public SM2(PrivateKey privateKey, PublicKey publicKey) {
        this(Builder.toParams(privateKey), Builder.toParams(publicKey));
        if (null != privateKey) {
            this.privateKey = privateKey;
        }
        if (null != publicKey) {
            this.publicKey = publicKey;
        }
    }

    public SM2(String privateKeyHex, String publicKeyPointXHex, String publicKeyPointYHex) {
        this(Builder.toSm2Params(privateKeyHex), Builder.toSm2Params(publicKeyPointXHex, publicKeyPointYHex));
    }

    public SM2(byte[] privateKey, byte[] publicKeyPointX, byte[] publicKeyPointY) {
        this(Builder.toSm2Params(privateKey), Builder.toSm2Params(publicKeyPointX, publicKeyPointY));
    }

    public SM2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        super("SM2", null, null);
        this.privateKeyParams = privateKeyParams;
        this.publicKeyParams = publicKeyParams;
        this.init();
    }

    public SM2 init() {
        if (null == this.privateKeyParams && null == this.publicKeyParams) {
            super.initKeys();
            this.privateKeyParams = Builder.toParams(this.privateKey);
            this.publicKeyParams = Builder.toParams(this.publicKey);
        }
        return this;
    }

    @Override
    public SM2 initKeys() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) throws InstrumentException {
        if (KeyType.PublicKey != keyType) {
            throw new IllegalArgumentException("Encrypt is only support by public key");
        }
        this.checkKey(keyType);
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(true, (CipherParameters)new ParametersWithRandom(this.getCipherParameters(keyType)));
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) throws InstrumentException {
        if (KeyType.PrivateKey != keyType) {
            throw new IllegalArgumentException("Decrypt is only support by private key");
        }
        this.checkKey(keyType);
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(false, this.getCipherParameters(keyType));
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] sign(byte[] data) {
        return this.sign(data, null);
    }

    public byte[] sign(byte[] data, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            ParametersWithRandom param = new ParametersWithRandom(this.getCipherParameters(KeyType.PrivateKey));
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(true, (CipherParameters)param);
            signer.update(data, 0, data.length);
            byte[] byArray = signer.generateSignature();
            return byArray;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verify(byte[] data, byte[] sign) {
        return this.verify(data, sign, null);
    }

    public boolean verify(byte[] data, byte[] sign, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            CipherParameters param = this.getCipherParameters(KeyType.PublicKey);
            if (id != null) {
                param = new ParametersWithID(param, id);
            }
            signer.init(false, param);
            signer.update(data, 0, data.length);
            boolean bl = signer.verifySignature(sign);
            return bl;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SM2 setPrivateKey(PrivateKey privateKey) {
        super.setPrivateKey(privateKey);
        this.privateKeyParams = null;
        this.initCipherParams();
        return this;
    }

    @Override
    public SM2 setPublicKey(PublicKey publicKey) {
        super.setPublicKey(publicKey);
        this.publicKeyParams = null;
        this.initCipherParams();
        return this;
    }

    public SM2 setMode(SM2Engine.SM2Mode mode) {
        this.mode = mode;
        if (null != this.engine) {
            this.engine.setMode(mode);
        }
        return this;
    }

    private SM2 initCipherParams() {
        try {
            if (null != this.publicKey) {
                this.publicKeyParams = (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)this.publicKey);
            }
            if (null != this.privateKey) {
                this.privateKeyParams = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)this.privateKey);
            }
        }
        catch (InvalidKeyException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    private CipherParameters getCipherParameters(KeyType keyType) {
        switch (keyType) {
            case PublicKey: {
                return this.publicKeyParams;
            }
            case PrivateKey: {
                return this.privateKeyParams;
            }
        }
        return null;
    }

    private void checkKey(KeyType keyType) {
        switch (keyType) {
            case PublicKey: {
                if (null != this.publicKey) break;
                throw new NullPointerException("No public key provided");
            }
            case PrivateKey: {
                if (null != this.privateKey) break;
                throw new NullPointerException("No private key provided");
            }
        }
    }

    private SM2Engine getEngine() {
        if (null == this.engine) {
            this.engine = new SM2Engine(this.mode);
        }
        return this.engine;
    }

    private SM2Signer getSigner() {
        if (null == this.signer) {
            this.signer = new SM2Signer();
        }
        return this.signer;
    }
}

