/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.hardware.mac;

import com.sun.jna.platform.mac.IOKit;
import org.aoju.bus.health.common.mac.SmcUtils;
import org.aoju.bus.health.hardware.AbstractSensors;

public class MacSensors
extends AbstractSensors {
    private int numFans = 0;

    @Override
    public double queryCpuTemperature() {
        IOKit.IOConnect conn = SmcUtils.smcOpen();
        double temp = SmcUtils.smcGetFloat(conn, "TC0P");
        SmcUtils.smcClose(conn);
        if (temp > 0.0) {
            return temp;
        }
        return 0.0;
    }

    @Override
    public int[] queryFanSpeeds() {
        IOKit.IOConnect conn = SmcUtils.smcOpen();
        if (this.numFans == 0) {
            this.numFans = (int)SmcUtils.smcGetLong(conn, "FNum");
        }
        int[] fanSpeeds = new int[this.numFans];
        for (int i = 0; i < this.numFans; ++i) {
            fanSpeeds[i] = (int)SmcUtils.smcGetFloat(conn, String.format("F%dAc", i));
        }
        SmcUtils.smcClose(conn);
        return fanSpeeds;
    }

    @Override
    public double queryCpuVoltage() {
        IOKit.IOConnect conn = SmcUtils.smcOpen();
        double volts = SmcUtils.smcGetFloat(conn, "VC0C") / 1000.0;
        SmcUtils.smcClose(conn);
        return volts;
    }
}

