/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software.mac;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.DiskArbitration;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.mac.SystemB;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.aoju.bus.health.common.mac.SysctlUtils;
import org.aoju.bus.health.software.FileSystem;
import org.aoju.bus.health.software.OSFileStore;
import org.aoju.bus.logger.Logger;

public class MacFileSystem
implements FileSystem {
    private static final Pattern LOCAL_DISK = Pattern.compile("/dev/disk\\d");

    public static boolean updateFileStoreStats(OSFileStore osFileStore) {
        for (OSFileStore fileStore : new MacFileSystem().getFileStoreMatching(osFileStore.getName())) {
            if (!osFileStore.getVolume().equals(fileStore.getVolume()) || !osFileStore.getMount().equals(fileStore.getMount())) continue;
            osFileStore.setLogicalVolume(fileStore.getLogicalVolume());
            osFileStore.setDescription(fileStore.getDescription());
            osFileStore.setType(fileStore.getType());
            osFileStore.setFreeSpace(fileStore.getFreeSpace());
            osFileStore.setUsableSpace(fileStore.getUsableSpace());
            osFileStore.setTotalSpace(fileStore.getTotalSpace());
            osFileStore.setFreeInodes(fileStore.getFreeInodes());
            osFileStore.setTotalInodes(fileStore.getTotalInodes());
            return true;
        }
        return false;
    }

    @Override
    public OSFileStore[] getFileStores() {
        List<OSFileStore> fsList = this.getFileStoreMatching(null);
        return fsList.toArray(new OSFileStore[0]);
    }

    private List<OSFileStore> getFileStoreMatching(String nameToMatch) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        int numfs = SystemB.INSTANCE.getfsstat64(null, 0, 0);
        if (numfs > 0) {
            DiskArbitration.DASessionRef session = DiskArbitration.INSTANCE.DASessionCreate(CoreFoundation.INSTANCE.CFAllocatorGetDefault());
            if (session == null) {
                Logger.error("Unable to open session to DiskArbitration framework.", new Object[0]);
            } else {
                CoreFoundation.CFStringRef daVolumeNameKey = CoreFoundation.CFStringRef.createCFString((String)"DAVolumeName");
                SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
                numfs = SystemB.INSTANCE.getfsstat64(fs, numfs * new SystemB.Statfs().size(), 16);
                for (int f = 0; f < numfs; ++f) {
                    String volume = new String(fs[f].f_mntfromname, StandardCharsets.UTF_8).trim();
                    if (volume.equals("devfs") || volume.startsWith("map ")) continue;
                    String description = "Volume";
                    if (LOCAL_DISK.matcher(volume).matches()) {
                        description = "Local Disk";
                    }
                    if (volume.startsWith("localhost:") || volume.startsWith("//")) {
                        description = "Network Drive";
                    }
                    String type = new String(fs[f].f_fstypename, StandardCharsets.UTF_8).trim();
                    String path = new String(fs[f].f_mntonname, StandardCharsets.UTF_8).trim();
                    String name = "";
                    File file = new File(path);
                    if (name.isEmpty() && (name = file.getName()).isEmpty()) {
                        name = file.getPath();
                    }
                    if (nameToMatch != null && !nameToMatch.equals(name)) continue;
                    String uuid = "";
                    String bsdName = volume.replace("/dev/disk", "disk");
                    if (bsdName.startsWith("disk")) {
                        IOKit.IOIterator fsIter;
                        CoreFoundation.CFMutableDictionaryRef matchingDict;
                        DiskArbitration.DADiskRef disk = DiskArbitration.INSTANCE.DADiskCreateFromBSDName(CoreFoundation.INSTANCE.CFAllocatorGetDefault(), session, volume);
                        if (disk != null) {
                            CoreFoundation.CFDictionaryRef diskInfo = DiskArbitration.INSTANCE.DADiskCopyDescription(disk);
                            if (diskInfo != null) {
                                Pointer result = diskInfo.getValue((PointerType)daVolumeNameKey);
                                CoreFoundation.CFStringRef volumePtr = new CoreFoundation.CFStringRef(result);
                                name = volumePtr.stringValue();
                                if (name == null) {
                                    name = "unknown";
                                }
                                diskInfo.release();
                            }
                            disk.release();
                        }
                        if ((matchingDict = IOKitUtil.getBSDNameMatchingDict((String)bsdName)) != null && (fsIter = IOKitUtil.getMatchingServices((CoreFoundation.CFDictionaryRef)matchingDict)) != null) {
                            IOKit.IORegistryEntry fsEntry = fsIter.next();
                            if (fsEntry != null && fsEntry.conformsTo("IOMedia")) {
                                uuid = fsEntry.getStringProperty("UUID");
                                if (uuid != null) {
                                    uuid = uuid.toLowerCase();
                                }
                                fsEntry.release();
                            }
                            fsIter.release();
                        }
                    }
                    OSFileStore osStore = new OSFileStore();
                    osStore.setName(name);
                    osStore.setVolume(volume);
                    osStore.setMount(path);
                    osStore.setDescription(description);
                    osStore.setType(type);
                    osStore.setUUID(uuid == null ? "" : uuid);
                    osStore.setFreeSpace(file.getFreeSpace());
                    osStore.setUsableSpace(file.getUsableSpace());
                    osStore.setTotalSpace(file.getTotalSpace());
                    osStore.setFreeInodes(fs[f].f_ffree);
                    osStore.setTotalInodes(fs[f].f_files);
                    fsList.add(osStore);
                }
                daVolumeNameKey.release();
                session.release();
            }
        }
        return fsList;
    }

    @Override
    public long getOpenFileDescriptors() {
        return SysctlUtils.sysctl("kern.num_files", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return SysctlUtils.sysctl("kern.maxfiles", 0);
    }
}

