/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.software.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.W32ServiceManager;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinPerf;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.platform.win32.Wtsapi32;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Config;
import org.aoju.bus.health.Memoizer;
import org.aoju.bus.health.common.windows.Kernel32;
import org.aoju.bus.health.common.windows.PerfWildcardQuery;
import org.aoju.bus.health.common.windows.WmiQueryHandler;
import org.aoju.bus.health.common.windows.WmiUtils;
import org.aoju.bus.health.software.AbstractOS;
import org.aoju.bus.health.software.FileSystem;
import org.aoju.bus.health.software.NetworkParams;
import org.aoju.bus.health.software.OSProcess;
import org.aoju.bus.health.software.OSService;
import org.aoju.bus.health.software.OperatingSystem;
import org.aoju.bus.health.software.windows.WindowsFileSystem;
import org.aoju.bus.health.software.windows.WindowsNetwork;
import org.aoju.bus.logger.Logger;

public class WindowsOS
extends AbstractOS {
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final boolean IS_WINDOWS7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();
    private static final HkeyPerformanceData HKEY_PERFORMANCE_DATA;
    private static final String PROCESS_BASE_CLASS = "Win32_Process";
    private static Supplier<String> systemLog;
    private static final long BOOTTIME;
    private final PerfWildcardQuery<ProcessPerformanceProperty> processPerformancePerfCounters = new PerfWildcardQuery<ProcessPerformanceProperty>(ProcessPerformanceProperty.class, "Process", "Win32_Process WHERE NOT Name LIKE\"%_Total\"", "Process Information");

    private static String parseVersion(WbemcliUtil.WmiResult<OSVersionProperty> versionInfo, int suiteMask, String buildNumber) {
        String version = System.getProperty("os.version");
        String[] verSplit = WmiUtils.getString(versionInfo, OSVersionProperty.Version, 0).split("\\D");
        int major = verSplit.length > 0 ? Builder.parseIntOrDefault(verSplit[0], 0) : 0;
        int minor = verSplit.length > 1 ? Builder.parseIntOrDefault(verSplit[1], 0) : 0;
        boolean ntWorkstation = WmiUtils.getUint32(versionInfo, OSVersionProperty.ProductType, 0) == 1;
        switch (major) {
            case 10: {
                if (minor != 0) break;
                if (ntWorkstation) {
                    version = "10";
                    break;
                }
                version = Builder.parseLongOrDefault(buildNumber, 0L) > 17762L ? "Server 2019" : "Server 2016";
                break;
            }
            case 6: {
                if (minor == 3) {
                    version = ntWorkstation ? "8.1" : "Server 2012 R2";
                    break;
                }
                if (minor == 2) {
                    version = ntWorkstation ? "8" : "Server 2012";
                    break;
                }
                if (minor == 1) {
                    version = ntWorkstation ? "7" : "Server 2008 R2";
                    break;
                }
                if (minor != 0) break;
                version = ntWorkstation ? "Vista" : "Server 2008";
                break;
            }
            case 5: {
                if (minor == 2) {
                    if ((suiteMask & 0x8000) != 0) {
                        version = "Home Server";
                        break;
                    }
                    if (ntWorkstation) {
                        version = "XP";
                        break;
                    }
                    version = User32.INSTANCE.GetSystemMetrics(89) != 0 ? "Server 2003" : "Server 2003 R2";
                    break;
                }
                if (minor == 1) {
                    version = "XP";
                    break;
                }
                if (minor != 0) break;
                version = "2000";
                break;
            }
        }
        String sp = WmiUtils.getString(versionInfo, OSVersionProperty.CSDVersion, 0);
        if (!sp.isEmpty() && !"unknown".equals(sp)) {
            version = version + " " + sp.replace("Service Pack ", "SP");
        }
        return version;
    }

    private static String parseCodeName(int suiteMask) {
        ArrayList<String> suites = new ArrayList<String>();
        if ((suiteMask & 2) != 0) {
            suites.add("Enterprise");
        }
        if ((suiteMask & 4) != 0) {
            suites.add("BackOffice");
        }
        if ((suiteMask & 8) != 0) {
            suites.add("Communication Server");
        }
        if ((suiteMask & 0x80) != 0) {
            suites.add("Datacenter");
        }
        if ((suiteMask & 0x200) != 0) {
            suites.add("Home");
        }
        if ((suiteMask & 0x400) != 0) {
            suites.add("Web Server");
        }
        if ((suiteMask & 0x2000) != 0) {
            suites.add("Storage Server");
        }
        if ((suiteMask & 0x4000) != 0) {
            suites.add("Compute Cluster");
        }
        return String.join((CharSequence)",", suites);
    }

    private static long querySystemUptime() {
        if (IS_VISTA_OR_GREATER) {
            return Kernel32.INSTANCE.GetTickCount64() / 1000L;
        }
        return (long)Kernel32.INSTANCE.GetTickCount() / 1000L;
    }

    private static long querySystemBootTime() {
        String eventLog = systemLog.get();
        if (eventLog != null) {
            try {
                Advapi32Util.EventLogIterator iter = new Advapi32Util.EventLogIterator(null, eventLog, 8);
                long event6005Time = 0L;
                while (iter.hasNext()) {
                    Advapi32Util.EventLogRecord record = iter.next();
                    if (record.getStatusCode() == 12) {
                        return record.getRecord().TimeGenerated.longValue();
                    }
                    if (record.getStatusCode() != 6005) continue;
                    if (event6005Time > 0L) {
                        return event6005Time;
                    }
                    event6005Time = record.getRecord().TimeGenerated.longValue();
                }
                if (event6005Time > 0L) {
                    return event6005Time;
                }
            }
            catch (Win32Exception e) {
                Logger.warn("Can't open event log {}", eventLog);
            }
        }
        return System.currentTimeMillis() / 1000L - WindowsOS.querySystemUptime();
    }

    private static void enableDebugPrivilege() {
        WinNT.HANDLEByReference hToken = new WinNT.HANDLEByReference();
        boolean success = Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 40, hToken);
        if (!success) {
            Logger.error("OpenProcessToken failed. Error: {}", Native.getLastError());
            return;
        }
        WinNT.LUID luid = new WinNT.LUID();
        success = Advapi32.INSTANCE.LookupPrivilegeValue(null, "SeDebugPrivilege", luid);
        if (!success) {
            Logger.error("LookupprivilegeValue failed. Error: {}", Native.getLastError());
            Kernel32.INSTANCE.CloseHandle(hToken.getValue());
            return;
        }
        WinNT.TOKEN_PRIVILEGES tkp = new WinNT.TOKEN_PRIVILEGES(1);
        tkp.Privileges[0] = new WinNT.LUID_AND_ATTRIBUTES(luid, new WinDef.DWORD(2L));
        success = Advapi32.INSTANCE.AdjustTokenPrivileges(hToken.getValue(), false, tkp, 0, null, null);
        if (!success) {
            Logger.error("AdjustTokenPrivileges failed. Error: {}", Native.getLastError());
        }
        Kernel32.INSTANCE.CloseHandle(hToken.getValue());
    }

    private static String querySystemLog() {
        String systemLog = Config.get("oshi.os.windows.eventlog", "System");
        if (systemLog.isEmpty()) {
            return null;
        }
        WinNT.HANDLE h = Advapi32.INSTANCE.OpenEventLog(null, systemLog);
        if (h == null) {
            Logger.warn("Unable to open configured system Event log \"{}\". Calculating boot time from uptime.", systemLog);
            return null;
        }
        return systemLog;
    }

    @Override
    public String queryManufacturer() {
        return "Microsoft";
    }

    @Override
    public AbstractOS.FamilyVersionInfo queryFamilyVersionInfo() {
        WbemcliUtil.WmiQuery osVersionQuery = new WbemcliUtil.WmiQuery("Win32_OperatingSystem", OSVersionProperty.class);
        WbemcliUtil.WmiResult versionInfo = WmiQueryHandler.createInstance().queryWMI(osVersionQuery);
        if (versionInfo.getResultCount() < 1) {
            return new AbstractOS.FamilyVersionInfo("Windows", new OperatingSystem.OSVersionInfo(System.getProperty("os.version"), null, null));
        }
        int suiteMask = WmiUtils.getUint32(versionInfo, OSVersionProperty.SuiteMask, 0);
        String buildNumber = WmiUtils.getString(versionInfo, OSVersionProperty.BuildNumber, 0);
        String version = WindowsOS.parseVersion(versionInfo, suiteMask, buildNumber);
        String codeName = WindowsOS.parseCodeName(suiteMask);
        return new AbstractOS.FamilyVersionInfo("Windows", new OperatingSystem.OSVersionInfo(version, codeName, buildNumber));
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        WbemcliUtil.WmiQuery bitnessQuery;
        WbemcliUtil.WmiResult bitnessMap;
        WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();
        if (jvmBitness < 64 && System.getenv("ProgramFiles(x86)") != null && IS_VISTA_OR_GREATER && (bitnessMap = wmiQueryHandler.queryWMI(bitnessQuery = new WbemcliUtil.WmiQuery("Win32_Processor", BitnessProperty.class))).getResultCount() > 0) {
            return WmiUtils.getUint16(bitnessMap, BitnessProperty.AddressWidth, 0);
        }
        return jvmBitness;
    }

    @Override
    public boolean queryElevated() {
        try {
            File dir = new File(System.getenv("windir") + "\\system32\\config\\systemprofile");
            return dir.isDirectory();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @Override
    public FileSystem getFileSystem() {
        return new WindowsFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort, boolean slowFields) {
        List<OSProcess> procList = this.processMapToList(null, slowFields);
        List<OSProcess> sorted = this.processSort(procList, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        return this.processMapToList(pids, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSProcess[] getChildProcesses(int parentPid, int limit, OperatingSystem.ProcessSort sort) {
        HashSet<Integer> childPids = new HashSet<Integer>();
        Tlhelp32.PROCESSENTRY32.ByReference processEntry = new Tlhelp32.PROCESSENTRY32.ByReference();
        WinNT.HANDLE snapshot = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            while (Kernel32.INSTANCE.Process32Next(snapshot, (Tlhelp32.PROCESSENTRY32)processEntry)) {
                if (processEntry.th32ParentProcessID.intValue() != parentPid) continue;
                childPids.add(processEntry.th32ProcessID.intValue());
            }
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(snapshot);
        }
        List<OSProcess> procList = this.getProcesses(childPids);
        List<OSProcess> sorted = this.processSort(procList, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    @Override
    public OSProcess getProcess(int pid, boolean slowFields) {
        List<OSProcess> procList = this.processMapToList(Arrays.asList(pid), slowFields);
        return procList.isEmpty() ? null : procList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<OSProcess> processMapToList(Collection<Integer> pids, boolean slowFields) {
        WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();
        Map processMap = HKEY_PERFORMANCE_DATA != null ? WindowsOS.HKEY_PERFORMANCE_DATA.buildProcessMapFromRegistry(this, pids) : this.buildProcessMapFromPerfCounters(pids);
        ArrayList<String> groupList = new ArrayList<String>();
        ArrayList<String> groupIDList = new ArrayList<String>();
        int myPid = this.getProcessId();
        Pointer pProcessInfo = null;
        Wtsapi32.WTS_PROCESS_INFO_EX[] processInfo = null;
        IntByReference pCount = new IntByReference(0);
        WbemcliUtil.WmiResult processWmiResult = null;
        if (IS_WINDOWS7_OR_GREATER) {
            PointerByReference ppProcessInfo = new PointerByReference();
            if (!Wtsapi32.INSTANCE.WTSEnumerateProcessesEx(Wtsapi32.WTS_CURRENT_SERVER_HANDLE, new IntByReference(1), -2, ppProcessInfo, pCount)) {
                Logger.error("Failed to enumerate Processes. Error code: {}", Kernel32.INSTANCE.GetLastError());
                return new ArrayList<OSProcess>(0);
            }
            pProcessInfo = ppProcessInfo.getValue();
            Wtsapi32.WTS_PROCESS_INFO_EX processInfoRef = new Wtsapi32.WTS_PROCESS_INFO_EX(pProcessInfo);
            processInfo = (Wtsapi32.WTS_PROCESS_INFO_EX[])processInfoRef.toArray(pCount.getValue());
        } else {
            StringBuilder sb = new StringBuilder(PROCESS_BASE_CLASS);
            if (pids != null) {
                boolean first = true;
                for (Integer pid : pids) {
                    if (first) {
                        sb.append(" WHERE ProcessID=");
                        first = false;
                    } else {
                        sb.append(" OR ProcessID=");
                    }
                    sb.append(pid);
                }
            }
            WbemcliUtil.WmiQuery processQueryXP = new WbemcliUtil.WmiQuery(sb.toString(), ProcessXPProperty.class);
            processWmiResult = wmiQueryHandler.queryWMI(processQueryXP);
        }
        ArrayList<OSProcess> processList = new ArrayList<OSProcess>();
        int procCount = IS_WINDOWS7_OR_GREATER ? processInfo.length : processWmiResult.getResultCount();
        for (int i = 0; i < procCount; ++i) {
            int pid = IS_WINDOWS7_OR_GREATER ? processInfo[i].ProcessId : WmiUtils.getUint32(processWmiResult, ProcessXPProperty.ProcessId, i);
            Object proc = null;
            if (processMap.isEmpty()) {
                if (pids != null && !pids.contains(pid)) continue;
                proc = new OSProcess(this);
                ((OSProcess)proc).setProcessID(pid);
                ((OSProcess)proc).setName(IS_WINDOWS7_OR_GREATER ? processInfo[i].pProcessName : WmiUtils.getString(processWmiResult, ProcessXPProperty.Name, i));
            } else {
                proc = (OSProcess)processMap.get(pid);
                if (proc == null || pids != null && !pids.contains(pid)) continue;
            }
            if (pid == myPid) {
                String string = new File(".").getAbsolutePath();
                ((OSProcess)proc).setCurrentWorkingDirectory(string.isEmpty() ? "" : string.substring(0, string.length() - 1));
            }
            if (IS_WINDOWS7_OR_GREATER) {
                Wtsapi32.WTS_PROCESS_INFO_EX wTS_PROCESS_INFO_EX = processInfo[i];
                ((OSProcess)proc).setKernelTime(wTS_PROCESS_INFO_EX.KernelTime.getValue() / 10000L);
                ((OSProcess)proc).setUserTime(wTS_PROCESS_INFO_EX.UserTime.getValue() / 10000L);
                ((OSProcess)proc).setThreadCount(wTS_PROCESS_INFO_EX.NumberOfThreads);
                ((OSProcess)proc).setVirtualSize((long)wTS_PROCESS_INFO_EX.PagefileUsage & 0xFFFFFFFFL);
                ((OSProcess)proc).setOpenFiles(wTS_PROCESS_INFO_EX.HandleCount);
            } else {
                ((OSProcess)proc).setKernelTime(WmiUtils.getUint64(processWmiResult, ProcessXPProperty.KernelModeTime, i) / 10000L);
                ((OSProcess)proc).setUserTime(WmiUtils.getUint64(processWmiResult, ProcessXPProperty.UserModeTime, i) / 10000L);
                ((OSProcess)proc).setThreadCount(WmiUtils.getUint32(processWmiResult, ProcessXPProperty.ThreadCount, i));
                ((OSProcess)proc).setVirtualSize(1024L * ((long)WmiUtils.getUint32(processWmiResult, ProcessXPProperty.PageFileUsage, i) & 0xFFFFFFFFL));
                ((OSProcess)proc).setOpenFiles(WmiUtils.getUint32(processWmiResult, ProcessXPProperty.HandleCount, i));
            }
            WinNT.HANDLE hANDLE = Kernel32.INSTANCE.OpenProcess(1024, false, ((OSProcess)proc).getProcessID());
            if (hANDLE != null) {
                IntByReference wow64;
                ((OSProcess)proc).setBitness(this.getBitness());
                if (IS_VISTA_OR_GREATER && this.getBitness() == 64 && Kernel32.INSTANCE.IsWow64Process(hANDLE, wow64 = new IntByReference(0))) {
                    ((OSProcess)proc).setBitness(wow64.getValue() > 0 ? 32 : 64);
                }
                WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
                try {
                    ((OSProcess)proc).setPath(IS_WINDOWS7_OR_GREATER ? Kernel32Util.QueryFullProcessImageName((WinNT.HANDLE)hANDLE, (int)0) : WmiUtils.getString(processWmiResult, ProcessXPProperty.ExecutablePath, i));
                    if (Advapi32.INSTANCE.OpenProcessToken(hANDLE, 10, phToken)) {
                        Advapi32Util.Account account = Advapi32Util.getTokenAccount((WinNT.HANDLE)phToken.getValue());
                        ((OSProcess)proc).setUser(account.name);
                        ((OSProcess)proc).setUserID(account.sidString);
                        if (slowFields) {
                            Advapi32Util.Account[] accounts = Advapi32Util.getTokenGroups((WinNT.HANDLE)phToken.getValue());
                            groupList.clear();
                            groupIDList.clear();
                            for (Advapi32Util.Account a : accounts) {
                                groupList.add(a.name);
                                groupIDList.add(a.sidString);
                            }
                            ((OSProcess)proc).setGroup(String.join((CharSequence)",", groupList));
                            ((OSProcess)proc).setGroupID(String.join((CharSequence)",", groupIDList));
                        }
                    } else {
                        int error = Kernel32.INSTANCE.GetLastError();
                        if (error != 5) {
                            Logger.error("Failed to get process token for process {}: {}", ((OSProcess)proc).getProcessID(), Kernel32.INSTANCE.GetLastError());
                        }
                    }
                }
                catch (Win32Exception e) {
                    this.handleWin32ExceptionOnGetProcessInfo((OSProcess)proc, e);
                }
                finally {
                    WinNT.HANDLE token = phToken.getValue();
                    if (token != null) {
                        Kernel32.INSTANCE.CloseHandle(token);
                    }
                }
                Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
            ((OSProcess)proc).setState(OSProcess.State.RUNNING);
            ((OSProcess)proc).setCommandLine("");
            processList.add((OSProcess)proc);
        }
        if (pProcessInfo != null && !Wtsapi32.INSTANCE.WTSFreeMemoryEx(1, pProcessInfo, pCount.getValue())) {
            Logger.error("Failed to Free Memory for Processes. Error code: {}", Kernel32.INSTANCE.GetLastError());
            return new ArrayList<OSProcess>(0);
        }
        if (slowFields) {
            void var17_37;
            StringBuilder sb = new StringBuilder(PROCESS_BASE_CLASS);
            if (pids != null) {
                HashSet<Integer> pidsToQuery = new HashSet<Integer>();
                for (OSProcess oSProcess : processList) {
                    pidsToQuery.add(oSProcess.getProcessID());
                }
                boolean first = true;
                for (Integer pid : pidsToQuery) {
                    if (first) {
                        sb.append(" WHERE ProcessID=");
                        first = false;
                    } else {
                        sb.append(" OR ProcessID=");
                    }
                    sb.append(pid);
                }
            }
            WbemcliUtil.WmiQuery processQuery = new WbemcliUtil.WmiQuery(sb.toString(), ProcessProperty.class);
            WbemcliUtil.WmiResult commandLineProcs = wmiQueryHandler.queryWMI(processQuery);
            boolean bl = false;
            while (var17_37 < commandLineProcs.getResultCount()) {
                int pid = WmiUtils.getUint32(commandLineProcs, ProcessProperty.ProcessId, (int)var17_37);
                if (processMap.containsKey(pid)) {
                    OSProcess proc = (OSProcess)processMap.get(pid);
                    proc.setCommandLine(WmiUtils.getString(commandLineProcs, ProcessProperty.CommandLine, (int)var17_37));
                }
                ++var17_37;
            }
        }
        return processList;
    }

    protected void handleWin32ExceptionOnGetProcessInfo(OSProcess proc, Win32Exception ex) {
        Logger.warn("Failed to set path or get user/group on PID {}. It may have terminated. {}", proc.getProcessID(), ex.getMessage());
    }

    private Map<Integer, OSProcess> buildProcessMapFromPerfCounters(Collection<Integer> pids) {
        HashMap<Integer, OSProcess> processMap = new HashMap<Integer, OSProcess>();
        Map<ProcessPerformanceProperty, List<Long>> valueMap = this.processPerformancePerfCounters.queryValuesWildcard();
        long now = System.currentTimeMillis();
        List<String> instances = this.processPerformancePerfCounters.getInstancesFromLastQuery();
        List<Long> pidList = valueMap.get(ProcessPerformanceProperty.ProcessId);
        List<Long> ppidList = valueMap.get(ProcessPerformanceProperty.ParentProcessId);
        List<Long> priorityList = valueMap.get(ProcessPerformanceProperty.Priority);
        List<Long> ioReadList = valueMap.get(ProcessPerformanceProperty.ReadTransferCount);
        List<Long> ioWriteList = valueMap.get(ProcessPerformanceProperty.WriteTransferCount);
        List<Long> workingSetSizeList = valueMap.get(ProcessPerformanceProperty.PrivatePageCount);
        List<Long> creationTimeList = valueMap.get(ProcessPerformanceProperty.CreationDate);
        for (int inst = 0; inst < instances.size(); ++inst) {
            int pid = pidList.get(inst).intValue();
            if (pids != null && !pids.contains(pid)) continue;
            OSProcess proc = new OSProcess(this);
            processMap.put(pid, proc);
            proc.setProcessID(pid);
            proc.setName(instances.get(inst));
            proc.setParentProcessID(ppidList.get(inst).intValue());
            proc.setPriority(priorityList.get(inst).intValue());
            long ctime = creationTimeList.get(inst);
            if (ctime > now) {
                ctime = WinBase.FILETIME.filetimeToDate((int)((int)(ctime >> 32)), (int)((int)(ctime & 0xFFFFFFFFL))).getTime();
            }
            proc.setUpTime(now - ctime);
            proc.setStartTime(ctime);
            proc.setBytesRead(ioReadList.get(inst));
            proc.setBytesWritten(ioWriteList.get(inst));
            proc.setResidentSetSize(workingSetSizeList.get(inst));
        }
        return processMap;
    }

    @Override
    public long getProcessAffinityMask(int processId) {
        BaseTSD.ULONG_PTRByReference systemAffinity;
        BaseTSD.ULONG_PTRByReference processAffinity;
        WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, processId);
        if (pHandle != null && Kernel32.INSTANCE.GetProcessAffinityMask(pHandle, processAffinity = new BaseTSD.ULONG_PTRByReference(), systemAffinity = new BaseTSD.ULONG_PTRByReference())) {
            return Pointer.nativeValue((Pointer)processAffinity.getValue().toPointer());
        }
        return 0L;
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getProcessCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            Logger.error("Failed to get Performance Info. Error code: {}", Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ProcessCount.intValue();
    }

    @Override
    public int getThreadCount() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            Logger.error("Failed to get Performance Info. Error code: {}", Kernel32.INSTANCE.GetLastError());
            return 0;
        }
        return perfInfo.ThreadCount.intValue();
    }

    @Override
    public long getSystemUptime() {
        return WindowsOS.querySystemUptime();
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new WindowsNetwork();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OSService[] getServices() {
        try (W32ServiceManager sm = new W32ServiceManager();){
            sm.open(4);
            Winsvc.ENUM_SERVICE_STATUS_PROCESS[] services = sm.enumServicesStatusExProcess(48, 3, null);
            OSService[] svcArray = new OSService[services.length];
            for (int i = 0; i < services.length; ++i) {
                OSService.State state;
                switch (services[i].ServiceStatusProcess.dwCurrentState) {
                    case 1: {
                        state = OSService.State.STOPPED;
                        break;
                    }
                    case 4: {
                        state = OSService.State.RUNNING;
                        break;
                    }
                    default: {
                        state = OSService.State.OTHER;
                    }
                }
                svcArray[i] = new OSService(services[i].lpDisplayName, services[i].ServiceStatusProcess.dwProcessId, state);
            }
            OSService[] oSServiceArray = svcArray;
            return oSServiceArray;
        }
        catch (Win32Exception ex) {
            Logger.error("Win32Exception: {}", ex.getMessage());
            return new OSService[0];
        }
    }

    static {
        systemLog = Memoizer.memoize(WindowsOS::querySystemLog, TimeUnit.HOURS.toNanos(1L));
        BOOTTIME = WindowsOS.querySystemBootTime();
        HkeyPerformanceData data = null;
        try {
            data = new HkeyPerformanceData();
        }
        catch (InstantiationException e) {
            Logger.warn("{} Process statistics will be read from PDH or WMI.", e.getMessage());
        }
        HKEY_PERFORMANCE_DATA = data;
        WindowsOS.enableDebugPrivilege();
    }

    private static class HkeyPerformanceData {
        private int perfDataBufferSize = 8192;
        private int processIndex;
        private String processIndexStr;
        private int priorityBaseOffset;
        private int elapsedTimeOffset;
        private int idProcessOffset;
        private int creatingProcessIdOffset;
        private int ioReadOffset;
        private int ioWriteOffset;
        private int workingSetPrivateOffset;

        private HkeyPerformanceData() throws InstantiationException {
            int priorityBaseIndex = 0;
            int elapsedTimeIndex = 0;
            int idProcessIndex = 0;
            int creatingProcessIdIndex = 0;
            int ioReadIndex = 0;
            int ioWriteIndex = 0;
            int workingSetPrivateIndex = 0;
            try {
                String ENGLISH_COUNTER_KEY = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\009";
                String ENGLISH_COUNTER_VALUE = "Counter";
                String[] counters = Advapi32Util.registryGetStringArray((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Perflib\\009", (String)"Counter");
                for (int i = 1; i < counters.length; i += 2) {
                    if (counters[i].equals("Process")) {
                        this.processIndex = Integer.parseInt(counters[i - 1]);
                        continue;
                    }
                    if (counters[i].equals("Priority Base")) {
                        priorityBaseIndex = Integer.parseInt(counters[i - 1]);
                        continue;
                    }
                    if (counters[i].equals("Elapsed Time")) {
                        elapsedTimeIndex = Integer.parseInt(counters[i - 1]);
                        continue;
                    }
                    if (counters[i].equals("ID Process")) {
                        idProcessIndex = Integer.parseInt(counters[i - 1]);
                        continue;
                    }
                    if (counters[i].equals("Creating Process ID")) {
                        creatingProcessIdIndex = Integer.parseInt(counters[i - 1]);
                        continue;
                    }
                    if (counters[i].equals("IO Read Bytes/sec")) {
                        ioReadIndex = Integer.parseInt(counters[i - 1]);
                        continue;
                    }
                    if (counters[i].equals("IO Write Bytes/sec")) {
                        ioWriteIndex = Integer.parseInt(counters[i - 1]);
                        continue;
                    }
                    if (!counters[i].equals("Working Set - Private")) continue;
                    workingSetPrivateIndex = Integer.parseInt(counters[i - 1]);
                }
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Failed to parse counter index/name array.");
            }
            catch (Win32Exception e) {
                throw new InstantiationException("Unable to locate English counter names in registry Perflib 009.");
            }
            if (this.processIndex == 0 || priorityBaseIndex == 0 || elapsedTimeIndex == 0 || idProcessIndex == 0 || creatingProcessIdIndex == 0 || ioReadIndex == 0 || ioWriteIndex == 0 || workingSetPrivateIndex == 0) {
                throw new InstantiationException("Failed to parse counter index/name array.");
            }
            this.processIndexStr = Integer.toString(this.processIndex);
            Memory pPerfData = new Memory((long)this.perfDataBufferSize);
            IntByReference lpcbData = new IntByReference(this.perfDataBufferSize);
            int ret = Advapi32.INSTANCE.RegQueryValueEx(WinReg.HKEY_PERFORMANCE_DATA, this.processIndexStr, 0, null, (Pointer)pPerfData, lpcbData);
            if (ret != 0 && ret != 234) {
                throw new InstantiationException("Error " + ret + " reading HKEY_PERFORMANCE_DATA from the registry.");
            }
            while (ret == 234) {
                this.perfDataBufferSize += 4096;
                lpcbData.setValue(this.perfDataBufferSize);
                pPerfData = new Memory((long)this.perfDataBufferSize);
                ret = Advapi32.INSTANCE.RegQueryValueEx(WinReg.HKEY_PERFORMANCE_DATA, this.processIndexStr, 0, null, (Pointer)pPerfData, lpcbData);
            }
            WinPerf.PERF_DATA_BLOCK perfData = new WinPerf.PERF_DATA_BLOCK(pPerfData.share(0L));
            long perfObjectOffset = perfData.HeaderLength;
            for (int obj = 0; obj < perfData.NumObjectTypes; ++obj) {
                WinPerf.PERF_OBJECT_TYPE perfObject = new WinPerf.PERF_OBJECT_TYPE(pPerfData.share(perfObjectOffset));
                long perfCounterOffset = perfObjectOffset + (long)perfObject.HeaderLength;
                if (perfObject.ObjectNameTitleIndex == this.processIndex) {
                    for (int counter = 0; counter < perfObject.NumCounters; ++counter) {
                        WinPerf.PERF_COUNTER_DEFINITION perfCounter = new WinPerf.PERF_COUNTER_DEFINITION(pPerfData.share(perfCounterOffset));
                        if (perfCounter.CounterNameTitleIndex == priorityBaseIndex) {
                            this.priorityBaseOffset = perfCounter.CounterOffset;
                        } else if (perfCounter.CounterNameTitleIndex == elapsedTimeIndex) {
                            this.elapsedTimeOffset = perfCounter.CounterOffset;
                        } else if (perfCounter.CounterNameTitleIndex == creatingProcessIdIndex) {
                            this.creatingProcessIdOffset = perfCounter.CounterOffset;
                        } else if (perfCounter.CounterNameTitleIndex == idProcessIndex) {
                            this.idProcessOffset = perfCounter.CounterOffset;
                        } else if (perfCounter.CounterNameTitleIndex == ioReadIndex) {
                            this.ioReadOffset = perfCounter.CounterOffset;
                        } else if (perfCounter.CounterNameTitleIndex == ioWriteIndex) {
                            this.ioWriteOffset = perfCounter.CounterOffset;
                        } else if (perfCounter.CounterNameTitleIndex == workingSetPrivateIndex) {
                            this.workingSetPrivateOffset = perfCounter.CounterOffset;
                        }
                        perfCounterOffset += (long)perfCounter.ByteLength;
                    }
                    break;
                }
                perfObjectOffset += (long)perfObject.TotalByteLength;
            }
        }

        private Map<Integer, OSProcess> buildProcessMapFromRegistry(OperatingSystem os, Collection<Integer> pids) {
            HashMap<Integer, OSProcess> processMap = new HashMap<Integer, OSProcess>();
            Memory pPerfData = new Memory((long)this.perfDataBufferSize);
            IntByReference lpcbData = new IntByReference(this.perfDataBufferSize);
            int ret = Advapi32.INSTANCE.RegQueryValueEx(WinReg.HKEY_PERFORMANCE_DATA, this.processIndexStr, 0, null, (Pointer)pPerfData, lpcbData);
            if (ret != 0 && ret != 234) {
                Logger.error("Error {} reading HKEY_PERFORMANCE_DATA from the registry.", ret);
                return processMap;
            }
            while (ret == 234) {
                this.perfDataBufferSize += 4096;
                lpcbData.setValue(this.perfDataBufferSize);
                pPerfData = new Memory((long)this.perfDataBufferSize);
                ret = Advapi32.INSTANCE.RegQueryValueEx(WinReg.HKEY_PERFORMANCE_DATA, this.processIndexStr, 0, null, (Pointer)pPerfData, lpcbData);
            }
            WinPerf.PERF_DATA_BLOCK perfData = new WinPerf.PERF_DATA_BLOCK(pPerfData.share(0L));
            long perfTime100nSec = perfData.PerfTime100nSec.getValue();
            long now = System.currentTimeMillis();
            long perfObjectOffset = perfData.HeaderLength;
            for (int obj = 0; obj < perfData.NumObjectTypes; ++obj) {
                WinPerf.PERF_OBJECT_TYPE perfObject = new WinPerf.PERF_OBJECT_TYPE(pPerfData.share(perfObjectOffset));
                if (perfObject.ObjectNameTitleIndex == this.processIndex) {
                    long perfInstanceOffset = perfObjectOffset + (long)perfObject.DefinitionLength;
                    WinPerf.PERF_COUNTER_BLOCK perfCounterBlock = null;
                    for (int inst = 0; inst < perfObject.NumInstances - 1; ++inst) {
                        WinPerf.PERF_INSTANCE_DEFINITION perfInstance = new WinPerf.PERF_INSTANCE_DEFINITION(pPerfData.share(perfInstanceOffset));
                        long perfCounterBlockOffset = perfInstanceOffset + (long)perfInstance.ByteLength;
                        int pid = pPerfData.getInt(perfCounterBlockOffset + (long)this.idProcessOffset);
                        if (pids == null || pids.contains(pid)) {
                            OSProcess proc = new OSProcess(os);
                            processMap.put(pid, proc);
                            proc.setProcessID(pid);
                            proc.setName(pPerfData.getWideString(perfInstanceOffset + (long)perfInstance.NameOffset));
                            long upTime = (perfTime100nSec - pPerfData.getLong(perfCounterBlockOffset + (long)this.elapsedTimeOffset)) / 10000L;
                            proc.setUpTime(upTime < 1L ? 1L : upTime);
                            proc.setStartTime(now - upTime);
                            proc.setBytesRead(pPerfData.getLong(perfCounterBlockOffset + (long)this.ioReadOffset));
                            proc.setBytesWritten(pPerfData.getLong(perfCounterBlockOffset + (long)this.ioWriteOffset));
                            proc.setResidentSetSize(pPerfData.getLong(perfCounterBlockOffset + (long)this.workingSetPrivateOffset));
                            proc.setParentProcessID(pPerfData.getInt(perfCounterBlockOffset + (long)this.creatingProcessIdOffset));
                            proc.setPriority(pPerfData.getInt(perfCounterBlockOffset + (long)this.priorityBaseOffset));
                        }
                        perfCounterBlock = new WinPerf.PERF_COUNTER_BLOCK(pPerfData.share(perfCounterBlockOffset));
                        perfInstanceOffset = perfCounterBlockOffset + (long)perfCounterBlock.ByteLength;
                    }
                    break;
                }
                perfObjectOffset += (long)perfObject.TotalByteLength;
            }
            return processMap;
        }
    }

    static enum ProcessPerformanceProperty implements PerfWildcardQuery.PdhCounterWildcardProperty
    {
        Name("^*_Total"),
        Priority("Priority Base"),
        CreationDate("Elapsed Time"),
        ProcessId("ID Process"),
        ParentProcessId("Creating Process ID"),
        ReadTransferCount("IO Read Bytes/sec"),
        WriteTransferCount("IO Write Bytes/sec"),
        PrivatePageCount("Working Set - Private");

        private final String counter;

        private ProcessPerformanceProperty(String counter) {
            this.counter = counter;
        }

        @Override
        public String getCounter() {
            return this.counter;
        }
    }

    static enum ProcessXPProperty {
        ProcessId,
        Name,
        KernelModeTime,
        UserModeTime,
        ThreadCount,
        PageFileUsage,
        HandleCount,
        ExecutablePath;

    }

    static enum ProcessProperty {
        ProcessId,
        CommandLine;

    }

    static enum BitnessProperty {
        AddressWidth;

    }

    static enum OSVersionProperty {
        Version,
        ProductType,
        BuildNumber,
        CSDVersion,
        SuiteMask;

    }
}

