/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.health.Platform;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.magic.family.FamilyType;
import org.aoju.bus.office.process.FreeBSDProcessManager;
import org.aoju.bus.office.process.MacProcessManager;
import org.aoju.bus.office.process.ProcessManager;
import org.aoju.bus.office.process.PureJavaProcessManager;
import org.aoju.bus.office.process.UnixProcessManager;
import org.aoju.bus.office.process.WindowsProcessManager;

public final class Builder {
    public static final String UNKNOWN_SERVICE = "com.sun.frame.XModel";
    public static final String WRITER_SERVICE = "com.sun.star.text.GenericTextDocument";
    public static final String BASE_SERVICE = "com.sun.star.sdb.OfficeDatabaseDocument";
    public static final String CALC_SERVICE = "com.sun.star.sheet.SpreadsheetDocument";
    public static final String DRAW_SERVICE = "com.sun.star.drawing.DrawingDocument";
    public static final String IMPRESS_SERVICE = "com.sun.star.presentation.PresentationDocument";
    public static final String MATH_SERVICE = "com.sun.star.formula.FormulaProperties";
    public static final String NODE_PRODUCT = "/org.openoffice.Setup/Product";
    public static final String NODE_L10N = "/org.openoffice.Setup/L10N";
    public static final String[] NODE_PATHS = new String[]{"/org.openoffice.Setup/Product", "/org.openoffice.Setup/L10N"};
    public static final String SUCCESS = "0";
    public static final String FAILURE = "-1";
    public static final int DEFAULT_PORT_NUMBER = 8102;
    public static final String DEFAULT_PIPE_NAME = "office";
    public static final long DEFAULT_CONNECT_TIMEOUT = 120000L;
    public static final long DEFAULT_RETRY_INTERVAL = 250L;
    public static final long DEFAULT_PROCESS_TIMEOUT = 120000L;
    public static final long DEFAULT_PROCESS_RETRY_INTERVAL = 250L;
    public static final int DEFAULT_MAX_TASKS_PER_PROCESS = 200;
    public static final boolean DEFAULT_DISABLE_OPENGL = false;
    public static final long MIN_PROCESS_RETRY_INTERVAL = 0L;
    public static final long MAX_PROCESS_RETRY_INTERVAL = 10000L;
    public static final long DEFAULT_TASK_QUEUE_TIMEOUT = 30000L;
    public static final boolean DEFAULT_KILL_EXISTING_PROCESS = true;
    public static final long DEFAULT_TASK_EXECUTION_TIMEOUT = 120000L;
    public static final String ERROR_MESSAGE_STORE = "Could not store document: ";
    public static final String FILTER_DATA = "FilterData";
    public static final String FILTER_DATA_PREFIX_PARAM = "fd";
    public static final String LOAD_PROPERTIES_PREFIX_PARAM = "l";
    public static final String STORE_PROPERTIES_PREFIX_PARAM = "s";
    public static final long PID_NOT_FOUND = -2L;
    public static final long PID_UNKNOWN = -1L;
    public static final boolean DEFAULT_CLOSE_STREAM = true;
    private static final String EXECUTABLE_DEFAULT = "program/soffice.bin";
    private static final String EXECUTABLE_MAC = "program/soffice";
    private static final String EXECUTABLE_MAC_41 = "MacOS/soffice";
    private static final String EXECUTABLE_WINDOWS = "program/soffice.exe";
    private static final File INSTANCE;

    public static ProcessManager findBestProcessManager() {
        if (Platform.isMac()) {
            return MacProcessManager.getDefault();
        }
        if (Platform.isFreeBSD()) {
            return FreeBSDProcessManager.getDefault();
        }
        if (Platform.isAIX() || Platform.isSolaris()) {
            return UnixProcessManager.getDefault();
        }
        if (Platform.isWindows()) {
            WindowsProcessManager windowsProcessManager = WindowsProcessManager.getDefault();
            return windowsProcessManager.isUsable() ? windowsProcessManager : PureJavaProcessManager.getDefault();
        }
        return PureJavaProcessManager.getDefault();
    }

    public static UnoUrl[] buildOfficeUrls(int[] portNumbers, String[] pipeNames) {
        if (portNumbers == null && pipeNames == null) {
            return new UnoUrl[]{new UnoUrl(8102)};
        }
        ArrayList unoUrls = new ArrayList(ArrayUtils.getLength(portNumbers) + ArrayUtils.getLength(pipeNames));
        Optional.ofNullable(pipeNames).map(Stream::of).ifPresent(stream -> stream.map(UnoUrl::new).forEach(unoUrls::add));
        if (portNumbers != null) {
            Arrays.stream(portNumbers).forEach(portNumber -> unoUrls.add(new UnoUrl(portNumber)));
        }
        return unoUrls.toArray(new UnoUrl[0]);
    }

    public static File getDefaultOfficeHome() {
        return INSTANCE;
    }

    public static FamilyType getDocumentFamily(XComponent document) throws InstrumentException {
        XServiceInfo serviceInfo = Lo.qi(XServiceInfo.class, document);
        if (serviceInfo.supportsService(WRITER_SERVICE)) {
            return FamilyType.TEXT;
        }
        if (serviceInfo.supportsService(CALC_SERVICE)) {
            return FamilyType.SPREADSHEET;
        }
        if (serviceInfo.supportsService(IMPRESS_SERVICE)) {
            return FamilyType.PRESENTATION;
        }
        if (serviceInfo.supportsService(DRAW_SERVICE)) {
            return FamilyType.DRAWING;
        }
        throw new InstrumentException("Document of unknown family: " + serviceInfo.getImplementationName());
    }

    public static File getOfficeExecutable(File officeHome) {
        if (Platform.isMac()) {
            File executableFile = new File(officeHome, EXECUTABLE_MAC_41);
            if (!executableFile.isFile()) {
                executableFile = new File(officeHome, EXECUTABLE_MAC);
            }
            return executableFile;
        }
        if (Platform.isWindows()) {
            return new File(officeHome, EXECUTABLE_WINDOWS);
        }
        return new File(officeHome, EXECUTABLE_DEFAULT);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue prop = new PropertyValue();
        prop.Name = name;
        prop.Value = value;
        return prop;
    }

    public static PropertyValue[] toUnoProperties(Map<String, Object> properties) {
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            PropertyValue[] value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = Builder.toUnoProperties(subProperties);
            }
            propertyValues.add(Builder.property(entry.getKey(), value));
        }
        return propertyValues.toArray(new PropertyValue[0]);
    }

    public static String toUrl(File file) {
        String path = file.toURI().getRawPath();
        String url = path.startsWith("//") ? "file:" + path : "file://" + path;
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static void validateOfficeHome(File officeHome) {
        if (officeHome == null) {
            throw new IllegalStateException("officeHome not set and could not be auto-detected");
        }
        if (!officeHome.isDirectory()) {
            throw new IllegalStateException("officeHome doesn't exist or is not a directory: " + officeHome);
        }
        if (!Builder.getOfficeExecutable(officeHome).isFile()) {
            throw new IllegalStateException("Invalid officeHome: it doesn't contain soffice.bin: " + officeHome);
        }
    }

    public static void validateOfficeTemplateProfileDirectory(File templateProfileDir) {
        if (templateProfileDir == null || new File(templateProfileDir, "user").isDirectory()) {
            return;
        }
        throw new IllegalStateException("templateProfileDir doesn't appear to contain a user profile: " + templateProfileDir);
    }

    public static void validateOfficeWorkingDirectory(File workingDir) {
        if (!workingDir.isDirectory()) {
            throw new IllegalStateException("workingDir doesn't exist or is not a directory: " + workingDir);
        }
        if (!workingDir.canWrite()) {
            throw new IllegalStateException("workingDir '" + workingDir + "' cannot be written to");
        }
    }

    private static File findOfficeHome(String executablePath, String ... homePaths) {
        return Stream.of(homePaths).map(File::new).filter(homeDir -> new File((File)homeDir, executablePath).isFile()).findFirst().orElse(null);
    }

    static {
        if (StringUtils.isNotBlank(System.getProperty("office.home"))) {
            INSTANCE = new File(System.getProperty("office.home"));
        } else if (Platform.isWindows()) {
            String programFiles64 = System.getenv("ProgramFiles");
            String programFiles32 = System.getenv("ProgramFiles(x86)");
            INSTANCE = Builder.findOfficeHome(EXECUTABLE_WINDOWS, programFiles64 + File.separator + "LibreOffice", programFiles64 + File.separator + "LibreOffice 5", programFiles32 + File.separator + "LibreOffice 5", programFiles32 + File.separator + "OpenOffice 4", programFiles64 + File.separator + "LibreOffice 4", programFiles32 + File.separator + "LibreOffice 4", programFiles64 + File.separator + "LibreOffice 3", programFiles32 + File.separator + "LibreOffice 3", programFiles32 + File.separator + "OpenOffice.org 3");
        } else if (Platform.isMac()) {
            File homeDir = Builder.findOfficeHome(EXECUTABLE_MAC_41, "/Applications/LibreOffice.app/Contents", "/Applications/OpenOffice.app/Contents", "/Applications/OpenOffice.org.app/Contents");
            if (homeDir == null) {
                homeDir = Builder.findOfficeHome(EXECUTABLE_MAC, "/Applications/LibreOffice.app/Contents", "/Applications/OpenOffice.app/Contents", "/Applications/OpenOffice.org.app/Contents");
            }
            INSTANCE = homeDir;
        } else {
            INSTANCE = Builder.findOfficeHome(EXECUTABLE_DEFAULT, "/usr/lib64/libreoffice", "/usr/lib/libreoffice", "/usr/local/lib64/libreoffice", "/usr/local/lib/libreoffice", "/opt/libreoffice", "/usr/lib64/openoffice", "/usr/lib64/openoffice.org3", "/usr/lib64/openoffice.org", "/usr/lib/openoffice", "/usr/lib/openoffice.org3", "/usr/lib/openoffice.org", "/opt/openoffice4", "/opt/openoffice.org3");
        }
    }
}

