/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.builtin;

import java.io.File;
import java.util.Map;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.bodys.MultipartBody;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.bridge.OnlineOfficeContextAware;
import org.aoju.bus.office.builtin.AbstractOnlineOffice;
import org.aoju.bus.office.metric.RequestBuilder;
import org.aoju.bus.office.provider.SourceDocumentProvider;
import org.aoju.bus.office.provider.TargetDocumentProvider;

public class OnlineMadeInOffice
extends AbstractOnlineOffice {
    private final TargetDocumentProvider target;

    public OnlineMadeInOffice(SourceDocumentProvider source, TargetDocumentProvider target) {
        super(source);
        this.target = target;
    }

    private void addPropertiesToBuilder(StringBuilder urlBuilder, Map<String, Object> properties, String parameterPrefix) {
        if (properties != null && !properties.isEmpty()) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if ("FilterData".equalsIgnoreCase(key) && Map.class.isInstance(value)) {
                    for (Map.Entry fdentry : ((Map)value).entrySet()) {
                        urlBuilder.append(parameterPrefix + "fd" + (String)fdentry.getKey()).append("=").append(fdentry.getValue().toString()).append("&");
                    }
                    continue;
                }
                if (!(value instanceof String) && !value.getClass().isPrimitive()) continue;
                urlBuilder.append(parameterPrefix + key).append("=").append(value.toString()).append("&");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Context context) throws InstrumentException {
        Logger.info("Executing online conversion task...", new Object[0]);
        OnlineOfficeContextAware onlineOfficeContextAware = (OnlineOfficeContextAware)context;
        File sourceFile = this.source.getFile();
        try {
            File targetFile = this.target.getFile();
            try {
                MultipartBody.Builder requestBody = new MultipartBody.Builder().setType(MediaType.MULTIPART_FORM_DATA_TYPE);
                if (targetFile != null) {
                    RequestBody body = RequestBody.create(MediaType.valueOf("image/*"), sourceFile);
                    requestBody.addFormDataPart("data", targetFile.getName(), body);
                }
                RequestBuilder requestBuilder = onlineOfficeContextAware.getRequestBuilder();
                StringBuilder urlBuilder = new StringBuilder(this.buildUrl(requestBuilder.getUrl())).append("?");
                this.addPropertiesToBuilder(urlBuilder, this.target.getFormat().getLoadProperties(), "l");
                this.addPropertiesToBuilder(urlBuilder, this.target.getFormat().getStoreProperties(this.source.getFormat().getInputFamily()), "s");
                Request request = new Request.Builder().url(urlBuilder.toString()).post(requestBody.build()).tag(context).build();
                ((OnlineOfficeContextAware)context).getHttp().newCall(request).execute();
                this.target.onComplete(targetFile);
            }
            catch (Exception ex) {
                Logger.error("Online conversion failed.", ex);
                InstrumentException officeEx = new InstrumentException("Online conversion failed", ex);
                this.target.onFailure(targetFile, officeEx);
                throw officeEx;
            }
        }
        finally {
            this.source.onConsumed(sourceFile);
        }
    }

    private String buildUrl(String connectionUrl) {
        return StringUtils.appendIfMissing(connectionUrl, (CharSequence)"/", new CharSequence[0]) + this.target.getFormat().getExtension();
    }
}

