/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.tree.TreeEntity;
import org.aoju.bus.core.lang.tree.TreeMap;
import org.aoju.bus.core.lang.tree.TreeNode;
import org.aoju.bus.core.lang.tree.parser.DefaultNodeParser;
import org.aoju.bus.core.lang.tree.parser.NodeParser;
import org.aoju.bus.core.utils.CollUtils;

public class TreeUtils {
    public static List<TreeMap<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeUtils.build(list, 0);
    }

    public static <E> List<TreeMap<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeUtils.build(list, parentId, TreeEntity.DEFAULT, new DefaultNodeParser());
    }

    public static <T, E> List<TreeMap<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtils.build(list, parentId, TreeEntity.DEFAULT, nodeParser);
    }

    public static <T, E> List<TreeMap<E>> build(List<T> list, E parentId, TreeEntity treeEntity, NodeParser<T, E> nodeParser) {
        ArrayList<TreeMap<T>> treeMapNodes = CollUtils.newArrayList(new TreeMap[0]);
        for (T obj : list) {
            TreeMap treeMap = new TreeMap(treeEntity);
            nodeParser.parse(obj, treeMap);
            treeMapNodes.add(treeMap);
        }
        ArrayList<TreeMap<TreeMap>> finalTreeMapNodes = CollUtils.newArrayList(new TreeMap[0]);
        for (TreeMap treeMap : treeMapNodes) {
            if (!parentId.equals(treeMap.getParentId())) continue;
            finalTreeMapNodes.add(treeMap);
            TreeUtils.innerBuild(treeMapNodes, treeMap, 0, treeEntity.getDeep());
        }
        finalTreeMapNodes = finalTreeMapNodes.stream().sorted().collect(Collectors.toList());
        return finalTreeMapNodes;
    }

    private static <T> void innerBuild(List<TreeMap<T>> treeMapNodes, TreeMap<T> parentNode, int deep, Integer maxDeep) {
        if (CollUtils.isEmpty(treeMapNodes)) {
            return;
        }
        if (maxDeep != null && deep >= maxDeep) {
            return;
        }
        treeMapNodes = treeMapNodes.stream().sorted().collect(Collectors.toList());
        for (TreeMap<T> childNode : treeMapNodes) {
            if (!parentNode.getId().equals(childNode.getParentId())) continue;
            List<TreeMap<T>> children = parentNode.getChildren();
            if (children == null) {
                children = CollUtils.newArrayList(new TreeMap[0]);
                parentNode.setChildren(children);
            }
            children.add(childNode);
            childNode.setParentId(parentNode.getId());
            TreeUtils.innerBuild(treeMapNodes, childNode, deep + 1, maxDeep);
        }
    }
}

