/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.magic;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.aoju.bus.core.utils.StreamUtils;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.magic.AbsCallback;
import org.aoju.bus.http.magic.HttpResponse;
import org.aoju.bus.logger.Logger;

public abstract class FileCallback
extends AbsCallback {
    private String fileAbsolutePath;

    public FileCallback() {
    }

    public FileCallback(String fileAbsolutePath) {
        this.fileAbsolutePath = fileAbsolutePath;
    }

    @Override
    public void onResponse(NewCall newCall, HttpResponse response, int id) {
        try {
            if (this.fileAbsolutePath != null && this.fileAbsolutePath.length() > 0) {
                File file = new File(this.fileAbsolutePath);
                FileOutputStream fos = new FileOutputStream(file);
                ByteArrayInputStream bis = new ByteArrayInputStream(response.body().bytes());
                StreamUtils.copy(bis, fos);
                this.onSuccess(newCall, file, id);
            } else {
                this.onSuccess(newCall, response.body().byteStream(), id);
            }
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), e);
        }
    }

    public void onSuccess(NewCall newCall, File file, int id) {
    }

    public void onSuccess(NewCall newCall, InputStream fileStream, int id) {
    }
}

