/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.builder;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.criteria.Criteria;
import org.aoju.bus.mapper.criteria.SqlsCriteria;
import org.aoju.bus.mapper.entity.Condition;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.entity.EntityTable;

public class Builder {
    public final Class<?> entityClass;
    public EntityTable table;
    public Map<String, EntityColumn> propertyMap;
    public StringBuilder orderByClause;
    public boolean distinct;
    public boolean exists;
    public boolean notNull;
    public boolean forUpdate;
    public Set<String> selectColumns;
    public Set<String> excludeColumns;
    public String countColumn;
    public List<Assert.Criteria> sqlsCriteria;
    public List<Criteria> criterias;
    public String tableName;

    public Builder(Class<?> entityClass) {
        this(entityClass, true);
    }

    public Builder(Class<?> entityClass, boolean exists) {
        this(entityClass, exists, false);
    }

    public Builder(Class<?> entityClass, boolean exists, boolean notNull) {
        this.entityClass = entityClass;
        this.exists = exists;
        this.notNull = notNull;
        this.orderByClause = new StringBuilder();
        this.table = EntityBuilder.getEntityTable(entityClass);
        this.propertyMap = this.table.getPropertyMap();
        this.sqlsCriteria = new ArrayList<Assert.Criteria>(2);
    }

    public Builder distinct() {
        return this.setDistinct(true);
    }

    public Builder forUpdate() {
        return this.setForUpdate(true);
    }

    public Builder selectDistinct(String ... properties) {
        this.select(properties);
        this.distinct = true;
        return this;
    }

    public Builder select(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.selectColumns == null) {
                this.selectColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) {
                    throw new InstrumentException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
                }
                this.selectColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public Builder notSelect(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.excludeColumns == null) {
                this.excludeColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) {
                    throw new InstrumentException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
                }
                this.excludeColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public Builder from(String tableName) {
        return this.setTableName(tableName);
    }

    public Builder where(Assert anAssert) {
        Assert.Criteria criteria = anAssert.getCriteria();
        criteria.setAndOr("and");
        this.sqlsCriteria.add(criteria);
        return this;
    }

    public Builder where(SqlsCriteria sqlsCriteria) {
        Assert.Criteria criteria = sqlsCriteria.getCriteria();
        criteria.setAndOr("and");
        this.sqlsCriteria.add(criteria);
        return this;
    }

    public Builder andWhere(Assert anAssert) {
        Assert.Criteria criteria = anAssert.getCriteria();
        criteria.setAndOr("and");
        this.sqlsCriteria.add(criteria);
        return this;
    }

    public Builder andWhere(SqlsCriteria sqlsCriteria) {
        Assert.Criteria criteria = sqlsCriteria.getCriteria();
        criteria.setAndOr("and");
        this.sqlsCriteria.add(criteria);
        return this;
    }

    public Builder orWhere(Assert anAssert) {
        Assert.Criteria criteria = anAssert.getCriteria();
        criteria.setAndOr("or");
        this.sqlsCriteria.add(criteria);
        return this;
    }

    public Builder orWhere(SqlsCriteria sqlsCriteria) {
        Assert.Criteria criteria = sqlsCriteria.getCriteria();
        criteria.setAndOr("or");
        this.sqlsCriteria.add(criteria);
        return this;
    }

    public Builder orderBy(String ... properties) {
        return this.orderByAsc(properties);
    }

    public Builder orderByAsc(String ... properties) {
        this.contactOrderByClause(" Asc", properties);
        return this;
    }

    public Builder orderByDesc(String ... properties) {
        this.contactOrderByClause(" Desc", properties);
        return this;
    }

    private void contactOrderByClause(String order, String ... properties) {
        StringBuilder columns = new StringBuilder();
        for (String property : properties) {
            String column = this.propertyforOderBy(property);
            if (column == null) continue;
            columns.append(",").append(column);
        }
        columns.append(order);
        if (columns.length() > 0) {
            this.orderByClause.append((CharSequence)columns);
        }
    }

    public Condition build() {
        this.criterias = new ArrayList<Criteria>();
        for (Assert.Criteria criteria : this.sqlsCriteria) {
            Criteria criteriat = new Criteria(this.propertyMap, this.exists, this.notNull);
            criteriat.setAndOr(criteria.getAndOr());
            for (Assert.Criterion criterion : criteria.getCriterions()) {
                String condition = criterion.getCondition();
                String andOr = criterion.getAndOr();
                String property = criterion.getProperty();
                Object[] values = criterion.getValues();
                this.transformCriterion(criteriat, condition, property, values, andOr);
            }
            this.criterias.add(criteriat);
        }
        if (this.orderByClause.length() > 0) {
            this.orderByClause = new StringBuilder(this.orderByClause.substring(1, this.orderByClause.length()));
        }
        return new Condition(this.entityClass);
    }

    private void transformCriterion(Criteria criteria, String condition, String property, Object[] values, String andOr) {
        if (values.length == 0) {
            if ("and".equals(andOr)) {
                criteria.addCriterion(this.column(property) + " " + condition);
            } else {
                criteria.addOrCriterion(this.column(property) + " " + condition);
            }
        } else if (values.length == 1) {
            if ("and".equals(andOr)) {
                criteria.addCriterion(this.column(property) + " " + condition, values[0], this.property(property));
            } else {
                criteria.addOrCriterion(this.column(property) + " " + condition, values[0], this.property(property));
            }
        } else if (values.length == 2) {
            if ("and".equals(andOr)) {
                criteria.addCriterion(this.column(property) + " " + condition, values[0], values[1], this.property(property));
            } else {
                criteria.addOrCriterion(this.column(property) + " " + condition, values[0], values[1], this.property(property));
            }
        }
    }

    private String column(String property) {
        if (this.propertyMap.containsKey(property)) {
            return this.propertyMap.get(property).getColumn();
        }
        if (this.exists) {
            throw new InstrumentException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
        }
        return null;
    }

    private String property(String property) {
        if (this.propertyMap.containsKey(property)) {
            return property;
        }
        if (this.exists) {
            throw new InstrumentException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
        }
        return null;
    }

    private String propertyforOderBy(String property) {
        if (Assert.isEmpty(property) || Assert.isEmpty(property.trim())) {
            throw new InstrumentException("\u63a5\u6536\u7684property\u4e3a\u7a7a\uff01");
        }
        if (!this.propertyMap.containsKey(property = property.trim())) {
            throw new InstrumentException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
        }
        return this.propertyMap.get(property).getColumn();
    }

    public Builder setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public Builder setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    public Builder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }
}

