/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import java.io.File;
import java.io.IOException;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.health.Platform;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.Expense;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.metric.ExitCodeRetryable;
import org.aoju.bus.office.metric.OfficeOption;
import org.aoju.bus.office.metric.OfficeProcessBuilder;
import org.aoju.bus.office.process.LinesPumpStreamHandler;
import org.aoju.bus.office.process.ProcessManager;
import org.aoju.bus.office.process.ProcessQuery;

public class OfficeProcess {
    private final UnoUrl unoUrl;
    private final OfficeProcessBuilder config;
    private final File instanceProfileDir;
    private Expense process;
    private OfficeOption descriptor;
    private long pid = -1L;

    public OfficeProcess(UnoUrl unoUrl) {
        this(unoUrl, new OfficeProcessBuilder());
    }

    public OfficeProcess(UnoUrl unoUrl, OfficeProcessBuilder config) {
        this.unoUrl = unoUrl;
        this.config = config;
        this.instanceProfileDir = this.getInstanceProfileDir();
    }

    private void checkForExistingProcess(ProcessQuery processQuery) throws InstrumentException {
        try {
            ProcessManager processManager = this.config.getProcessManager();
            long existingPid = processManager.find(processQuery);
            if (existingPid != -2L && existingPid != -1L && this.config.isKillExistingProcess()) {
                Logger.warn("A process with acceptString '{}' is already running; pid {}", processQuery.getArgument(), existingPid);
                processManager.kill(null, existingPid);
                this.waitForProcessToDie();
                existingPid = processManager.find(processQuery);
            }
            if (existingPid != -2L && existingPid != -1L) {
                throw new InstrumentException(String.format("A process with acceptString '%s' is already running; pid %d", processQuery.getArgument(), existingPid));
            }
        }
        catch (IOException ioEx) {
            throw new InstrumentException(String.format("Unable to check if there is already an existing process with acceptString '%s'", processQuery.getArgument()), ioEx);
        }
    }

    public void deleteInstanceProfileDir() {
        Logger.debug("Deleting instance profile directory '{}'", this.instanceProfileDir);
        try {
            FileUtils.delete(this.instanceProfileDir);
        }
        catch (InstrumentException ioEx) {
            File oldProfileDir = new File(this.instanceProfileDir.getParentFile(), this.instanceProfileDir.getName() + ".old." + System.currentTimeMillis());
            if (this.instanceProfileDir.renameTo(oldProfileDir)) {
                Logger.warn("Could not delete profileDir: {}; renamed it to {}", ioEx.getMessage(), oldProfileDir);
            }
            Logger.error("Could not delete profileDir: {}", ioEx.getMessage());
        }
    }

    public int forciblyTerminate(long retryInterval, long retryTimeout) throws InstrumentException {
        if (ObjectUtils.isEmpty((Object)this.process)) {
            return 0;
        }
        Logger.info("Trying to forcibly terminate process: '{}'; pid: {}", this.unoUrl.getConnectionParametersAsString(), this.pid == -1L ? "NA" : Long.valueOf(this.pid));
        try {
            this.config.getProcessManager().kill(this.process.getProcess(), this.pid);
            return this.getExitCode(retryInterval, retryTimeout);
        }
        catch (IOException ioEx) {
            throw new InstrumentException("Unable to kill the process with pid: " + this.pid, ioEx);
        }
    }

    public Integer getExitCode() {
        if (ObjectUtils.isEmpty((Object)this.process)) {
            return 0;
        }
        return this.process.getExitCode();
    }

    public int getExitCode(long retryInterval, long retryTimeout) throws InstrumentException {
        if (ObjectUtils.isEmpty((Object)this.process)) {
            return 0;
        }
        try {
            ExitCodeRetryable retryable = new ExitCodeRetryable(this.process);
            retryable.execute(retryInterval, retryTimeout);
            return retryable.getExitCode();
        }
        catch (Exception ex) {
            throw new InstrumentException("Could not get the process exit code", ex);
        }
    }

    private File getInstanceProfileDir() {
        return new File(this.config.getWorkingDir(), ".converter_" + this.unoUrl.getConnectionAndParametersAsString().replace(',', '_').replace('=', '-'));
    }

    public boolean isRunning() {
        return this.process != null && this.getExitCode() == null;
    }

    private void prepareInstanceProfileDir() throws InstrumentException {
        if (this.instanceProfileDir.exists()) {
            Logger.warn("Profile dir '{}' already exists; deleting", this.instanceProfileDir);
            this.deleteInstanceProfileDir();
        }
        if (this.config.getTemplateProfileDir() != null) {
            try {
                FileUtils.copyFile(this.config.getTemplateProfileDir(), this.instanceProfileDir, new StandardCopyOption[0]);
            }
            catch (InstrumentException ioEx) {
                throw new InstrumentException("Failed to create the instance profile directory", ioEx);
            }
        }
    }

    private ProcessBuilder prepareProcessBuilder(String acceptString) {
        ArrayList<String> command = new ArrayList<String>();
        File executable = Builder.getOfficeExecutable(this.config.getOfficeHome());
        if (this.config.getRunAsArgs() != null) {
            command.addAll(Arrays.asList(this.config.getRunAsArgs()));
        }
        String execPath = executable.getAbsolutePath();
        String prefix = this.descriptor.useLongOptionNameGnuStyle() ? "--" : "-";
        command.add(execPath);
        command.add(prefix + "accept=" + acceptString);
        command.add(prefix + "headless");
        command.add(prefix + "invisible");
        command.add(prefix + "nocrashreport");
        command.add(prefix + "nodefault");
        command.add(prefix + "nofirststartwizard");
        command.add(prefix + "nolockcheck");
        command.add(prefix + "nologo");
        command.add(prefix + "norestore");
        command.add("-env:UserInstallation=" + Builder.toUrl(this.instanceProfileDir));
        return new ProcessBuilder(command);
    }

    public void start() throws InstrumentException {
        this.start(false);
    }

    public void start(boolean restart) throws InstrumentException {
        String acceptString = this.unoUrl.getConnectionAndParametersAsString() + ";" + this.unoUrl.getProtocolAndParametersAsString() + ";" + this.unoUrl.getRootOid();
        ProcessQuery processQuery = new ProcessQuery("soffice", acceptString);
        this.checkForExistingProcess(processQuery);
        if (!restart) {
            this.prepareInstanceProfileDir();
        }
        this.detectOfficeVersion();
        ProcessBuilder processBuilder = this.prepareProcessBuilder(acceptString);
        Logger.info("Starting process with acceptString '{}' and profileDir '{}'", acceptString, this.instanceProfileDir);
        try {
            this.process = new Expense(processBuilder.start());
            this.pid = this.config.getProcessManager().find(processQuery);
            Logger.info("Started process{}", this.pid == -1L ? "" : "; pid = " + this.pid);
        }
        catch (IOException ioEx) {
            throw new InstrumentException(String.format("An I/O error prevents us to start a process with acceptString '%s'", acceptString), ioEx);
        }
        if (this.pid == -2L) {
            throw new InstrumentException(String.format("A process with acceptString '%s' started but its pid could not be found", acceptString));
        }
    }

    private void waitForProcessToDie() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void detectOfficeVersion() {
        ArrayList<String> command = new ArrayList<String>();
        File executable = Builder.getOfficeExecutable(this.config.getOfficeHome());
        if (this.config.getRunAsArgs() != null) {
            command.addAll(Arrays.asList(this.config.getRunAsArgs()));
        }
        String execPath = executable.getAbsolutePath();
        this.descriptor = OfficeOption.fromExecutablePath(execPath);
        if (Platform.isWindows()) {
            return;
        }
        String prefix = this.descriptor.useLongOptionNameGnuStyle() ? "--" : "-";
        command.add(execPath);
        command.add(prefix + "invisible");
        command.add(prefix + "help");
        command.add(prefix + "headless");
        command.add(prefix + "nocrashreport");
        command.add(prefix + "nodefault");
        command.add(prefix + "nofirststartwizard");
        command.add(prefix + "nolockcheck");
        command.add(prefix + "nologo");
        command.add(prefix + "norestore");
        command.add("-env:UserInstallation=" + Builder.toUrl(this.instanceProfileDir));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        try {
            Process process = processBuilder.start();
            LinesPumpStreamHandler handler = new LinesPumpStreamHandler(process.getInputStream(), process.getErrorStream());
            handler.start();
            process.waitFor();
            handler.stop();
            this.descriptor = OfficeOption.fromHelpOutput(handler.getOutputPumper().getLines());
        }
        catch (IOException | InterruptedException ioEx) {
            Logger.warn("An I/O error prevents us to determine office version", ioEx);
        }
    }
}

