/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.google.common.collect.Maps;
import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.NoResponseException;
import io.minio.messages.Item;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;
import org.apache.http.entity.ContentType;
import org.xmlpull.v1.XmlPullParserException;

public class MinioOssProvider
extends AbstractProvider {
    private MinioClient client;

    public MinioOssProvider(Context context) {
        this.context = context;
        Assert.notBlank(this.context.getPrefix(), "[prefix] not defined", new Object[0]);
        Assert.notBlank(this.context.getEndpoint(), "[endpoint] not defined", new Object[0]);
        Assert.notBlank(this.context.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.context.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.context.getSecretKey(), "[secretKey] not defined", new Object[0]);
        Assert.notNull(this.context.isSecure(), "[secure] not defined", new Object[0]);
        Assert.notBlank(StringUtils.toString(this.context.getReadTimeout()), "[readTimeout] not defined", new Object[0]);
        Assert.notBlank(StringUtils.toString(this.context.getConnectTimeout()), "[connectTimeout] not defined", new Object[0]);
        Assert.notBlank(StringUtils.toString(this.context.getWriteTimeout()), "[writeTimeout] not defined", new Object[0]);
        Assert.notBlank(StringUtils.toString(this.context.getReadTimeout()), "[readTimeout] not defined", new Object[0]);
        try {
            this.client = new MinioClient(this.context.getEndpoint(), this.context.getAccessKey(), this.context.getSecretKey(), this.context.isSecure());
            this.client.setTimeout(Duration.ofSeconds(this.context.getConnectTimeout() != 0L ? this.context.getConnectTimeout() : 10L).toMillis(), Duration.ofSeconds(this.context.getWriteTimeout() != 60L ? this.context.getWriteTimeout() : 60L).toMillis(), Duration.ofSeconds(this.context.getReadTimeout() != 0L ? this.context.getReadTimeout() : 10L).toMillis());
        }
        catch (InvalidEndpointException | InvalidPortException ex) {
            throw new InstrumentException(ex.getMessage());
        }
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        try {
            InputStream inputStream = this.client.getObject(bucket, fileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            return new Readers(bufferedReader);
        }
        catch (Exception e) {
            Logger.error("file download failed", e.getMessage());
            return new Readers("-1");
        }
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        try {
            InputStream inputStream = this.client.getObject(bucket, fileName);
            FileOutputStream outputStream = new FileOutputStream(file);
            IoUtils.copy(inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            Logger.error("file download failed", e.getMessage());
        }
        return new Readers("-1");
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.context.getBucket(), fileName, file);
    }

    @Override
    public Readers list() {
        try {
            Iterable iterable = this.client.listObjects(this.context.getBucket());
            return new Readers(StreamSupport.stream(iterable.spliterator(), true).map(itemResult -> {
                try {
                    Attachs storageItem = new Attachs();
                    Item item = (Item)itemResult.get();
                    storageItem.setName(item.objectName());
                    storageItem.setSize(StringUtils.toString(item.objectSize()));
                    HashMap extend = Maps.newHashMap();
                    extend.put("tag", item.etag());
                    extend.put("storageClass", item.storageClass());
                    extend.put("lastModified", item.lastModified());
                    storageItem.setExtend(extend);
                    return storageItem;
                }
                catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                    return new Readers("-1");
                }
            }).collect(Collectors.toList()));
        }
        catch (XmlPullParserException e) {
            Logger.error("file list failed", e.getMessage());
            return new Readers("-1");
        }
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers upload(String bucket, byte[] content) {
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        return this.upload(this.context.getBucket(), bucket, stream);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        try {
            this.client.putObject(bucket, fileName, content, (long)content.available(), ContentType.APPLICATION_OCTET_STREAM.getMimeType());
            return new Readers(Attachs.builder().name(fileName).path(this.context.getPrefix() + fileName).build());
        }
        catch (Exception e) {
            Logger.error("file upload failed", e.getMessage());
            return new Readers("-1");
        }
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        return this.upload(bucket, fileName, new ByteArrayInputStream(content));
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.context.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        try {
            this.client.removeObject(bucket, fileName);
            return new Readers("0");
        }
        catch (Exception e) {
            Logger.error("file remove failed ", e.getMessage());
            return new Readers("-1");
        }
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

