/*********************************************************************************
 *                                                                               *
 * The MIT License                                                               *
 *                                                                               *
 * Copyright (c) 2015-2020 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 ********************************************************************************/
package org.aoju.bus.crypto;

/**
 * @author Kimi Liu
 * @version 5.6.9
 * @since JDK 1.8+
 */
public interface Provider {

    /**
     * 数据加密
     * 1. 私钥加密
     * 2. 公钥加密
     *
     * @param key     密钥,字符串,分割
     *                示例: 5c3,5c3,PrivateKey
     * @param content 需要加密的内容
     * @return 加密结果
     */
    byte[] encrypt(String key, byte[] content);

    /**
     * 数据解密
     * 1. 公钥解密
     * 2. 私钥解密
     *
     * @param key     密钥, 字符串使用,分割
     *                格式: 私钥,公钥,类型
     *                示例: 5c3,5c3,PrivateKey
     *                1. 私钥加密,公钥解密
     *                2. 公钥加密,私钥解密
     * @param content 需要解密的内容
     * @return 解密结果
     */
    byte[] decrypt(String key, byte[] content);

}
