/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus;

import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class Version {
    private boolean complete = true;

    public static String get() {
        return "5.6.9.RELEASE";
    }

    public static String major() {
        return StringUtils.split((CharSequence)Version.get(), ".")[0];
    }

    public static String minor() {
        return StringUtils.split((CharSequence)Version.get(), ".")[1];
    }

    public static String stage() {
        return StringUtils.split((CharSequence)Version.get(), ".")[2];
    }

    public static String level() {
        return StringUtils.split((CharSequence)Version.get(), ".")[3];
    }

    public static String all() {
        return Version.major() + Version.minor() + Version.stage();
    }

    public Version inComplete() {
        this.complete = false;
        return this;
    }

    public boolean eq(String version) {
        return this.compare(version) == 0;
    }

    public boolean ne(String version) {
        return this.compare(version) != 0;
    }

    public boolean gt(String version) {
        return this.compare(version) > 0;
    }

    public boolean gte(String version) {
        return this.compare(version) >= 0;
    }

    public boolean lt(String version) {
        return this.compare(version) < 0;
    }

    public boolean lte(String version) {
        return this.compare(version) <= 0;
    }

    private int compare(String version) {
        return ObjectUtils.compare(Version.get(), version, this.complete);
    }
}

