/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.Serializable;
import java.util.function.Supplier;

public class Lazy<T>
implements Supplier<T>,
Serializable {
    private volatile transient Supplier<? extends T> supplier;
    private T value;

    public static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        return this.supplier == null ? this.value : this.computeValue();
    }

    private synchronized T computeValue() {
        Supplier<T> s = this.supplier;
        if (s != null) {
            this.value = s.get();
            this.supplier = null;
        }
        return this.value;
    }
}

