/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.tree;

import java.util.LinkedHashMap;
import java.util.List;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.tree.TreeEntity;
import org.aoju.bus.core.utils.ObjectUtils;

public class TreeMap<T>
extends LinkedHashMap<String, Object>
implements Comparable<TreeMap<T>> {
    private static final long serialVersionUID = 1L;
    private TreeEntity treeEntity;

    public TreeMap() {
        this((TreeEntity)null);
    }

    public TreeMap(TreeEntity treeEntity) {
        this.treeEntity = ObjectUtils.defaultIfNull(treeEntity, TreeEntity.DEFAULT);
    }

    public T getId() {
        return (T)this.get(this.treeEntity.getIdKey());
    }

    public TreeMap<T> setId(T id) {
        this.put(this.treeEntity.getIdKey(), id);
        return this;
    }

    public T getParentId() {
        return (T)this.get(this.treeEntity.getParentIdKey());
    }

    public TreeMap<T> setParentId(T parentId) {
        this.put(this.treeEntity.getParentIdKey(), parentId);
        return this;
    }

    public T getName() {
        return (T)this.get(this.treeEntity.getNameKey());
    }

    public TreeMap<T> setName(Object name) {
        this.put(this.treeEntity.getNameKey(), name);
        return this;
    }

    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.treeEntity.getWeightKey());
    }

    public TreeMap<T> setWeight(Comparable<?> weight) {
        this.put(this.treeEntity.getWeightKey(), weight);
        return this;
    }

    public List<TreeMap<T>> getChildren() {
        return (List)this.get(this.treeEntity.getChildrenKey());
    }

    public void setChildren(List<TreeMap<T>> children) {
        this.put(this.treeEntity.getChildrenKey(), children);
    }

    public void putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value);
    }

    @Override
    public int compareTo(TreeMap<T> treeMap) {
        Comparable<?> weight = this.getWeight();
        if (null != weight) {
            Comparable<?> weightOther = treeMap.getWeight();
            return weight.compareTo(weightOther);
        }
        return 0;
    }
}

