/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.beans.BeanDesc;
import org.aoju.bus.core.beans.BeanDescCache;
import org.aoju.bus.core.beans.BeanInfoCache;
import org.aoju.bus.core.beans.BeanPath;
import org.aoju.bus.core.beans.DynaBean;
import org.aoju.bus.core.beans.copier.BeanCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.ModifierUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class BeanUtils {
    public static boolean isBean(Class<?> clazz) {
        if (ClassUtils.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(Object bean, String ... ignoreFiledNames) {
        if (null != bean) {
            for (Field field : ReflectUtils.getFields(bean.getClass())) {
                if (ArrayUtils.contains(ignoreFiledNames, field.getName()) || null == ReflectUtils.getFieldValue(bean, field)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotEmpty(Object bean, String ... ignoreFiledNames) {
        return false == BeanUtils.isEmpty(bean, ignoreFiledNames);
    }

    public static boolean hasNull(Object bean) {
        Field[] fields = ClassUtils.getDeclaredFields(bean.getClass());
        Object fieldValue = null;
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                fieldValue = field.get(bean);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != fieldValue) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (ClassUtils.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (ClassUtils.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassUtils.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!ModifierUtils.isPublic(field) || ModifierUtils.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNullField(Object bean, String ... ignoreFiledNames) {
        if (null == bean) {
            return true;
        }
        for (Field field : ReflectUtils.getFields(bean.getClass())) {
            if (ArrayUtils.contains(ignoreFiledNames, field.getName()) || null != ReflectUtils.getFieldValue(bean, field)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNullField(Object bean) {
        if (null == bean) {
            return true;
        }
        for (Field field : ReflectUtils.getFields(bean.getClass())) {
            if (null != ReflectUtils.getFieldValue(bean, field)) continue;
            return true;
        }
        return false;
    }

    public static <T> T trimStrField(T bean, String ... ignoreField) {
        Field[] fields;
        if (bean == null) {
            return bean;
        }
        for (Field field : fields = ReflectUtils.getFields(bean.getClass())) {
            String trimVal;
            String val;
            if (ignoreField != null && ArrayUtils.containsIgnoreCase(ignoreField, field.getName()) || !String.class.equals(field.getType()) || null == (val = (String)ReflectUtils.getFieldValue(bean, field)) || val.equals(trimVal = StringUtils.trim(val))) continue;
            ReflectUtils.setFieldValue(bean, field, (Object)trimVal);
        }
        return bean;
    }

    public static DynaBean create(Object bean) {
        return new DynaBean(bean);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        BeanDesc beanDesc = BeanDescCache.INSTANCE.getBeanDesc(clazz);
        if (null == beanDesc) {
            beanDesc = new BeanDesc(clazz);
            BeanDescCache.INSTANCE.putBeanDesc(clazz, beanDesc);
        }
        return beanDesc;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws InstrumentException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new InstrumentException(e);
        }
        return ArrayUtils.filter(beanInfo.getPropertyDescriptors(), t -> false == "class".equals(t.getName()));
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) {
        Map<String, PropertyDescriptor> map = BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase);
        if (null == map) {
            map = BeanUtils.internalGetPropertyDescriptorMap(clazz, ignoreCase);
            BeanInfoCache.INSTANCE.putPropertyDescriptorMap(clazz, map, ignoreCase);
        }
        return map;
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) {
        PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) {
        return BeanUtils.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) {
        Map<String, PropertyDescriptor> map = BeanUtils.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        if (null == bean || null == fieldNameOrIndex) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            return CollUtils.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
        }
        if (ArrayUtils.isArray(bean)) {
            return ArrayUtils.get(bean, Integer.parseInt(fieldNameOrIndex));
        }
        return ReflectUtils.getFieldValue(bean, fieldNameOrIndex);
    }

    public static void setFieldValue(Object bean, String fieldNameOrIndex, Object value) {
        if (bean instanceof Map) {
            ((Map)bean).put(fieldNameOrIndex, value);
        } else if (bean instanceof List) {
            CollUtils.setOrAppend((List)bean, Convert.toInt(fieldNameOrIndex), value);
        } else if (ArrayUtils.isArray(bean)) {
            ArrayUtils.setOrAppend(bean, (int)Convert.toInt(fieldNameOrIndex), value);
        } else {
            ReflectUtils.setFieldValue(bean, fieldNameOrIndex, value);
        }
    }

    public static Object getProperty(Object bean, String expression) {
        return BeanPath.create(expression).get(bean);
    }

    public static void setProperty(Object bean, String expression, Object value) {
        BeanPath.create(expression).set(bean, value);
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        T target = ReflectUtils.newInstance(clazz, new Object[0]);
        BeanUtils.copyProperties(source, target);
        return target;
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        return BeanUtils.fillBean(ReflectUtils.newInstance(beanClass, new Object[0]), valueProvider, copyOptions);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMap(map, ReflectUtils.newInstance(beanClass, new Object[0]), isIgnoreError);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, CopyOptions copyOptions) {
        return BeanUtils.fillBeanWithMap(map, ReflectUtils.newInstance(beanClass, new Object[0]), copyOptions);
    }

    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMapIgnoreCase(map, ReflectUtils.newInstance(beanClass, new Object[0]), isIgnoreError);
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.create(valueProvider, bean, copyOptions).copy();
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMap(map, bean, false, isIgnoreError);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMap(map, bean, isToCamelCase, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtils.fillBeanWithMap(map, bean, CopyOptions.create().setIgnoreCase(true).setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        return BeanUtils.fillBeanWithMap(map, bean, false, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, CopyOptions copyOptions) {
        if (MapUtils.isEmpty(map)) {
            return bean;
        }
        if (isToCamelCase) {
            map = MapUtils.toCamelCaseMap(map);
        }
        return BeanCopier.create(map, bean, copyOptions).copy();
    }

    public static Map<String, Object> beanToMap(Object bean) {
        return BeanUtils.beanToMap(bean, false, false);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return BeanUtils.beanToMap(bean, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (bean == null) {
            return null;
        }
        return BeanUtils.beanToMap(bean, targetMap, ignoreNullValue, key -> isToUnderlineCase ? StringUtils.toUnderlineCase(key) : key);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        if (bean == null) {
            return null;
        }
        Collection<BeanDesc.PropDesc> props = BeanUtils.getBeanDesc(bean.getClass()).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            String key = prop.getFieldName();
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (ignoreNullValue && (null == value || value.equals(bean)) || null == (key = keyEditor.edit(key))) continue;
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties(source, target, CopyOptions.create());
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtils.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, boolean ignoreCase) {
        BeanCopier.create(source, target, CopyOptions.create().setIgnoreCase(ignoreCase)).copy();
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        BeanCopier.create(source, target, copyOptions).copy();
    }

    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        return ClassUtils.getClassName(bean, isSimple).equals(isSimple ? StringUtils.upperFirst(beanClassName) : beanClassName);
    }
}

