/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.aoju.bus.core.annotation.Alias;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.SimpleCache;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.StringUtils;

public class ReflectUtils {
    public static final String SETTER_PREFIX = "set";
    public static final String GETTER_PREFIX = "get";
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final SimpleCache<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Field[]> FIELDS_CACHE = new SimpleCache();
    private static final SimpleCache<Class<?>, Method[]> METHODS_CACHE = new SimpleCache();

    public static Object invokeGetter(Object obj, String name) {
        Object object = obj;
        for (String method : StringUtils.split((CharSequence)name, ".")) {
            String getterMethodName = GETTER_PREFIX + StringUtils.capitalize(method);
            object = ReflectUtils.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
        }
        return object;
    }

    public static void invokeSetter(Object obj, String name, Object value) {
        Object object = obj;
        String[] names = StringUtils.split((CharSequence)name, ".");
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = GETTER_PREFIX + StringUtils.capitalize(names[i]);
                object = ReflectUtils.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
                continue;
            }
            String setterMethodName = SETTER_PREFIX + StringUtils.capitalize(names[i]);
            ReflectUtils.invokeMethodByName(object, setterMethodName, new Object[]{value});
        }
    }

    public static Object convert(Object obj, Class<?> type) {
        if (obj instanceof Number) {
            Number number = (Number)obj;
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return number.byteValue();
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return number.shortValue();
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return number.intValue();
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return number.longValue();
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(number.floatValue());
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return number.doubleValue();
            }
        }
        if (type.equals(String.class)) {
            return obj == null ? "" : obj.toString();
        }
        return obj;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectUtils.invokeMethod(method, target, Normal.EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeMethod(Object obj, String name, Class<?>[] types, Object[] args) {
        Method method = ReflectUtils.getAccessibleMethod(obj, name, types);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + method + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Object invokeMethodByName(Object obj, String name, Object[] args) {
        Method method = ReflectUtils.getAccessibleMethodByName(obj, name);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + name + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ReflectUtils.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Field getAccessibleField(Object obj, String name) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(name);
                ReflectUtils.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object obj, String name, Class<?> ... types) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(name, types);
                ReflectUtils.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Object obj, String name) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                ReflectUtils.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ReflectUtils.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getUserClass(Object instance) {
        Class<?> superClass;
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException(((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }

    public static boolean hasField(Object obj, String fieldName) {
        Field field = ReflectUtils.getAccessibleField(obj, fieldName);
        return field != null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtils.isAllAssignableFrom(pts, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        Constructor<?>[] constructors = CONSTRUCTORS_CACHE.get(beanClass);
        if (null != constructors) {
            return constructors;
        }
        constructors = ReflectUtils.getConstructorsDirectly(beanClass);
        return CONSTRUCTORS_CACHE.put(beanClass, constructors);
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return beanClass.getDeclaredConstructors();
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = ReflectUtils.getFields(beanClass);
        if (ArrayUtils.isNotEmpty(fields)) {
            for (Field field : fields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Field[] allFields = FIELDS_CACHE.get(beanClass);
        if (null != allFields) {
            return allFields;
        }
        allFields = ReflectUtils.getFields(beanClass, true);
        return FIELDS_CACHE.put(beanClass, allFields);
    }

    public static Field[] getFields(Class<?> beanClass, boolean withSuperClassFieds) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayUtils.append(allFields, declaredFields);
            searchType = withSuperClassFieds ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static String getFieldsName(Field field) {
        if (null == field) {
            return null;
        }
        Alias alias = field.getAnnotation(Alias.class);
        if (null != alias) {
            return alias.value();
        }
        return field.getName();
    }

    public static Object getFieldValue(Object obj, String fieldName) throws InstrumentException {
        if (null == obj || StringUtils.isBlank(fieldName)) {
            return null;
        }
        return ReflectUtils.getFieldValue(obj, ReflectUtils.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) throws InstrumentException {
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("IllegalAccess for " + obj.getClass() + "." + field.getName());
        }
    }

    public static Object[] getFieldsValue(Object obj) {
        Field[] fields;
        if (null != obj && null != (fields = ReflectUtils.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass()))) {
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                values[i] = ReflectUtils.getFieldValue(obj, fields[i]);
            }
            return values;
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws InstrumentException {
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        Field field = ReflectUtils.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        ReflectUtils.setFieldValue(obj, field, value);
    }

    public static void setFieldValue(Object obj, Field field, Object value) throws InstrumentException {
        Object targetValue;
        Class<?> fieldType;
        Assert.notNull(field, "Field in [{}] not exist !", obj);
        if (null != value && !(fieldType = field.getType()).isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
            value = targetValue;
        }
        ReflectUtils.setAccessible(field);
        try {
            field.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("IllegalAccess for {}.{}", obj, field.getName());
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StringUtils.isBlank(methodName)) {
            return null;
        }
        return ReflectUtils.getMethod(obj.getClass(), methodName, ClassUtils.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtils.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StringUtils.isBlank(methodName)) {
            return null;
        }
        Method[] methods = ReflectUtils.getMethods(clazz);
        if (ArrayUtils.isNotEmpty(methods)) {
            for (Method method : methods) {
                if (!StringUtils.equals(methodName, method.getName(), ignoreCase) || !ArrayUtils.isEmpty(paramTypes) && !ClassUtils.isAllAssignableFrom(method.getParameterTypes(), paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods = ReflectUtils.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        Method[] methods = ReflectUtils.getMethods(clazz);
        if (null == filter) {
            return methods;
        }
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods) {
            if (!filter.accept(method)) continue;
            methodList.add(method);
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Method[] allMethods = METHODS_CACHE.get(beanClass);
        if (null != allMethods) {
            return allMethods;
        }
        allMethods = ReflectUtils.getMethodsDirectly(beanClass, true);
        return METHODS_CACHE.put(beanClass, allMethods);
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSuperClassMethods) throws SecurityException {
        Assert.notNull(beanClass);
        Method[] allMethods = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Method[] declaredMethods = searchType.getDeclaredMethods();
            allMethods = null == allMethods ? declaredMethods : ArrayUtils.append(allMethods, declaredMethods);
            searchType = withSuperClassMethods ? searchType.getSuperclass() : null;
        }
        return allMethods;
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !ObjectUtils.equal(method.getName(), "equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return 1 == paramTypes.length && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && ObjectUtils.equal(method.getName(), "hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && ObjectUtils.equal(method.getName(), "toString") && method.getParameterTypes().length == 0;
    }

    public static <T> T newInstance(String clazz) throws InstrumentException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new InstrumentException(StringUtils.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws InstrumentException {
        if (ArrayUtils.isEmpty(params)) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw new InstrumentException(StringUtils.format("Instance class [{}] error!", clazz), e);
            }
        }
        Class<?>[] paramTypes = ClassUtils.getClasses(params);
        Constructor<T> constructor = ReflectUtils.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new InstrumentException("No Constructor matched for parameter types: [" + new Object[]{paramTypes} + "]");
        }
        try {
            return ReflectUtils.getConstructor(clazz, paramTypes).newInstance(params);
        }
        catch (Exception e) {
            throw new InstrumentException(StringUtils.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> beanClass) {
        Assert.notNull(beanClass);
        try {
            return ReflectUtils.newInstance(beanClass, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<T>[] constructors;
            for (Constructor<T> constructor : constructors = ReflectUtils.getConstructors(beanClass)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectUtils.setAccessible(constructor);
                try {
                    return constructor.newInstance(ClassUtils.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws InstrumentException {
        return ReflectUtils.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws InstrumentException {
        Class<?>[] types = method.getParameterTypes();
        if (null != types && null != args) {
            Assert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i = 0; i < args.length; ++i) {
                Class<?> type = types[i];
                if (!type.isPrimitive() || null != args[i]) continue;
                args[i] = ClassUtils.getDefaultValue(type);
            }
        }
        return ReflectUtils.invoke(obj, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws InstrumentException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (T)method.invoke(ClassUtils.isStatic(method) ? null : obj, args);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws InstrumentException {
        Method method = ReflectUtils.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new InstrumentException(StringUtils.format("No such method: [{}]", methodName));
        }
        return ReflectUtils.invoke(obj, method, args);
    }

    public static String getGetMethodName(String fieldName) {
        return GETTER_PREFIX + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String getSetMethodName(String fieldName) {
        return SETTER_PREFIX + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }
}

